/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.user.dashboard;

import gov.va.nvap.svc.consentmgmt.stub.dao.PatientConsentDirDAO;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.patient.PatientSearch;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;


/**
 *
 * @author Raul Alfaro
 */
public class ExpiringConsentsWidget extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet  {
    
    /**
     * Prepares and returns the data for the Expiring Consents Widget of the user dashboard
     * @param request
     * @param response
     * @throws IOException
     * @throws ServletException 
     */
    @Override
	public void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
        
		final HttpSession session = request.getSession(false);
        session.setAttribute("results", gatherExpiringConsentCount(session));

        this.forward(request, response, "searchResultsJSON");
	}
    
    /**
     * returns the amount of expiring consents in the next 30 days as a JSON object string,
     * two data points first being NwHIN Authorization type and second being SSA Authorization type.
     * @param session
     * @return 
     */
    public String gatherExpiringConsentCount(final HttpSession session){
        String jsonString = "";
        
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();

            obj.put("expiringNwHINConsents", expiringConsentsNwHIN(session));
            obj.put("expiringSSAConsents", expiringConsentsSSA(session));
            
            obj.write(json);

            jsonString = json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(PatientSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return jsonString;
    }
    
    /**
     * get total number of expiring consents with NwHIN Authorization as the consent Type
     * @param session
     * @return 
     */
    private long expiringConsentsNwHIN(HttpSession session){
        final PatientConsentDirDAO.SearchRequest searchRequest = prepareExpiringConsentRequest(session, "NwHIN Authorization");
        PatientConsentDirDAO dao = this.getPatientConsentDirDAO();
        PatientConsentDirDAO.SearchResponse searchResponse = dao.findCount(searchRequest);
        return searchResponse.count;
    }
    
    /**
     * get total number of expiring consents with SSA Authorization as the consent Type
     * @param session
     * @return 
     */
    private long expiringConsentsSSA(HttpSession session){
        final PatientConsentDirDAO.SearchRequest searchRequest = prepareExpiringConsentRequest(session, "SSA Authorization");
        PatientConsentDirDAO dao = this.getPatientConsentDirDAO();
        PatientConsentDirDAO.SearchResponse searchResponse = dao.findCount(searchRequest);
        return searchResponse.count;
    }
    
    /**
     * Prepares the request parameters required for the total number of expiring consents in the next 30 days
     * If a default facility isnt present in the session, All is used. Default values are all patients, 
     * NwHIN Authorization as consenttype, include unknown visn = true, no userid
     * @param session
     * @return 
     */
    private PatientConsentDirDAO.SearchRequest prepareExpiringConsentRequest(HttpSession session, String source){
        
        final gov.va.nvap.svc.facility.data.Facility facility = 
                (gov.va.nvap.svc.facility.data.Facility) session.getAttribute("defaultUserFacility");
        final PatientConsentDirDAO.SearchRequest searchRequest = 
                new PatientConsentDirDAO().new SearchRequest();
        
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        Date startDate = calendar.getTime();
        
        calendar.add(Calendar.DATE, 29);
        Date endDate = calendar.getTime();
        
        searchRequest.startDate = startDate;
        searchRequest.endDate = endDate;
        searchRequest.stationNumbers = (facility != null) ?
                facility.getFacilityStation() : "ALL";
        searchRequest.includeUnknownVisn = (facility == null);
        //Were gonna get both, just one at a time.
        searchRequest.consentTypeName = source;
        searchRequest.patientTypes = 1;
        searchRequest.userId = "";
        //the count query doesnt use the rest of the searchRequest parameters so they can be uninstantiated.
        
        return searchRequest;
    }
    
    private PatientConsentDirDAO getPatientConsentDirDAO() {
        return this.getBean("PatientConsentDirDAO", PatientConsentDirDAO.class);
    }
    
}
