package gov.va.nvap.web.user;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Zack Peterson
 */
public class User {

    private String name;
    private List<String> roles;

    public User() {}

    public User(String name) {
        this.name = name;
    }

    public User(String name, List<String> roles) {
        this.name = name;
        this.roles = roles;
    }

    public User(List<String> roles) {
        this.roles = roles;
    }

    public boolean hasName() {
        return !(name == null || name.isEmpty() || name.equals("null"));
    }

    public boolean hasRole(String roleName) {
        return roles != null && roles.contains(roleName);
    }

    public void addRole(String roleName) {
        if (roles == null) roles = new ArrayList<>();

        roles.add(roleName);
    }

    public boolean hasRoles() {
        return !(roles == null || roles.isEmpty());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }
}
