package gov.va.nvap.web.report;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.web.util.date.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class ReportDataProcessor {
	public static String fixStation(final String value) {
		// return (NullChecker.isNullOrEmpty(value) || "<UNKNOWN>".equals(value)
		// || "<UNAVAILABLE>".equals(value))? "Unknown" : value;
		String retVal = "";
		if (NullChecker.isNullOrEmpty(value)) {
			retVal = "Null";
		} else if ("<UNKNOWN>".equalsIgnoreCase(value)) {
			retVal = "Unknown";
		} else if ("<UNAVAILABLE>".equalsIgnoreCase(value)) {
			retVal = "Unavailable";
		} else if ("NULL".equalsIgnoreCase(value)) {
			retVal = "Null";
		} else {
			retVal = value;
		}
		return retVal;
	}

	public static boolean isValidStation(final String vaStation) {
		if (NullChecker.isNullOrEmpty(vaStation)
				|| "<UNKNOWN>".equalsIgnoreCase(vaStation)
				|| "NULL".equalsIgnoreCase(vaStation)
				|| "<UNAVAILABLE>".equalsIgnoreCase(vaStation)) {
			return false;
		}
		return true;
	}

	public static String nullEmptyReplaceWithUnknown(final String value) {
		return (NullChecker.isNullOrEmpty(value) || "<UNKNOWN>".equals(value) || "<UNAVAILABLE>"
				.equals(value)) ? "Unknown" : value;
	}
	
	/**
	 * Masks the given SSN so that only the last 4 digits are visible.
	 * 
	 * @param ssn SSN to be masked
	 * @return masked SSN
	 */
    public static String maskSsn(String ssn) {
        // Temporarily disable masking for testing purposes.
        if (NullChecker.isNullOrEmpty(ssn)){
            return "";
        } else if (ssn.matches("[0-9]{9}")) {
            return ssn.substring(0, 3) + "-" + ssn.substring(3, 5) + "-" + ssn.substring(5);
        } else if (ssn.matches("[0-9]{3}-[0-9]{2}-[0-9]{4}")) {
            return ssn;
        } else {
            return ssn;
        }
    }

    /**
     * Adds the given SSN to the result map that is passed to detailed report JSPs.
     * If SSN is valid, "ssn" parameter will contain the SSN and "ssnMasked" parameter will contain the masked SSN;
     * Otherwise, "ssn" parameter will be an empty strings, and "ssnMasked" will contain the relevant error information.
     * 
     * @param resultMap Result map to add SSN to
     * @param ssn SSN to be added to the result map
     */
    public static void addSsnToResultMap(Map<String, Object> resultMap, String ssn) {
        if (NullChecker.isNullOrEmpty(ssn)){
            resultMap.put("ssn", "");
            resultMap.put("ssnMasked", "Unavailable");                        
        } else if (ssn.matches("[0-9]{9}")) {
            resultMap.put("ssn", ssn);
            resultMap.put("ssnMasked", maskSsn(ssn));
        } else if (ssn.matches("[0-9]{3}-[0-9]{2}-[0-9]{4}")) {
            ssn = ssn.replaceAll("-", "");
            resultMap.put("ssn", ssn);
            resultMap.put("ssnMasked", maskSsn(ssn));
        } else {
            resultMap.put("ssn", "");
            resultMap.put("ssnMasked", "Unavailable");                        
        }        
    }
    
    public static String generatePatientLink(String ssn, String firstName, String lastName) {
        if (NullChecker.isNullOrEmpty(ssn) ||
            NullChecker.isNullOrEmpty(firstName) ||
            NullChecker.isNullOrEmpty(lastName) ||
            "unknown".equalsIgnoreCase(firstName) ||
            "unknown".equalsIgnoreCase(lastName)) {
            return maskSsn(ssn);
        } else {
            return "<a href=\"#\" onclick=\"linkToPatient('" + ssn.replace("-", "") + "', '" + lastName + "', '" + firstName + "');\">" + maskSsn(ssn) + "</a>";
        }
    }
    
    public static void setStartAndEndDates(HttpSession session, String startDate, String endDate, String attributePrefix) {
        String attributeStartDate = NullChecker.isNullOrEmpty(attributePrefix) ? "startDate" : attributePrefix + "StartDate";
        String attributeEndDate = NullChecker.isNullOrEmpty(attributePrefix) ? "endDate" : attributePrefix + "EndDate";

        Date sd = (Date) session.getAttribute(attributeStartDate);
        Date ed = (Date) session.getAttribute(attributeEndDate);

        if (sd == null) {
            if (!NullChecker.isNullOrEmpty(startDate)) {
                sd = DateUtil.parseDateMMddyyyy(startDate);
                session.setAttribute(attributeStartDate, sd);
            }
        }

        if (ed == null) {
            if (!NullChecker.isNullOrEmpty(endDate)) {
                ed = DateUtil.parseDateMMddyyyy(endDate);
                ed = DateUtil.voidTime(ed);
                ed = DateUtil.addTime(ed, Calendar.HOUR_OF_DAY, 23);
                ed = DateUtil.addTime(ed, Calendar.MINUTE, 59);
                ed = DateUtil.addTime(ed, Calendar.SECOND, 59);
                session.setAttribute(attributeEndDate, ed);
            }
        }        
    }
}
