/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.report;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.ActionValuesType;
import gov.va.med.nhin.adapter.audit.AuditSummariesType;
import gov.va.med.nhin.adapter.audit.AuditSummaryType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAuditsSummary;
import gov.va.med.nhin.adapter.audit.GetAuditsSummaryResponse;
import gov.va.med.nhin.adapter.audit.GroupByFieldsType;
import gov.va.med.nhin.adapter.audit.StringValuesType;
import gov.va.med.nhin.adapter.audit.SummaryFieldsType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.sort.BubbleSortListMap;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.privacy.OrganizationType;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.dao.FacilityDAO;
import gov.va.nvap.web.helper.document.DocumentHelper;
import gov.va.nvap.web.helper.facility.FacilityHelper;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.util.xls.ExcelExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.ss.usermodel.Workbook;

/**
 */
public class ReceivedNwHINDocumentSummaryReportResults extends
		ResponseDispatcherHttpServlet {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 2018359658104611915L;
	private AdapterAuditManager adapterAuditManager;

    /**
     * Export to excel - This method is called when the user clicks on the excel icon in the JSP. Reflection is used in the
     * ResponseDispatcherHttpServlet to call this method based on the http parameters.
     *
     * @param request HTTP Request
     * @param response HTTP Response
     * @throws ServletException
     * @throws IOException
     */
    public void exportToExcel(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        // Get the session
        final HttpSession session = request.getSession(false);
        // Get the results from the adapter with the paginator set to -1 (all
        // results)
        final List<Map<String, Object>> results = this.getResults(request.getSession());

        // Create a map of key which is based on the result data key and the
        // heading value
        final Map<String, String> receivedNwhinDocumentMap = new LinkedHashMap<String, String>();

        // Generate filters.
        final Map<String, List<Object>> filterMap = new LinkedHashMap<String, List<Object>>();
        final LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();

        filters.put("Start Date", this.getReportHelper().getFormattedDate((Date) session.getAttribute("receivedNwHINDocumentSummaryQueryStartDate")));
        filters.put("End Date", this.getReportHelper().getFormattedDate((Date) session.getAttribute("receivedNwHINDocumentSummaryQueryEndDate")));
        filters.put("User ID", session.getAttribute("receivedNwHINDocumentSummaryQueryUserId"));
        filters.put("Patient Preferred Facility", ExcelExporter.getPatientPreferredFacilityFilter(getFacilityDAO(), (String) session.getAttribute("receivedNwHINDocumentSummaryQueryFacility")));
        filters.put("eHealth Exchange Organization", ExcelExporter.getFilterValue(session.getAttribute("receivedNwHINDocumentSummaryQueryOrgName")));
        ExcelExporter.populateFilterMapForExport(request, filters, filterMap, session.getAttribute("patientTypes").toString());

        final Object receivedNwhinDocumentCount = session.getAttribute("receivedNwHINDocumentSummaryTotalCount");
        final Map<String, List<Object>> optionalRows = new LinkedHashMap<String, List<Object>>();
        final List<Object> receivedNwhinDocumentRow = new ArrayList<Object>();
        receivedNwhinDocumentRow.add(receivedNwhinDocumentCount);
        optionalRows.put("Grand Total", receivedNwhinDocumentRow);
        // Create the options selected list

        if (NullChecker.isNullOrEmpty(results)) {
            receivedNwhinDocumentMap.put("", "No records were found.");
        } else {
            // The heading is used to create the column headers and the key is used
            // to pull the data from the results
            receivedNwhinDocumentMap.put("partnerOrg", "eHealth Exchange Organization");
            receivedNwhinDocumentMap.put("vaFacility", "Patient Preferred Facility");
            receivedNwhinDocumentMap.put("vaFacilityNumber", "Patient Preferred Facility Station ID");
            receivedNwhinDocumentMap.put("oid", "OID");
            receivedNwhinDocumentMap.put("total", "Total");
        }

        // Create workbook
        final String title = "Received eHealth Exchange Documents Summary Report";
        final Workbook wb = this.getExcelExporter().exportToExcel(title, title, receivedNwhinDocumentMap, results, filterMap, optionalRows);

        // Write Excel to Stream
        this.getExcelExporter().writeExcelToStream("Received_eHealth_Exchange_Documents_Summary_Report", wb, response);
    }
    
	/**
	 * Get the consent management helper from Spring.
	 */
	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}

	/**
	 * Get the document helper from Spring.
	 */
	public DocumentHelper getDocumentHelper() {
		return this.getBean("adapterDocumentHelper", DocumentHelper.class);
	}

	/**
	 * Get the excel exporter class from Spring.
	 * 
	 * @return the excel exporter object
	 */
	public ExcelExporter getExcelExporter() {
		final ExcelExporter excelExporter = this.getBean("excelExporter",
				ExcelExporter.class);
		return excelExporter;
	}

	/**
	 * Get the facility helper from Spring.
	 */
	public FacilityHelper getFacilityHelper() {
		return this.getBean("facilityHelper", FacilityHelper.class);
	}

	public ReportHelper getReportHelper() {
		final ReportHelper reportHelper = this.getBean("reportHelper",
				ReportHelper.class);
		return reportHelper;
	}
	
	private List<Map<String, Object>> getResults(final HttpSession session) throws AuditException {
		final String patientFacility = (String) session
				.getAttribute("receivedNwHINDocumentSummaryQueryFacility");
		final String externalPartnerOrg = (String) session
				.getAttribute("receivedNwHINDocumentSummaryQueryOrganizations");
		final Date sd = (Date) session
				.getAttribute("receivedNwHINDocumentSummaryQueryStartDate");
		final Date ed = (Date) session
				.getAttribute("receivedNwHINDocumentSummaryQueryEndDate");
        final String userId = (String) session
                .getAttribute("receivedNwHINDocumentSummaryQueryUserId");
                
                final int patientTypes = (Integer) session.getAttribute("patientTypes");
		// sort
		final String receivedNwhinDocumentsSummaryReportSortValue = (String) session
				.getAttribute("receivedNwhinDocumentsSummaryReportSortValue");
		final String receivedNwhinDocumentsSummaryReportSortDirection = (String) session
				.getAttribute("receivedNwhinDocumentsSummaryReportSortDirection");

		final GetAuditsSummary getAuditsSummary = new GetAuditsSummary();

		// start time
		if (NullChecker.isNotEmpty(sd)) {
			getAuditsSummary.setFromDate(GregorianDateUtil
					.getGregorianCalendarByDate(sd));
		}
		// to time
		if (NullChecker.isNotEmpty(ed)) {
			getAuditsSummary.setToDate(GregorianDateUtil
					.getGregorianCalendarByDate(ed));
		}
        //Set User ID
        if (NullChecker.isNotEmpty(userId)) {
            final StringValuesType userIdValue = new StringValuesType();
            userIdValue.getValue().add(userId);
            userIdValue.setNotIn(false);
            getAuditsSummary.setUserIds(userIdValue);
        }
		final ActionValuesType actionValuesType = new ActionValuesType();
		final List<ActionType> actiontype = actionValuesType.getValue();
		actiontype.add(ActionType.RETRIEVE_DOCUMENT_OUT);
		actionValuesType.setNotIn(false);
		getAuditsSummary.setActions(actionValuesType);
                getAuditsSummary.setPatientTypes(patientTypes);

		// // sorting
		// if
		// (NullChecker.isNotEmpty(receivedNwhinDocumentsSummaryReportSortValue))
		// {
		// SortFieldType sortField = new SortFieldType();
		// sortField.setField(FieldType.fromValue(receivedNwhinDocumentsSummaryReportSortValue));
		// if
		// ("DESC".equalsIgnoreCase(receivedNwhinDocumentsSummaryReportSortDirection))
		// {
		// sortField.setDirection(SortDirection.DESC);
		// } else {
		// sortField.setDirection(SortDirection.ASC);
		// }
		// SortFieldsType sortFieldsType = new SortFieldsType();
		// sortFieldsType.getSortField().add(sortField);
		// getAuditsSummary.setSortFields(sortFieldsType);
		// }

		// patient preferred facility
		if (!NullChecker.isNullOrEmpty(patientFacility)) {

			final StringValuesType patientFacilyNumber = new StringValuesType();
			patientFacilyNumber.setNotIn(false);
			final List<String> patientFacilyNumberList = patientFacilyNumber
					.getValue();
			patientFacilyNumberList.add(patientFacility);
			getAuditsSummary.setPatientFacilityNumbers(patientFacilyNumber);
		}

		if (!NullChecker.isNullOrEmpty(externalPartnerOrg)
				&& !externalPartnerOrg.equals("external")) {
			final StringValuesType remoteOrganizationIds = new StringValuesType();
			remoteOrganizationIds.setNotIn(false);
			final List<String> remoteOrganizationIdsList = remoteOrganizationIds
					.getValue();
			remoteOrganizationIdsList.add(externalPartnerOrg.replace("%",
					"urn:oid:"));
			getAuditsSummary.setRemoteOrganizationIds(remoteOrganizationIds);
		}

		// group by
		final GroupByFieldsType groupByFieldsType = new GroupByFieldsType();
		final List<FieldType> fieldTypeList = groupByFieldsType
				.getGroupByField();
		fieldTypeList.add(FieldType.REMOTE_ORGANIZATION_ID);
		fieldTypeList.add(FieldType.PATIENT_FACILITY_NUMBER);
		fieldTypeList.add(FieldType.PATIENT_FACILITY_NAME);
		fieldTypeList.add(FieldType.REMOTE_ORGANIZATION_NAME);
		getAuditsSummary.setGroupByFields(groupByFieldsType);

		// web services response
		GetAuditsSummaryResponse getAuditsSummaryResponse;
		try {
			getAuditsSummaryResponse = this.adapterAuditManager
					.getAuditSummary(getAuditsSummary);
		} catch (final AuditException e) {
			throw new AuditException();
		}

		final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
		long totalCount = 0l;
		final AuditSummariesType auditSummariesType = getAuditsSummaryResponse
				.getAuditSummaries();
		//
		List<AuditSummaryType> auditSummary = new ArrayList<AuditSummaryType>();
		if (auditSummariesType != null) {
			auditSummary = auditSummariesType.getAuditSummary();
		}
		for (final AuditSummaryType auditSummaryType2 : auditSummary) {
			final AuditSummaryType auditSummaryType = auditSummaryType2;

			final Map<String, Object> resultMap = new HashMap<String, Object>();
			final long count = auditSummaryType.getCount();
			final SummaryFieldsType summaryFields = auditSummaryType
					.getSummaryFields();
			final List<String> summaryField = summaryFields.getSummaryField();

			if (NullChecker.isEmpty(summaryField)) {
				continue;
			}

			if (summaryField.size() < 4) {
				continue;
			}

			OrganizationType organizationType = null;
			if (NullChecker.isNotEmpty(summaryField.get(0))) {
				organizationType = (this.getCmsHelper()
						.getOrganizationByHomeCommunityId(summaryField.get(0)
								.replace("urn:oid:", "")));
                if (!NullChecker.isNullOrEmpty(organizationType)) {
                    resultMap.put("oid", ReportDataProcessor.nullEmptyReplaceWithUnknown(organizationType.getOrgOid()));
                }
                else {
                    resultMap.put("oid", "Unknown");
                }
			}

			if (organizationType != null && !NullChecker.isNullOrEmpty(organizationType)) {
				resultMap.put("partnerOrg", ReportDataProcessor
						.nullEmptyReplaceWithUnknown(organizationType
								.getOrgName()));
			} else {
				resultMap.put("partnerOrg", ReportDataProcessor
						.nullEmptyReplaceWithUnknown(summaryField.get(3)));
			}
			// Extract value
			final String adapterVAFacility = summaryField.get(1);
                        if(!NullChecker.isNullOrEmpty(adapterVAFacility)) {
                            resultMap.put("vaFacilityNumber", ReportDataProcessor
						.nullEmptyReplaceWithUnknown(adapterVAFacility));
                        }
			String vaFacility = "";
			if (ReportDataProcessor.isValidStation(adapterVAFacility)) {
				vaFacility = this.getFacilityHelper()
						.getFacilityNameByStationId(adapterVAFacility);
				if (NullChecker.isEmpty(vaFacility)) {
					vaFacility = summaryField.get(2);
				}
			} else {
				vaFacility = summaryField.get(2);
			}
			resultMap.put("vaFacility",
					ReportDataProcessor.fixStation(vaFacility));
			// resultMap.put("vaFacility",
			// ReportDataProcessor.nullEmptyReplaceWithUnknownFacility(vaFacility));
                        
			resultMap.put("vaFacility",
					ReportDataProcessor.fixStation(vaFacility));
                        
			resultMap.put("total", count);
			results.add(resultMap);
			totalCount += count;

		}
		session.setAttribute("receivedNwHINDocumentSummaryTotalCount",
				totalCount);
		// sort
		if (!NullChecker
				.isNullOrEmpty(receivedNwhinDocumentsSummaryReportSortValue)
				&& !NullChecker
						.isNullOrEmpty(receivedNwhinDocumentsSummaryReportSortDirection)) { // first
																							// time
																							// through,
																							// no
																							// sort
																							// specified
			boolean ascending = true;
			if (receivedNwhinDocumentsSummaryReportSortDirection
					.equalsIgnoreCase("DESC")) {
				ascending = false;
			}
			final BubbleSortListMap bSorter = new BubbleSortListMap();
			return bSorter.sortByColumn(results,
					receivedNwhinDocumentsSummaryReportSortValue, ascending);
		}
		return results;
	}

	@EJB(beanInterface = AdapterAuditManager.class, mappedName = "AdapterAuditManager")
	public void setAdapterAuditManager(
			final AdapterAuditManager adapterAuditManager) {
		this.adapterAuditManager = adapterAuditManager;
	}

	@Override
	public void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws IOException, ServletException {
		final HttpSession session = request.getSession(false);

		// sort
		final String receivedNwhinDocumentsSummaryReportSortValue = request
				.getParameter("receivedNwhinDocumentsSummaryReportSortValue");
		final String receivedNwhinDocumentsSummaryReportSortDirection = request
				.getParameter("receivedNwhinDocumentsSummaryReportSortDirection");
		session.setAttribute("receivedNwhinDocumentsSummaryReportSortValue",
				receivedNwhinDocumentsSummaryReportSortValue);
		session.setAttribute(
				"receivedNwhinDocumentsSummaryReportSortDirection",
				receivedNwhinDocumentsSummaryReportSortDirection);

        try {
            session.setAttribute("receivedNwHINDocumentSummaryResults",this.getResults(session));
        } catch(AuditException e) {
            throw new AuditException(e);
        }
        
		this.forward(request, response, "show");
	}

    private FacilityDAO getFacilityDAO() {
        return this.getBean("FacilityDAO", FacilityDAO.class);
    }
    
}
