/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.report;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.ActionValuesType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldType;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.StringValuesType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.service.pdq.PdqService;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.dao.UserDocumentDAO;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.patient.ExcelGeneratorThread;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.util.Paginator;
import gov.va.nvap.web.util.date.DateUtil;
import gov.va.nvap.web.util.xls.CsvExporter;
import gov.va.nvap.web.util.xls.ExcelExporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * edited by Irakli Kakushadze
 */
public class PatientDiscoveryReportResults extends ResponseDispatcherHttpServlet {

    /**
     * Serial UID.
     */
    private static final long serialVersionUID = -1105605958616174460L;
    // private static final Logger logger =
    // Logger.getLogger(PatientDiscoveryReportResults.class
    // .getName());
    private AdapterAuditManager adapterAuditManager;
    @EJB(beanInterface = PdqService.class, mappedName = "PdqService")
    PdqService pdqService;

    public void exportToCsv(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException, IOException {

        final List<Map<String, Object>> results = this.getResults(
            request.getSession(), new Paginator(this.getReportHelper().getConsentDirectivesReportCapAsInt()));

        CsvExporter csvExporter = new CsvExporter();

        Map<String, String> csvReportMap = new LinkedHashMap<String, String>();

        csvReportMap.put("Date Received (CT)", "auditTimeFormatted");
        csvReportMap.put("SSN", "ssn");
        csvReportMap.put("Patient Last Name", "lastName");
        csvReportMap.put("Patient First Name", "firstName");
        csvReportMap.put("Patient Middle Name", "middleName");
        csvReportMap.put("Purpose of Use", "purposeOfUse");
        csvReportMap.put("Sender", "facility");
        csvReportMap.put("Sender OID", "facilityOid");
        csvReportMap.put("Receiver", "remoteFacility");
        csvReportMap.put("Receiver OID", "remoteFacilityOid");
        csvReportMap.put("Message", "message");
        csvReportMap.put("Explanation of Failure", "failureExplanation");
        csvReportMap.put("Details", "details");

        csvExporter.exportToCSV(response, "Patient_Discovery_Audit_Detail_Report", results, (LinkedHashMap<String, String>) csvReportMap);
    }

    /**
     * Export to excel - This method is called when the user clicks on the excel
     * icon in the JSP. Reflection is used in the ResponseDispatcherHttpServlet
     * to call this method based on the http parameters.
     *
     * @param request HTTP Request
     * @param response HTTP Response
     * @throws ServletException
     * @throws IOException
     */
    public void exportToExcel(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        ExcelGeneratorThread exGenThread = new ExcelGeneratorThread("exGenThread");

        //Get the session final
        HttpSession session = request.getSession(false);

        //      Create a map of key which is based on the result data key and the
        //      heading value The heading is used to create the column headers and the
        //      key is used to pull the data from the results
        final Map<String, String> patientDiscoveryMap = new LinkedHashMap<String, String>();

        // Set the optional rows
        final Object startDateStr = session.getAttribute("patientDiscoveryQueryStartDate");
        final Object endDateStr = session.getAttribute("patientDiscoveryQueryEndDate");
        final Object patientMpiResPmpi = session.getAttribute("patientDiscoveryMPIResults");

        // Generate filters.
        final Map<String, List<Object>> filterMap = new LinkedHashMap<String, List<Object>>();
        final LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();

        filters.put("Start Date", this.getReportHelper().getFormattedDate((Date) startDateStr));
        filters.put("End Date", this.getReportHelper().getFormattedDate((Date) endDateStr));
        filters.put("SSN", session.getAttribute("patientDiscoveryQuerySSN"));
        filters.put("Last Name", session.getAttribute("patientDiscoveryQueryLastName"));
        filters.put("First Name", session.getAttribute("patientDiscoveryQueryFirstName"));
        filters.put("User ID", session.getAttribute("patientDiscoveryQueryUserId"));
        filters.put("MPI Results", ExcelExporter.getFilterValue(patientMpiResPmpi));
        filters.put("eHealth Exchange Org", ExcelExporter.getFilterValue(session.getAttribute("patientDiscoveryQueryOrgName")));
        ExcelExporter.populateFilterMapForExport(request, filters, filterMap, session.getAttribute("patientTypes").toString());
        exGenThread.setFilterMap(filterMap);

        patientDiscoveryMap.put("auditTimeFormatted", "Date Received (CT)");
        patientDiscoveryMap.put("ssn", "SSN");
        patientDiscoveryMap.put("lastName", "Patient Last Name");
        patientDiscoveryMap.put("firstName", "Patient First Name");
        patientDiscoveryMap.put("middleName", "Patient Middle Name");
        patientDiscoveryMap.put("purposeOfUse", "Purpose of Use");
        patientDiscoveryMap.put("facility", "Sender");
        patientDiscoveryMap.put("facilityOid", "Sender OID");
        patientDiscoveryMap.put("remoteFacility", "Receiver");
        patientDiscoveryMap.put("remoteFacilityOid", "Receiver OID");
        patientDiscoveryMap.put("message", "Message");
        patientDiscoveryMap.put("failureExplanation", "Explanation of Failure");
        patientDiscoveryMap.put("details", "Details");
        exGenThread.setReportMap(patientDiscoveryMap);

        exGenThread.setHasOptionalRows(true);
        exGenThread.setOptionalRowsMap(createOptionalRowsMap(Integer.valueOf(
                session.getAttribute("patientTypes").toString())));

        // Set names for Excel generator thread
        exGenThread.setTitle("Patient Discovery Audit Detailed Report");

        exGenThread.setExcelExporter(this.getExcelExporter());
        exGenThread.setAdapterAuditManager(adapterAuditManager);
        exGenThread.setReportHelper(getReportHelper());
        exGenThread.setUserId(UserHelper.getUserName(request));
        exGenThread.setUserDocumentDao(getUserDocumentDAO());

        // Set search attributes for getting audit results
        exGenThread.setAttributes(mapSessionAttributes(session));

        exGenThread.start();

        this.forward(request, response, "show");
    }

    private Map<String, Object> mapSessionAttributes(HttpSession session) {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("icn", (String) session
                .getAttribute("patientDiscoveryQueryICN"));
        attributes.put("ssn", (String) session
                .getAttribute("patientDiscoveryQuerySSN"));
        attributes.put("lastName", (String) session
                .getAttribute("patientDiscoveryQueryLastName"));
        attributes.put("firstName", (String) session
                .getAttribute("patientDiscoveryQueryFirstName"));
        attributes.put("userId", (String) session
                .getAttribute("patientDiscoveryQueryUserId"));

        // Add 24 hours to end date if same as start date
        Date startDate = (Date) session.getAttribute("patientDiscoveryQueryStartDate");
        Date endDate = (Date) session.getAttribute("patientDiscoveryQueryEndDate");
        if (NullChecker.isNotEmpty(endDate)) {
            if (endDate.equals(startDate)) {
                endDate = DateUtil.addTime(endDate, Calendar.HOUR, 24);
            }
        }
        attributes.put("startDate", startDate);
        attributes.put("endDate", endDate);

        // Set both sender and receiver org to the organization entered
        attributes.put("organization", (String) session
                .getAttribute("patientDiscoveryQueryOrganization"));
        attributes.put("remoteOrganization", (String) session
                .getAttribute("patientDiscoveryQueryOrganization"));

        attributes.put("mpiMatch", (String) session
                .getAttribute("patientDiscoveryMPIResults"));
        attributes.put("patientTypes", (Integer) session.getAttribute("patientTypes"));
        // sort
        attributes.put("sortValue", (String) session
                .getAttribute("patientDiscoverySortValue"));
        attributes.put("sortDirection", (String) session
                .getAttribute("patientDiscoverySortDirection"));

        // Set Action Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.ANNOUNCE);
        actionsType.getValue().add(ActionType.CHECK_POLICY);
        actionsType.getValue().add(ActionType.MPI_FIND_MATCH);
        actionsType.getValue().add(ActionType.ADD_PATIENT_CORRELATION);
        actionsType.setNotIn(false);
        attributes.put("actionsType", actionsType);

        return attributes;
    }

    Map<String, String> createOptionalRowsMap(int patientTypes) {
        Map<String, String> optionalRowsMap = new LinkedHashMap<String, String>();

        if (patientTypes == 1) {
            optionalRowsMap.put("uniqueRealPatients", "Unique patients");
            optionalRowsMap.put("realPatientMessages", "Total messages");
            optionalRowsMap.put("realPatientFails", "Match failures");
            optionalRowsMap.put("realPatientMatches", "Matches found");
        } else if (patientTypes == 2) {
            optionalRowsMap.put("uniqueTestPatients", "Unique patients");
            optionalRowsMap.put("testPatientMessages", "Total messages");
            optionalRowsMap.put("testPatientFails", "Match failures");
            optionalRowsMap.put("testPatientMatches", "Matches found");
        } else {
            optionalRowsMap.put("uniqueRealPatients", "Unique real patients");
            optionalRowsMap.put("realPatientMessages", "Total messages for real patients");
            optionalRowsMap.put("realPatientFails", "Match failures for real patients");
            optionalRowsMap.put("realPatientMatches", "Matches found for real patients");

            optionalRowsMap.put("", "");

            optionalRowsMap.put("uniqueTestPatients", "Unique test patients");
            optionalRowsMap.put("testPatientMessages", "Total messages for test patients");
            optionalRowsMap.put("testPatientFails", "Match failures for test patients");
            optionalRowsMap.put("testPatientMatches", "Matches found for test patients");
        }

        return optionalRowsMap;
    }

    public ConsentManagementHelper getCmsHelper() {
        final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
                ConsentManagementHelper.class);
        return cmsHelper;
    }

    /**
     * Get the excel exporter class from Spring.
     *
     * @return the excel exporter object
     */
    public ExcelExporter getExcelExporter() {
        final ExcelExporter excelExporter = this.getBean("excelExporter",
                ExcelExporter.class);
        return excelExporter;
    }

    public ReportHelper getReportHelper() {
        final ReportHelper reportHelper = this.getBean("reportHelper",
                ReportHelper.class);
        return reportHelper;
    }

    public List<Map<String, Object>> getResults(final HttpSession session,
            final Paginator paginator) throws AuditException {
        final String icn = (String) session
                .getAttribute("patientDiscoveryQueryICN");
        final String ssn = (String) session
                .getAttribute("patientDiscoveryQuerySSN");
        final String lastName = (String) session
                .getAttribute("patientDiscoveryQueryLastName");
        final String firstName = (String) session
                .getAttribute("patientDiscoveryQueryFirstName");
        final String patientDiscoveryUserId = (String) session
                .getAttribute("patientDiscoveryQueryUserId");
        final Date sd = (Date) session
                .getAttribute("patientDiscoveryQueryStartDate");
        Date ed = (Date) session.getAttribute("patientDiscoveryQueryEndDate");
        final String organization = (String) session
                .getAttribute("patientDiscoveryQueryOrganization");
        String mpiMatch = (String) session
                .getAttribute("patientDiscoveryMPIResults");
        final int patientTypes = (Integer) session.getAttribute("patientTypes");
        // sort
        final String patientDiscoverySortValue = (String) session
                .getAttribute("patientDiscoverySortValue");
        final String patientDiscoverySortDirection = (String) session
                .getAttribute("patientDiscoverySortDirection");

        if (mpiMatch.equalsIgnoreCase("all")) {
            mpiMatch = null;
        }

        final GetAudits getAuditsRequest = new GetAudits();
        if (NullChecker.isNotEmpty(sd)) {
            getAuditsRequest.setFromDate(GregorianDateUtil
                    .getGregorianCalendarByDate(sd));
        }
        if (NullChecker.isNotEmpty(ed)) {
            if (ed.equals(sd)) {
                ed = DateUtil.addTime(ed, Calendar.HOUR, 24);
            }
            getAuditsRequest.setToDate(GregorianDateUtil
                    .getGregorianCalendarByDate(ed));
        }

        // Set Patient Types
        getAuditsRequest.setPatientTypes(patientTypes);

        // Set Patient Ids
        if (NullChecker.isNotEmpty(icn)) {
            final StringValuesType patientIds = new StringValuesType();
            patientIds.getValue().add(icn);
            patientIds.setNotIn(false);
            getAuditsRequest.setPatientIds(patientIds);
        }
        // Set SSN
        if (NullChecker.isNotEmpty(ssn)) {
            String[] ssns = ssn.split(",");
            final StringValuesType patientSSNs = new StringValuesType();
            for (String ssnEntry : ssns) {
                patientSSNs.getValue().add(ssnEntry);
            }
            patientSSNs.setNotIn(false);
            getAuditsRequest.setPatientSSNs(patientSSNs);
        }
        // Set Last Name
        if (NullChecker.isNotEmpty(lastName)) {
            final StringValuesType patientLastNames = new StringValuesType();
            patientLastNames.getValue().add(lastName);
            patientLastNames.setNotIn(false);
            getAuditsRequest.setPatientLastNames(patientLastNames);
        }
        // Set First Name
        if (NullChecker.isNotEmpty(firstName)) {
            final StringValuesType patientFirstNames = new StringValuesType();
            patientFirstNames.getValue().add(firstName);
            patientFirstNames.setNotIn(false);
            getAuditsRequest.setPatientGivenNames(patientFirstNames);
        }
        // Set User ID
        if (NullChecker.isNotEmpty(patientDiscoveryUserId)) {
            final StringValuesType userId = new StringValuesType();
            userId.getValue().add(patientDiscoveryUserId);
            userId.setNotIn(false);
            getAuditsRequest.setUserIds(userId);
        }
        // Set Organization Ids
        final StringValuesType orgTypes = new StringValuesType();
        if (NullChecker.isNotEmpty(organization)) {
            orgTypes.getValue().add(organization);
        }
        orgTypes.setNotIn(false);
        getAuditsRequest.setRemoteOrganizationIds(orgTypes);
        getAuditsRequest.setOrganizationIds(orgTypes);

        // sorting
        if (NullChecker.isNotEmpty(patientDiscoverySortValue)) {
            final SortFieldType sortField = new SortFieldType();
            sortField.setField(FieldType.fromValue(patientDiscoverySortValue));
            if ("DESC".equalsIgnoreCase(patientDiscoverySortDirection)) {
                sortField.setDirection(SortDirection.DESC);
            } else {
                sortField.setDirection(SortDirection.ASC);
            }
            final SortFieldsType sortFieldsType = new SortFieldsType();
            sortFieldsType.getSortField().add(sortField);
            getAuditsRequest.setSortFields(sortFieldsType);
        }

        // Set Action Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.ANNOUNCE);
        actionsType.getValue().add(ActionType.CHECK_POLICY);
        actionsType.getValue().add(ActionType.MPI_FIND_MATCH);
        actionsType.getValue().add(ActionType.ADD_PATIENT_CORRELATION);
        actionsType.setNotIn(false);
        getAuditsRequest.setActions(actionsType);
        // Set MPI Match
        if ("all".equals(mpiMatch) || NullChecker.isEmpty(mpiMatch)) {
            getAuditsRequest.setDetails(null);
        } else {
            getAuditsRequest.setDetails(mpiMatch);
        }
        // Set Page Information
        final PageInfoType pageInfoType = new PageInfoType();
        pageInfoType.setPageNumber(paginator.getCurrentPage());
        pageInfoType.setPageSize(paginator.getRecordsPerPage());
        getAuditsRequest.setPageInfo(pageInfoType);
        // TODO: Anand Sastry / Weimin Shi - FIX INTEGRATION 08/29/2011 - END
        final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try {
            final GetAuditsResponse queryResponse = this.adapterAuditManager
                    .getAudits(getAuditsRequest);
            int realPatientMessages = 0;
            int realPatientFails = 0;
            int realPatientMatches = 0;
            int testPatientMessages = 0;
            int testPatientFails = 0;
            int testPatientMatches = 0;
            HashSet<String> uniqueRealPatients = new HashSet<String>();
            HashSet<String> uniqueTestPatients = new HashSet<String>();

            if (NullChecker.isNotEmpty(queryResponse)
                    && NullChecker.isNotEmpty(queryResponse.getAudits())
                    && NullChecker.isNotEmpty(queryResponse.getAudits().getAudit())) {
                final List<AuditType> auditTypeList = queryResponse.getAudits().getAudit();
                int pageSize = paginator.getRecordsPerPage();
                for (final AuditType auditType : auditTypeList) {
                    final Map<String, Object> resultMap = new HashMap<String, Object>();
                    String explanationOfFailure = "N/A";
                    String patientFirstName = "";
                    String patientLastName = "";
                    String patientMiddleName = "";
                    String patientSSN = "";
                    Boolean mviFindMatchFailed = null;

                    String details = ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getDetails());
                    if (details.startsWith("QUERY FAILED")) {
                        explanationOfFailure = "MVI: Query Failed";
                        mviFindMatchFailed = true;
                    } else if (details.startsWith("MATCH FAILED")) {
                        explanationOfFailure = "MVI: Match Not Found";
                        mviFindMatchFailed = true;
                    } else if (details.startsWith("AMBIGUOUS FAILED")) {
                        explanationOfFailure = "MVI: Ambiguous Match";
                        mviFindMatchFailed = true;
                    } else if (details.startsWith("MATCH FOUND")) {
                        mviFindMatchFailed = false;
                    }
                    resultMap.put("failureExplanation", explanationOfFailure);

                    ReportHelper reportHelper = getReportHelper();
                    if (Boolean.TRUE.equals(mviFindMatchFailed)) {
                        patientFirstName = getReportHelper().extractFromDetails(details, "FIRSTNAME");
                        patientLastName = reportHelper.extractFromDetails(details, "LASTNAME");
                        patientMiddleName = reportHelper.extractFromDetails(details, "MIDDLENAME");
                        patientSSN = reportHelper.extractFromDetails(details, "SSN");
                    }
                    if (patientSSN.length() == 0) {
                        patientSSN = auditType.getPatientSSN();
                    }

                    // SSN
                    ReportDataProcessor.addSsnToResultMap(resultMap, patientSSN);

                    boolean isTestPatient = this.getReportHelper().isTestPatient(resultMap.get("ssn").toString());

                    if (NullChecker.isNotEmpty(patientSSN)) {
                        if (isTestPatient) {
                            if (!uniqueTestPatients.contains(patientSSN)) {
                                uniqueTestPatients.add(patientSSN);
                            }
                        } else {
                            if (!uniqueRealPatients.contains(patientSSN)) {
                                uniqueRealPatients.add(patientSSN);
                            }
                        }
                    }

                    if (pageSize == -1 || (testPatientMessages + realPatientMessages) < pageSize) {
                        if (isTestPatient) {
                            testPatientMessages++;
                            if (Boolean.TRUE.equals(mviFindMatchFailed)) {
                                testPatientFails++;
                            } else if (Boolean.FALSE.equals(mviFindMatchFailed)) {
                                testPatientMatches++;
                            }
                        } else {
                            realPatientMessages++;
                            if (Boolean.TRUE.equals(mviFindMatchFailed)) {
                                realPatientFails++;
                            } else if (Boolean.FALSE.equals(mviFindMatchFailed)) {
                                realPatientMatches++;
                            }
                        }
                    }

                    // First name.
                    if (patientFirstName.length() == 0) {
                        patientFirstName = ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getPatientGivenName());
                    }
                    resultMap.put("firstName", patientFirstName);

                    // Middle name.
                    if (patientMiddleName.length() == 0) {
                        patientMiddleName =  ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getPatientMiddleName());
                    }
                    if ("Unknown".equalsIgnoreCase(patientMiddleName)) {
                        patientMiddleName = "";
                    }
                    resultMap.put("middleName", patientMiddleName);

                    // Last name.
                    if (patientLastName.length() == 0) {
                        patientLastName = ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getPatientLastName());
                    }
                    resultMap.put("lastName", patientLastName);

                    resultMap.put("icn", ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getPatientId()));
                    resultMap.put("auditTime", GregorianDateUtil.getDateFromGregorianCalendar(auditType.getAuditTime()));
                    resultMap.put("auditTimeFormatted",
                            this.getReportHelper()
                            .getFormattedDateTime(
                            GregorianDateUtil
                            .getDateFromGregorianCalendar(auditType
                            .getAuditTime())));
                    resultMap.put("userId", ReportDataProcessor
                            .nullEmptyReplaceWithUnknown(auditType
                            .getUserId()));
                    resultMap.put("purposeOfUse", ReportDataProcessor
                            .nullEmptyReplaceWithUnknown(auditType
                            .getPurposeForUse()));
                    resultMap.put("facilityOid", ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getOrganizationId()));
                    resultMap.put("facility", ReportDataProcessor
                            .nullEmptyReplaceWithUnknown(auditType
                            .getOrganizationName()));
                    // if
                    // (NullChecker.isNullOrEmpty(auditType.getOrganizationId()))
                    // {
                    // logger.warning("RemoteOrganizationId Id is null/empty for audit record["
                    // + auditType.getAuditId() + "], audit details["+
                    // auditType.getDetails() + "]");
                    // }
                    resultMap.put("remoteFacilityOid", ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getRemoteOrganizationId()));
                    resultMap.put("remoteFacility", ReportDataProcessor
                            .nullEmptyReplaceWithUnknown(auditType
                            .getRemoteOrganizationName()));
                    /*
                     * if
                     * (NullChecker.isNullOrEmpty(auditType.getOrganizationId(
                     * ))) { Logger.warning(
                     * "Organization Id is null/empty for audit record[" +
                     * auditType.getAuditId() + "], audit details["+
                     * auditType.getDetails() + "]"); } resultMap.put(
                     * "facility", this.getCmsHelper()
                     * .getOrganizationByHomeCommunityId(
                     * auditType.getOrganizationId())); if
                     * (NullChecker.isNullOrEmpty
                     * (auditType.getOrganizationId())) { Logger.warning(
                     * "RemoteOrganizationId Id is null/empty for audit record["
                     * + auditType.getAuditId() + "], audit details["+
                     * auditType.getDetails() + "]"); } resultMap.put(
                     * "remoteFacility", this.getCmsHelper()
                     * .getOrganizationByHomeCommunityId(
                     * auditType.getRemoteOrganizationId()));
                     */
                    if (NullChecker.isNotEmpty(auditType.getAction())) {
                        resultMap.put("message", auditType.getAction().name());
                    }

                    details = processDatails(details);

                    resultMap.put("details", details);

                    results.add(resultMap);
                }

                /*
                 * if (NullChecker.isNullOrEmpty(auditType.getOrganizationId(
                 * ))) { Logger.warning(
                 * "Organization Id is null/empty for audit record[" +
                 * auditType.getAuditId() + "], audit details["+
                 * auditType.getDetails() + "]"); } resultMap.put( "facility",
                 * this.getCmsHelper() .getOrganizationByHomeCommunityId(
                 * auditType.getOrganizationId())); if
                 * (NullChecker.isNullOrEmpty (auditType.getOrganizationId())) {
                 * Logger.warning(
                 * "RemoteOrganizationId Id is null/empty for audit record[" +
                 * auditType.getAuditId() + "], audit details["+
                 * auditType.getDetails() + "]"); } resultMap.put(
                 * "remoteFacility", this.getCmsHelper()
                 * .getOrganizationByHomeCommunityId(
                 * auditType.getRemoteOrganizationId()));
                 */
            }
            //set these outside of the null checker just in case we get an empty response we still display counts
            session.setAttribute("realPatientMessages", realPatientMessages);
            session.setAttribute("realPatientFails", realPatientFails);
            session.setAttribute("realPatientMatches", realPatientMatches);
            session.setAttribute("testPatientMessages", testPatientMessages);
            session.setAttribute("testPatientFails", testPatientFails);
            session.setAttribute("testPatientMatches", testPatientMatches);
            session.setAttribute("uniqueRealPatients", uniqueRealPatients.size());
            session.setAttribute("uniqueTestPatients", uniqueTestPatients.size());
            return results;

        } catch (final AuditException ex) {
            throw new AuditException(ex);
        }

    }

    /**
     * Processes Details property as follows:
     * - Masks SSN
     * - Replaces "MOTHERSMAIDENNAME" with "MMN"
     * @param details Details property of AuditType
     * @return Processed Details property string
     */
    private String processDatails(String details) {
        // Mask SSN
        int pos1 = details.indexOf("SSN=");
        int pos2;
        String ssn;
        if (pos1 !=  -1) {
            pos2 = details.indexOf(",", pos1);
            if (pos2 != -1) {
                ssn = details.substring(pos1 + 4, pos2).trim();
                if (ssn.length() > 0) {
                    details = details.substring(0, pos1 + 4) + ReportDataProcessor.maskSsn(ssn) + details.substring(pos2);
                }
            }
        }
        // Replace "MOTHERSMAIDENNAME" with "MMN"
        if (details.contains("MOTHERSMAIDENNAME=")) {
            details = details.replace("MOTHERSMAIDENNAME=", "MMN=");
        }
        return details;
    }

    private boolean isPaginatorPresent(final HttpSession session) {
        return !NullChecker.isNullOrEmpty(session.getAttribute("paginator"));
    }

    public void next(final HttpServletRequest request,
            final HttpServletResponse response) throws ServletException,
            IOException {
        final HttpSession session = request.getSession(false);
        if (this.isPaginatorPresent(session)) {
            final Paginator paginator = (Paginator) session
                    .getAttribute("paginator");
            paginator.next(request);
            session.setAttribute("paginator", paginator);
            session.setAttribute("patientDiscoveryResults",
                    this.getResults(session, paginator));
            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    public void prev(final HttpServletRequest request,
            final HttpServletResponse response) throws ServletException,
            IOException {
        final HttpSession session = request.getSession(false);
        if (this.isPaginatorPresent(session)) {
            final Paginator paginator = (Paginator) session
                    .getAttribute("paginator");
            paginator.previous(request);
            session.setAttribute("paginator", paginator);
            session.setAttribute("patientDiscoveryResults",
                    this.getResults(session, paginator));
            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    @EJB(beanInterface = AdapterAuditManager.class, mappedName = "AdapterAuditManager")
    public void setAdapterAuditManager(
            final AdapterAuditManager adapterAuditManager) {
        this.adapterAuditManager = adapterAuditManager;
    }

    @Override
    protected void unspecified(final HttpServletRequest request,
            final HttpServletResponse response) throws ServletException,
            IOException {
        final HttpSession session = request.getSession(false);

        // sort
        final String patientDiscoverySortValue = request
                .getParameter("patientDiscoverySortValue");
        final String patientDiscoverySortDirection = request
                .getParameter("patientDiscoverySortDirection");
        session.setAttribute("patientDiscoverySortValue",
                patientDiscoverySortValue);
        session.setAttribute("patientDiscoverySortDirection",
                patientDiscoverySortDirection);

        if (this.isPaginatorPresent(session)) {
            Paginator paginator = (Paginator) session.getAttribute("paginator");
            if (NullChecker.isEmpty(paginator)) {
                paginator = new Paginator(0);
                session.setAttribute("paginator", paginator);
            }
            paginator.reset();
            session.setAttribute("patientDiscoveryResults",
                    this.getResults(session, paginator));
            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    private UserDocumentDAO getUserDocumentDAO() {
        return this.getBean("UserDocumentDAO", UserDocumentDAO.class);
    }
}
