package gov.va.nvap.web.report;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.ActionValuesType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldType;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.StringValuesType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.adapter.doc.AdapterException;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.dao.FacilityDAO;
import gov.va.nvap.web.dao.UserDocumentDAO;
import gov.va.nvap.web.helper.document.DocumentHelper;
import gov.va.nvap.web.helper.facility.FacilityHelper;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.patient.ExcelGeneratorThread;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.util.Paginator;
import gov.va.nvap.web.util.xls.CsvExporter;
import gov.va.nvap.web.util.xls.ExcelExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * @author Asha Amritraj
 */
public class InboundDocumentReportResults extends ResponseDispatcherHttpServlet {
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = -568337606603465744L;

	private AdapterAuditManager adapterAuditManager;

    public void exportToCsv(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException, IOException {

        final List<Map<String, Object>> results = this.getResults(
            request.getSession(), new Paginator(this.getReportHelper().getConsentDirectivesReportCapAsInt()));

        CsvExporter csvExporter = new CsvExporter();

        Map<String, String> csvReportMap = new LinkedHashMap<String, String>();

        csvReportMap.put("SSN", "ssn");
        csvReportMap.put("Patient Last Name", "lastName");
        csvReportMap.put("Patient First Name", "firstName");
        csvReportMap.put("Date Received (CT)", "auditTimeFormatted");
        csvReportMap.put("Document Title", "documentTitle");
        csvReportMap.put("Patient Preferred Facility", "patientFacilityName");
        csvReportMap.put("Patient Preferred Facility Station ID", "patientFacilityNumber");
        csvReportMap.put("eHealth Exchange Organization", "remoteOrganizationName");
        csvReportMap.put("OID", "remoteOrganizationId");
        csvReportMap.put("User ID", "userId");
        csvReportMap.put("User Facility Code", "userFacilityCode");
        csvReportMap.put("User Facility", "userFacilityName");
        csvReportMap.put("Purpose of Use", "purposeForUse");
        csvReportMap.put("User Role", "roleName");

        csvExporter.exportToCSV(response, "Received_eHealth_Exchange_Documents_Detail_Report", results, (LinkedHashMap<String, String>) csvReportMap);
    }

    /**
     * Export to excel - This method is called when the user clicks on the excel icon in the JSP. Reflection is used in the
     * ResponseDispatcherHttpServlet to call this method based on the http parameters.
     *
     * @param request HTTP Request
     * @param response HTTP Response
     * @throws ServletException
     * @throws IOException
     */
    public void exportToExcel(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        ExcelGeneratorThread exGenThread = new ExcelGeneratorThread("exGenThread");

        // Get the session
        final HttpSession session = request.getSession(false);

		// Create a map of key which is based on the result data key and the
        // heading value
        // The heading is used to create the column headers and the key is used
        // to pull the data from the results
        final Map<String, String> inboundDocumentMap = new LinkedHashMap<String, String>();

        final Object startDateStr = session.getAttribute("inboundDocumentQueryStartDate");
        final Object endDateStr = session.getAttribute("inboundDocumentQueryEndDate");

        // Generate filters.
        final Map<String, List<Object>> filterMap = new LinkedHashMap<String, List<Object>>();
        final LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();

        filters.put("SSN", session.getAttribute("inboundDocumentQuerySSN"));
        filters.put("Last Name", session.getAttribute("inboundDocumentQueryLastName"));
        filters.put("First Name", session.getAttribute("inboundDocumentQueryFirstName"));
        filters.put("User ID", session.getAttribute("inboundDocumentQueryUserId"));
        filters.put("Start Date", this.getReportHelper().getFormattedDate((Date) startDateStr));
        filters.put("End Date", this.getReportHelper().getFormattedDate((Date) endDateStr));
        filters.put("Purpose of Use", ExcelExporter.getFilterValue(session.getAttribute("purposeOfUse")));
        filters.put("Patient Preferred Facility", ExcelExporter.getPatientPreferredFacilityFilter(getFacilityDAO(), (String) session.getAttribute("inboundDocumentQueryFacility")));
        filters.put("eHealth Exchange Org", ExcelExporter.getFilterValue(session.getAttribute("inboundDocumentQueryRemoteOrgName")));
        ExcelExporter.populateFilterMapForExport(request, filters, filterMap, session.getAttribute("patientTypes").toString());
        exGenThread.setFilterMap(filterMap);

        inboundDocumentMap.put("ssn", "SSN");
        inboundDocumentMap.put("lastName", "Patient Last Name");
        inboundDocumentMap.put("firstName", "Patient First Name");
        inboundDocumentMap.put("auditTimeFormatted", "Date Received (CT)");
        inboundDocumentMap.put("documentTitle", "Document Title");
        inboundDocumentMap.put("patientFacilityName", "Patient Preferred Facility");
        inboundDocumentMap.put("patientFacilityNumber", "Patient Preferred Facility Station ID");
        inboundDocumentMap.put("remoteOrganizationName", "eHealth Exchange Organization");
        inboundDocumentMap.put("remoteOrganizationId", "OID");
        inboundDocumentMap.put("userId", "User ID");
        inboundDocumentMap.put("userFacilityCode", "User Facility Code");
        inboundDocumentMap.put("userFacilityName", "User Facility");
        inboundDocumentMap.put("userName", "User Name");
        inboundDocumentMap.put("purposeOfUse", "Purpose of Use");
        inboundDocumentMap.put("roleName", "User Role");
        exGenThread.setReportMap(inboundDocumentMap);

        // Set names for Excel generator thread
        exGenThread.setTitle("Received eHealth Exchange Documents Detailed Report");

        exGenThread.setExcelExporter(this.getExcelExporter());
        exGenThread.setAdapterAuditManager(adapterAuditManager);
        exGenThread.setReportHelper(getReportHelper());
        exGenThread.setFacilityHelper(getFacilityHelper());
        exGenThread.setUserId(UserHelper.getUserName(request));
        exGenThread.setUserDocumentDao(getUserDocumentDAO());

        // Set search attributes for getting audit results
        exGenThread.setAttributes(mapSessionAttributes(session));

        exGenThread.start();

        this.forward(request, response, "show");
    }

    private Map<String, Object> mapSessionAttributes(HttpSession session) {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("ssn", (String) session
                .getAttribute("inboundDocumentQuerySSN"));
        attributes.put("lastName", (String) session
                .getAttribute("inboundDocumentQueryLastName"));
        attributes.put("firstName", (String) session
                .getAttribute("inboundDocumentQueryFirstName"));
        attributes.put("userId", (String) session
                .getAttribute("inboundDocumentQueryUserId"));
        attributes.put("startDate", (Date) session.getAttribute("inboundDocumentQueryStartDate"));
        attributes.put("endDate", (Date) session.getAttribute("inboundDocumentQueryEndDate"));
        attributes.put("facility", (String) session.getAttribute("inboundDocumentQueryFacility"));
        attributes.put("purposeOfUse", (String) session.getAttribute("purposeOfUse"));
        attributes.put("remoteOrganization", (String) session
                .getAttribute("inboundDocumentQueryRemoteOrganization"));
        attributes.put("patientTypes", (Integer) session.getAttribute("patientTypes"));
        // sort
        attributes.put("sortValue", (String) session
                .getAttribute("inboundSortValue"));
        attributes.put("sortDirection", (String) session
                .getAttribute("inboundSortDirection"));

        // Set Action Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT_OUT);
        attributes.put("actionsType", actionsType);

        return attributes;
    }

	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}

	public DocumentHelper getDocumentHelper() {
		return this.getBean("adapterDocumentHelper", DocumentHelper.class);
	}

	/**
	 * Get the excel exporter class from Spring.
	 *
	 * @return the excel exporter object
	 */
	public ExcelExporter getExcelExporter() {
		final ExcelExporter excelExporter = this.getBean("excelExporter",
				ExcelExporter.class);
		return excelExporter;
	}

    public FacilityHelper getFacilityHelper() {
        final FacilityHelper facilityHelper = this.getBean("facilityHelper",
            FacilityHelper.class);
        return facilityHelper;
    }

	public ReportHelper getReportHelper() {
		final ReportHelper reportHelper = this.getBean("reportHelper",
				ReportHelper.class);
		return reportHelper;
	}

	private List<Map<String, Object>> getResults(final HttpSession session, final Paginator paginator) throws AuditException {
		final String ssn = (String) session
				.getAttribute("inboundDocumentQuerySSN");
		final String lastName = (String) session
				.getAttribute("inboundDocumentQueryLastName");
		final String firstName = (String) session
				.getAttribute("inboundDocumentQueryFirstName");
        final String userId = (String) session
                .getAttribute("inboundDocumentQueryUserId");
		final Date sd = (Date) session
				.getAttribute("inboundDocumentQueryStartDate");
		final Date ed = (Date) session
				.getAttribute("inboundDocumentQueryEndDate");
		final String facility = (String) session
				.getAttribute("inboundDocumentQueryFacility");
		final String purposeOfUse = (String) session
				.getAttribute("purposeOfUse");
		final String remoteOrganization = (String) session
				.getAttribute("inboundDocumentQueryRemoteOrganization");
		final int patientTypes = (Integer) session.getAttribute("patientTypes");
		// sort
		final String inboundSortValue = (String) session
				.getAttribute("inboundSortValue");
		final String inboundSortDirection = (String) session
				.getAttribute("inboundSortDirection");

		final GetAudits getAuditsRequest = new GetAudits();
		if (NullChecker.isNotEmpty(sd)) {
			getAuditsRequest.setFromDate(GregorianDateUtil
					.getGregorianCalendarByDate(sd));
		}
		if (NullChecker.isNotEmpty(ed)) {
			getAuditsRequest.setToDate(GregorianDateUtil
					.getGregorianCalendarByDate(ed));
		}

        // Set Patient Types
        getAuditsRequest.setPatientTypes(patientTypes);

		/*
		 * // Set Patient Ids if (NullChecker.isNotEmpty(icn)) { final
		 * StringValuesType patientIds = new StringValuesType();
		 * patientIds.getValue().add(icn); patientIds.setNotIn(false);
		 * getAuditsRequest.setPatientIds(patientIds); }
		 */
		// Set SSN
		if (NullChecker.isNotEmpty(ssn)) {
			final StringValuesType patientSSNs = new StringValuesType();
			patientSSNs.getValue().add(ssn);
			patientSSNs.setNotIn(false);
			getAuditsRequest.setPatientSSNs(patientSSNs);
		}
		// Set Last Name
		if (NullChecker.isNotEmpty(lastName)) {
			final StringValuesType patientLastNames = new StringValuesType();
			patientLastNames.getValue().add(lastName);
			patientLastNames.setNotIn(false);
			getAuditsRequest.setPatientLastNames(patientLastNames);
		}
		// Set First Name
		if (NullChecker.isNotEmpty(firstName)) {
			final StringValuesType patientFirstNames = new StringValuesType();
			patientFirstNames.getValue().add(firstName);
			patientFirstNames.setNotIn(false);
			getAuditsRequest.setPatientGivenNames(patientFirstNames);
		}
		// Set User ID
        if (NullChecker.isNotEmpty(userId)) {
            final StringValuesType userIdValue = new StringValuesType();
            userIdValue.getValue().add(userId);
            userIdValue.setNotIn(false);
            getAuditsRequest.setUserIds(userIdValue);
        }
		// Set Purpose of Use
		if (!NullChecker.isNullOrEmpty(purposeOfUse) ) {
			final StringValuesType purposeForUses = new StringValuesType();
			purposeForUses.getValue().add(purposeOfUse);
			purposeForUses.setNotIn(false);
			getAuditsRequest.setPurposeForUses(purposeForUses);
		}

		// Set Facility Ids
		if (NullChecker.isNotEmpty(facility)) {
			final StringValuesType facilityIds = new StringValuesType();
			facilityIds.setNotIn(false);
			facilityIds.getValue().add(facility);
			getAuditsRequest.setPatientFacilityNumbers(facilityIds);
		}

		/*
		 * // Set Organization Ids final StringValuesType organizationIds = new
		 * StringValuesType(); organizationIds.setNotIn(false);
		 * getAuditsRequest.setOrganizationIds(organizationIds);
		 */

		// Set Remote Organization Ids
		if (NullChecker.isNotEmpty(remoteOrganization)) {
			final StringValuesType remoteOrganizationIds = new StringValuesType();
			remoteOrganizationIds.setNotIn(false);
			remoteOrganizationIds.getValue().add(remoteOrganization);
			getAuditsRequest.setRemoteOrganizationIds(remoteOrganizationIds);
		}

		// sorting
		if (NullChecker.isNotEmpty(inboundSortValue)) {
			final SortFieldType sortField = new SortFieldType();
			sortField.setField(FieldType.fromValue(inboundSortValue));
			if ("DESC".equalsIgnoreCase(inboundSortDirection)) {
				sortField.setDirection(SortDirection.DESC);
			} else {
				sortField.setDirection(SortDirection.ASC);
			}
			final SortFieldsType sortFieldsType = new SortFieldsType();
			sortFieldsType.getSortField().add(sortField);
			getAuditsRequest.setSortFields(sortFieldsType);
		}

		// Set Actions
		final ActionValuesType actionsType = new ActionValuesType();
		actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT_OUT);
		getAuditsRequest.setActions(actionsType);

		// Set Page information
		final PageInfoType pageInfoType = new PageInfoType();
		pageInfoType.setPageNumber(paginator.getCurrentPage());
		pageInfoType.setPageSize(paginator.getRecordsPerPage());
		getAuditsRequest.setPageInfo(pageInfoType);

		final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        GetAuditsResponse queryResponse = new GetAuditsResponse();
		try {
			try {
                queryResponse = this.adapterAuditManager.getAudits(getAuditsRequest);
            } catch(Exception e) {
                throw new AuditException();
            }

			if (NullChecker.isNotEmpty(queryResponse)
					&& NullChecker.isNotEmpty(queryResponse.getAudits())
					&& NullChecker.isNotEmpty(queryResponse.getAudits()
							.getAudit())) {
				final List<AuditType> auditTypeList = queryResponse.getAudits()
						.getAudit();
				int pageSize = paginator.getRecordsPerPage();
                FacilityHelper facilityHelper = this.getFacilityHelper();
                String userIdString;
				for (final AuditType auditType : auditTypeList) {
					// final String patientId = auditType.getPatientId();

					// final PatientDemographicsQuery patientDemographicsQuery =
					// new PatientDemographicsQuery();
					// patientDemographicsQuery.setPatientId(patientId);
					// final PatientDemographicsResponse response =
					// this.pdqService
					// .getPatientDemographics(patientDemographicsQuery);

					final Map<String, Object> resultMap = new HashMap<String, Object>();

					ReportDataProcessor.addSsnToResultMap(resultMap, auditType.getPatientSSN());

					resultMap.put("patientICN", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientId()));

					// A) Replace this with B
					resultMap.put("auditTime", GregorianDateUtil
							.getDateFromGregorianCalendar(auditType
									.getAuditTime()));

					// B) The following logic could supplant the previous one, A
					resultMap.put("auditTimeFormatted", this.getReportHelper().getFormattedDateTime(GregorianDateUtil
							.getDateFromGregorianCalendar(auditType
									.getAuditTime())));

					resultMap.put("purposeForUse", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPurposeForUse()));

                    resultMap.put("userFacilityCode", "");
                    resultMap.put("userFacilityName", "");

                    userIdString = ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getUserId()).replace(" ? ", " ");
                    resultMap.put("userId", userIdString);

                    //Parse the user id field for facility code and user name.
                    if (userIdString.substring(0,4).matches("^\\d{3}:")){
                        resultMap.put("userFacilityCode", userIdString.substring(0,3));
                        resultMap.put("userFacilityName", facilityHelper.getFacilityNameByStationId(userIdString.substring(0,3)));
                    }

                    if (userIdString.indexOf("CN=") > 0){
                        resultMap.put("userName",userIdString.substring((userIdString.indexOf("CN=") + 3),
                            userIdString.indexOf(",", userIdString.indexOf("CN="))));
                    }

					// resultMap.put("patient",
					// response.getPatientDemographics());

					resultMap.put("lastName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientLastName()));
					resultMap.put("firstName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientGivenName()));
					resultMap.put("patientFacilityName", ReportDataProcessor
							.fixStation(auditType.getPatientFacilityName()));
					resultMap.put("patientFacilityNumber", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientFacilityNumber()));

                    resultMap.put("remoteOrganizationName", this.getReportHelper().findOrganizationByOid(auditType.getRemoteOrganizationId(), auditType.getRemoteOrganizationName()));

                    resultMap.put("remoteOrganizationId", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getRemoteOrganizationId()));
					/*
					 * resultMap.put( "remoteFacility", this.getCmsHelper()
					 * .getOrganizationByHomeCommunityId(
					 * auditType.getRemoteOrganizationId()));
					 * resultMap.put("remoteDocRepositoryId",
					 * auditType.getRemoteDocumentRepositoryId());
					 */

					resultMap.put("documentId", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getDocumentId()));
					resultMap.put("documentTitle", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getDocumentTitle()));
                                        resultMap.put("roleName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getRoleName()));
					results.add(resultMap);
				}

				// TODO: Move setting of session variables to a different method
				// Check if any of the patient match criteria exists
				if (NullChecker.isNotEmpty(ssn)
						|| NullChecker.isNotEmpty(lastName)
						|| NullChecker.isNotEmpty(firstName)) {
					// Default to unknown
					String resultIcn = "";
					if (NullChecker.isNotEmpty(auditTypeList)) {
						final AuditType result = auditTypeList.get(0);
						resultIcn = result.getPatientId();

						if (NullChecker.isNotEmpty(resultIcn)) {
							for (final AuditType auditType : auditTypeList) {
								if (!resultIcn.equals(auditType.getPatientId())) {
									resultIcn = "Multiple ICNs";
									break;
								}
							}
						} else if (NullChecker.isNotEmpty(result
								.getPatientGivenName())
								&& NullChecker.isNotEmpty(result
										.getPatientLastName())
								&& NullChecker.isNotEmpty(result
										.getPatientSSN())) {
							final String patientGivenName = result
									.getPatientGivenName();
							final String patientLastName = result
									.getPatientLastName();
							final String patientSsn = result.getPatientSSN();
							boolean multipleIcns = false;
							for (final AuditType auditType : auditTypeList) {
								if (!patientGivenName.equals(auditType
										.getPatientGivenName())
										|| !patientLastName.equals(auditType
												.getPatientLastName())
										|| !patientSsn.equals(auditType
												.getPatientSSN())) {
									multipleIcns = true;
									break;
								}
							}
							if (multipleIcns) {
								resultIcn = "Multiple ICNs";
							} else {
								resultIcn = this.getReportHelper().resolveICN(
										result.getPatientGivenName(),
										result.getPatientLastName(),
										result.getPatientSSN());
							}
						}
					} else if (NullChecker.isNotEmpty(ssn)
							&& NullChecker.isNotEmpty(lastName)
							&& NullChecker.isNotEmpty(firstName)) {
						// Try to get from what was typed
						resultIcn = this.getReportHelper().resolveICN(
								firstName, lastName, ssn);
					}
					// Set in Session
					if (NullChecker.isEmpty(resultIcn)) {
						resultIcn = "Unknown";
					}
					session.setAttribute("inboundDocumentQueryICN", resultIcn);
				}
				//return results;
			}
		} catch (final AuditException ex) {
			throw new AuditException(ex);
		} // catch (final PdqException ex) {
			// throw new RuntimeException(ex);
		// }

		return results;
	}

	private boolean isPaginatorPresent(final HttpSession session) {
		return !NullChecker.isNullOrEmpty(session.getAttribute("paginator"));
	}

	public void next(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		if (this.isPaginatorPresent(session)) {
			final Paginator paginator = (Paginator) session
					.getAttribute("paginator");
			paginator.next(request);
			session.setAttribute("paginator", paginator);
			session.setAttribute("inboundDocumentResults",
					this.getResults(session, paginator));
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

	public void prev(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		if (this.isPaginatorPresent(session)) {
			final Paginator paginator = (Paginator) session
					.getAttribute("paginator");
			paginator.previous(request);
			session.setAttribute("paginator", paginator);
			session.setAttribute("inboundDocumentResults",
					this.getResults(session, paginator));
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

	@EJB(beanInterface = AdapterAuditManager.class, mappedName = "AdapterAuditManager")
	public void setAdapterAuditManager(
			final AdapterAuditManager adapterAuditManager) {
		this.adapterAuditManager = adapterAuditManager;
	}

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);

		// sort
		final String inboundSortValue = request
				.getParameter("inboundSortValue");
		final String inboundSortDirection = request
				.getParameter("inboundSortDirection");
		session.setAttribute("inboundSortValue", inboundSortValue);
		session.setAttribute("inboundSortDirection", inboundSortDirection);

		if (this.isPaginatorPresent(session)) {
			Paginator paginator = (Paginator) session.getAttribute("paginator");
			if (NullChecker.isEmpty(paginator)) {
				paginator = new Paginator(0);
				session.setAttribute("paginator", paginator);
			}
			paginator.reset();
			session.setAttribute("inboundDocumentResults",
					this.getResults(session, paginator));
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

	public void view(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		final String icn = request.getParameter("icn");
		final String documentUniqueId = request
				.getParameter("documentUniqueId");
		final String styleSheetViewType = request
				.getParameter("styleSheetViewType");

		String document = null;
		try {
			document = this.getDocumentHelper().getDocument(icn,
					documentUniqueId, UserHelper.getUserName(request),
					this.getCmsHelper().getCompleteHomeCommunityId());
		} catch (final AdapterException ex) {
			throw new ServletException(ex);
		}

		session.setAttribute("icn", icn);
		session.setAttribute("documentUniqueId", documentUniqueId);
		session.setAttribute("document", document);
		session.setAttribute("isXmlViewEnabled", this.getDocumentHelper()
				.isXmlViewEnabled());

		if ("xml".equals(styleSheetViewType)) {
			document = document
					.replaceAll(
							"<?xml-stylesheet type=\"text/xsl\" href=\"CCD.xsl\"?>",
							"");
			response.setContentType("text/xml;charset=UTF-8");
			response.getWriter().write(document);
		} else {
			// Update session in the document
			final String html = this.getDocumentHelper().getHtml(document,
					styleSheetViewType);

			session.setAttribute("updatedDocument", html);
			this.forward(request, response, "showInboundDocumentReportDocument");
		}
	}

    private FacilityDAO getFacilityDAO() {
        return this.getBean("FacilityDAO", FacilityDAO.class);
    }

    private UserDocumentDAO getUserDocumentDAO() {
        return this.getBean("UserDocumentDAO", UserDocumentDAO.class);
    }
}
