/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.report;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.ActionValuesType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldType;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.StringValuesType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.adapter.doc.AdapterException;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.dao.FacilityDAO;
import gov.va.nvap.web.dao.PurposeOfUseDAO;
import gov.va.nvap.web.dao.UserDocumentDAO;
import gov.va.nvap.web.entities.PurposeOfUse;
import gov.va.nvap.web.helper.document.DocumentHelper;
import gov.va.nvap.web.helper.facility.FacilityHelper;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.patient.ExcelGeneratorThread;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.util.Constants;
import gov.va.nvap.web.util.xls.CsvExporter;
import gov.va.nvap.web.util.xls.ExcelExporter;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.ss.usermodel.Workbook;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Documents that are received by the VA from external partners.
 *
 * @author Asha Amritraj
 */
public class InboundDocumentReport extends ResponseDispatcherHttpServlet {
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 1512959065218653085L;

    private final String REPORT_TITLE = "Received eHealth Exchange Documents Detail Report";

    private AdapterAuditManager adapterAuditManager;
	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}

	/**
	 * Get the facility helper from Spring.
	 */
	public FacilityHelper getFacilityHelper() {
		final FacilityHelper facilityHelper = this.getBean("facilityHelper",
				FacilityHelper.class);
		return facilityHelper;
	}

    private ReportHelper getReportHelper() {
        return this.getBean("reportHelper", ReportHelper.class);
    }

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);

		session.removeAttribute("results");

		request.setAttribute("facilities", this.getFacilityHelper()
				.getAllVistAFacilities());
		//request.setAttribute("organizations", this.getCmsHelper()
		//		.getAllowedOrganizations());
        this.getReportHelper().getReceivedDocsOrgLists(request);

		if (Constants.PURPOSE_OF_USE_FLAG){
			final PurposeOfUseDAO purposeOfUseDAO = this.getBean(
					"purposeOfUseDAO", PurposeOfUseDAO.class);
			Collection<PurposeOfUse> pous = purposeOfUseDAO.findPurposeOfUse();
			request.setAttribute("pous", pous);
		}
		request.setAttribute("pouFlag", Constants.PURPOSE_OF_USE_FLAG);
        ReportHelper.setDefaultSearchDates(session);

		this.forward(request, response, "show");
	}

    public void doSearch(final HttpServletRequest request, final HttpServletResponse response) throws AuditException, IOException, ServletException{
        final HttpSession session = request.getSession(false);

        session.setAttribute("results", encodeIntoJSON(getResults(request, false), request.getParameter("draw")));

        this.forward(request, response, "searchResultsJSON");
    }

    /**
     * gathers search results based on request parameters and returns in a packaged form. Boolean is check to see if all data should
     * be returned or only specified amount
     * @param request
     * @param getAll
     * @return
     * @throws AuditException
     */
    private SearchPackage getResults(final HttpServletRequest request, boolean exporting) throws AuditException {

		final String ssn = request.getParameter("ssn");
		final String lastName = request.getParameter("lastName");
		final String firstName = request.getParameter("firstName");
        final String userId = request.getParameter("userId");
		final Date sd = ReportHelper.getStartDate(request.getParameter("startDate"));
		final Date ed = ReportHelper.getEndDate(request.getParameter("endDate"));
		final String facility = request.getParameter("facility");
		final String purposeOfUse = request.getParameter("purposeOfUse");
		final String remoteOrganization = request.getParameter("remoteOrganization");
		final int patientTypes = Integer.parseInt(request.getParameter("patientTypes"));
		// sort
		final String inboundSortValue = (request.getParameter("order[0][column]") != null)
                ? getSortValue(request.getParameter("order[0][column]")): getSortValue(request.getParameter("sortBy"));
		final String inboundSortDirection = (request.getParameter("order[0][dir]") != null)
                ? request.getParameter("order[0][dir]"): request.getParameter("sortOrder");


		final GetAudits getAuditsRequest = new GetAudits();
		if (NullChecker.isNotEmpty(sd)) {
			getAuditsRequest.setFromDate(GregorianDateUtil
					.getGregorianCalendarByDate(sd));
		}
		if (NullChecker.isNotEmpty(ed)) {
			getAuditsRequest.setToDate(GregorianDateUtil
					.getGregorianCalendarByDate(ed));
		}

        // Set Patient Types
        getAuditsRequest.setPatientTypes(patientTypes);

		/*
		 * // Set Patient Ids if (NullChecker.isNotEmpty(icn)) { final
		 * StringValuesType patientIds = new StringValuesType();
		 * patientIds.getValue().add(icn); patientIds.setNotIn(false);
		 * getAuditsRequest.setPatientIds(patientIds); }
		 */
		// Set SSN
		if (NullChecker.isNotEmpty(ssn)) {
			final StringValuesType patientSSNs = new StringValuesType();
			patientSSNs.getValue().add(ssn);
			patientSSNs.setNotIn(false);
			getAuditsRequest.setPatientSSNs(patientSSNs);
		}
		// Set Last Name
		if (NullChecker.isNotEmpty(lastName)) {
			final StringValuesType patientLastNames = new StringValuesType();
			patientLastNames.getValue().add(lastName);
			patientLastNames.setNotIn(false);
			getAuditsRequest.setPatientLastNames(patientLastNames);
		}
		// Set First Name
		if (NullChecker.isNotEmpty(firstName)) {
			final StringValuesType patientFirstNames = new StringValuesType();
			patientFirstNames.getValue().add(firstName);
			patientFirstNames.setNotIn(false);
			getAuditsRequest.setPatientGivenNames(patientFirstNames);
		}
		// Set User ID
        if (NullChecker.isNotEmpty(userId)) {
            final StringValuesType userIdValue = new StringValuesType();
            userIdValue.getValue().add(userId);
            userIdValue.setNotIn(false);
            getAuditsRequest.setUserIds(userIdValue);
        }
		// Set Purpose of Use
		if (!NullChecker.isNullOrEmpty(purposeOfUse) ) {
			final StringValuesType purposeForUses = new StringValuesType();
			purposeForUses.getValue().add(purposeOfUse);
			purposeForUses.setNotIn(false);
			getAuditsRequest.setPurposeForUses(purposeForUses);
		}

		// Set Facility Ids
		if (NullChecker.isNotEmpty(facility)) {
			final StringValuesType facilityIds = new StringValuesType();
			facilityIds.setNotIn(false);
			facilityIds.getValue().add(facility);
			getAuditsRequest.setPatientFacilityNumbers(facilityIds);
		}

		/*
		 * // Set Organization Ids final StringValuesType organizationIds = new
		 * StringValuesType(); organizationIds.setNotIn(false);
		 * getAuditsRequest.setOrganizationIds(organizationIds);
		 */

		// Set Remote Organization Ids
		if (NullChecker.isNotEmpty(remoteOrganization)) {
			final StringValuesType remoteOrganizationIds = new StringValuesType();
			remoteOrganizationIds.setNotIn(false);
			remoteOrganizationIds.getValue().add(remoteOrganization);
			getAuditsRequest.setRemoteOrganizationIds(remoteOrganizationIds);
		}

		// sorting
		if (NullChecker.isNotEmpty(inboundSortValue)) {
			final SortFieldType sortField = new SortFieldType();
			sortField.setField(FieldType.fromValue(inboundSortValue));
			if ("DESC".equalsIgnoreCase(inboundSortDirection)) {
				sortField.setDirection(SortDirection.DESC);
			} else {
				sortField.setDirection(SortDirection.ASC);
			}
			final SortFieldsType sortFieldsType = new SortFieldsType();
			sortFieldsType.getSortField().add(sortField);
			getAuditsRequest.setSortFields(sortFieldsType);
		}

		// Set Actions
		final ActionValuesType actionsType = new ActionValuesType();
		actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT_OUT);
		getAuditsRequest.setActions(actionsType);

		// Set Page information
		final PageInfoType pageInfoType = new PageInfoType();

        pageInfoType.setPageNumber((request.getParameter("start") != null) ? Integer.parseInt(request.getParameter("start"))/Integer.parseInt(request.getParameter("length")) : 0);
        pageInfoType.setPageSize((request.getParameter("length") != null) ? Integer.parseInt(request.getParameter("length")): -1);

		getAuditsRequest.setPageInfo(pageInfoType);

		final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        GetAuditsResponse queryResponse = new GetAuditsResponse();
        Long totalCount = new Long(0); //default it to zero, but we set it below
		String resultIcn = "";

		try {
			try {
                queryResponse = this.adapterAuditManager.getAudits(getAuditsRequest);
                if(queryResponse.getPageInfo() != null) {
                    totalCount = exporting ? 0 : new Long(queryResponse.getPageInfo().getTotalSize());
                }
            } catch(Exception e) {
                throw new AuditException();
            }

			if (NullChecker.isNotEmpty(queryResponse)
					&& NullChecker.isNotEmpty(queryResponse.getAudits())
					&& NullChecker.isNotEmpty(queryResponse.getAudits()
							.getAudit())) {
				final List<AuditType> auditTypeList = queryResponse.getAudits()
						.getAudit();
                FacilityHelper facilityHelper = this.getFacilityHelper();
                String userIdString;
				for (final AuditType auditType : auditTypeList) {
					// final String patientId = auditType.getPatientId();

					// final PatientDemographicsQuery patientDemographicsQuery =
					// new PatientDemographicsQuery();
					// patientDemographicsQuery.setPatientId(patientId);
					// final PatientDemographicsResponse response =
					// this.pdqService
					// .getPatientDemographics(patientDemographicsQuery);

					final Map<String, Object> resultMap = new HashMap<String, Object>();

					ReportDataProcessor.addSsnToResultMap(resultMap, auditType.getPatientSSN());

					resultMap.put("patientICN", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientId()));

					// A) Replace this with B
					resultMap.put("auditTime", GregorianDateUtil
							.getDateFromGregorianCalendar(auditType
									.getAuditTime()));

					// B) The following logic could supplant the previous one, A
					resultMap.put("auditTimeFormatted", this.getReportHelper().getFormattedDateTime(GregorianDateUtil
							.getDateFromGregorianCalendar(auditType
									.getAuditTime())));

					resultMap.put("purposeForUse", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPurposeForUse()));

                    resultMap.put("userFacilityCode", "");
                    resultMap.put("userFacilityName", "");

                    userIdString = ReportDataProcessor.nullEmptyReplaceWithUnknown(auditType.getUserId()).replace(" ? ", " ");
                    resultMap.put("userId", userIdString);

                    //Parse the user id field for facility code and user name.
                    if (userIdString.substring(0,4).matches("^\\d{3}:")){
                        resultMap.put("userFacilityCode", userIdString.substring(0,3));
                        resultMap.put("userFacilityName", facilityHelper.getFacilityNameByStationId(userIdString.substring(0,3)));
                    }

                    if (userIdString.indexOf("CN=") > 0){
                        resultMap.put("userName",userIdString.substring((userIdString.indexOf("CN=") + 3),
                            userIdString.indexOf(",", userIdString.indexOf("CN="))));
                    }

					// resultMap.put("patient",
					// response.getPatientDemographics());

					resultMap.put("lastName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientLastName()));
					resultMap.put("firstName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientGivenName()));
					resultMap.put("patientFacilityName", ReportDataProcessor
							.fixStation(auditType.getPatientFacilityName()));
					resultMap.put("patientFacilityNumber", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getPatientFacilityNumber()));

                    resultMap.put("remoteOrganizationName", this.getReportHelper().findOrganizationByOid(auditType.getRemoteOrganizationId(), auditType.getRemoteOrganizationName()));

                    resultMap.put("remoteFacilityOid", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getRemoteOrganizationId()));
					/*
					 * resultMap.put( "remoteFacility", this.getCmsHelper()
					 * .getOrganizationByHomeCommunityId(
					 * auditType.getRemoteOrganizationId()));
					 * resultMap.put("remoteDocRepositoryId",
					 * auditType.getRemoteDocumentRepositoryId());
					 */

					resultMap.put("documentId", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getDocumentId()));
					resultMap.put("documentTitle", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getDocumentTitle()));
                                        resultMap.put("roleName", ReportDataProcessor
							.nullEmptyReplaceWithUnknown(auditType
									.getRoleName()));
					results.add(resultMap);
				}

				// TODO: Move setting of session variables to a different method
				// Check if any of the patient match criteria exists
				if (NullChecker.isNotEmpty(ssn)
						|| NullChecker.isNotEmpty(lastName)
						|| NullChecker.isNotEmpty(firstName)) {
					if (NullChecker.isNotEmpty(auditTypeList)) {
						final AuditType result = auditTypeList.get(0);
						resultIcn = result.getPatientId();

						if (NullChecker.isNotEmpty(resultIcn)) {
							for (final AuditType auditType : auditTypeList) {
								if (!resultIcn.equals(auditType.getPatientId())) {
									resultIcn = "Multiple ICNs";
									break;
								}
							}
						} else if (NullChecker.isNotEmpty(result
								.getPatientGivenName())
								&& NullChecker.isNotEmpty(result
										.getPatientLastName())
								&& NullChecker.isNotEmpty(result
										.getPatientSSN())) {
							final String patientGivenName = result
									.getPatientGivenName();
							final String patientLastName = result
									.getPatientLastName();
							final String patientSsn = result.getPatientSSN();
							boolean multipleIcns = false;
							for (final AuditType auditType : auditTypeList) {
								if (!patientGivenName.equals(auditType
										.getPatientGivenName())
										|| !patientLastName.equals(auditType
												.getPatientLastName())
										|| !patientSsn.equals(auditType
												.getPatientSSN())) {
									multipleIcns = true;
									break;
								}
							}
							if (multipleIcns) {
								resultIcn = "Multiple ICNs";
							} else {
								resultIcn = this.getReportHelper().resolveICN(
										result.getPatientGivenName(),
										result.getPatientLastName(),
										result.getPatientSSN());
							}
						}
					} else if (NullChecker.isNotEmpty(ssn)
							&& NullChecker.isNotEmpty(lastName)
							&& NullChecker.isNotEmpty(firstName)) {
						// Try to get from what was typed
						resultIcn = this.getReportHelper().resolveICN(
								firstName, lastName, ssn);
					}
					// Set in Session
					if (NullChecker.isEmpty(resultIcn)) {
						resultIcn = "Unknown";
					}
				}
				//return results;
			}
		} catch (final AuditException ex) {
			throw new AuditException();
		} // catch (final PdqException ex) {
			// throw new RuntimeException(ex);
		// }
        SearchPackage sp = new SearchPackage(results, resultIcn);
        sp.setTotalCount(totalCount);

		return sp;
	}

    @EJB(beanInterface = AdapterAuditManager.class, mappedName = "AdapterAuditManager")
	public void setAdapterAuditManager(
			final AdapterAuditManager adapterAuditManager) {
		this.adapterAuditManager = adapterAuditManager;
	}

    /**
     * Changes result map into json object as string, adding any addition information that will be needed on front end.
     * @param packagedResults
     * @return
     */
    private String encodeIntoJSON(SearchPackage packagedResults, String draw){
        String returnValue = "";

        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List<List> data = new ArrayList<List>();

            for (Map<String,Object> currentRow: packagedResults.getResults()) {
                List<String> dataItem = new ArrayList<String>();

                dataItem.add(currentRow.get("ssnMasked").toString());
                dataItem.add(currentRow.get("lastName").toString());
                dataItem.add(currentRow.get("firstName").toString());
                dataItem.add(currentRow.get("auditTimeFormatted").toString());
                dataItem.add(currentRow.get("documentTitle").toString());
                dataItem.add(currentRow.get("patientFacilityName").toString());
                dataItem.add(currentRow.get("patientFacilityNumber").toString());
                dataItem.add(currentRow.get("remoteOrganizationName").toString());
                dataItem.add(currentRow.get("userId").toString());
                dataItem.add(currentRow.get("purposeForUse").toString());
                dataItem.add(currentRow.get("roleName").toString());
                dataItem.add(currentRow.get("ssn").toString());
                dataItem.add(currentRow.get("patientICN").toString());
                dataItem.add(currentRow.get("documentId").toString());

                data.add(dataItem);
            }

            obj.put("data", data);
            obj.put("inboundIcn", packagedResults.getInboundIcn());
            obj.put("recordsTotal", packagedResults.getTotalCount());
            obj.put("recordsFiltered", packagedResults.getTotalCount());
            obj.put("draw", draw);

            obj.write(json);

            returnValue = json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(InboundDocumentReport.class.getName()).log(Level.SEVERE, null, ex);
        }

        return returnValue;
    }

    /**
     * Takes in column number and returns proper sort value
     * @param colNumber
     * @return
     */
    private String getSortValue(String colNumber){
        String sortValue = "";

        switch(Integer.parseInt(colNumber)){
            case 0:
                sortValue = "patientSSN";
                break;
            case 1:
                sortValue = "patientLastName";
                break;
            case 2:
                sortValue = "patientGivenName";
                break;
            case 3:
                sortValue = "auditTime";
                break;
            case 4:
                sortValue = "documentTitle";
                break;
            case 5:
                sortValue = "patientFacilityName";
                break;
            case 6:
                sortValue = "patientFacilityNumber";
                break;
            case 7:
                sortValue = "remoteOrganizationName";
                break;
            case 8:
                sortValue = "userId";
                break;
            case 9:
                sortValue = "purposeForUse";
                break;
        }
        return sortValue;
    }

    /**
     * document view
     * @param request
     * @param response
     * @throws ServletException
     * @throws IOException
     */
    public void view(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		final String icn = request.getParameter("patientICN");
		final String documentUniqueId = request
				.getParameter("documentUniqueId");
		final String styleSheetViewType = request
				.getParameter("styleSheetViewType");

		String document = null;
		try {
			document = this.getDocumentHelper().getDocument(icn,
					documentUniqueId, UserHelper.getUserName(request),
					this.getCmsHelper().getCompleteHomeCommunityId());
		} catch (final AdapterException ex) {
			throw new ServletException(ex);
		}

		session.setAttribute("icn", icn);
		session.setAttribute("documentUniqueId", documentUniqueId);
		session.setAttribute("document", document);
		session.setAttribute("isXmlViewEnabled", this.getDocumentHelper()
				.isXmlViewEnabled());

		if ("xml".equals(styleSheetViewType)) {
			document = document
					.replaceAll(
							"<?xml-stylesheet type=\"text/xsl\" href=\"CCD.xsl\"?>",
							"");
			response.setContentType("text/xml;charset=UTF-8");
			response.getWriter().write(document);
		} else {
			// Update session in the document
			final String html = this.getDocumentHelper().getHtml(document,
					styleSheetViewType);

			session.setAttribute("updatedDocument", html);
			this.forward(request, response, "showInboundDocumentReportDocument");
		}
	}

    public DocumentHelper getDocumentHelper() {
		return this.getBean("adapterDocumentHelper", DocumentHelper.class);
	}

    /**
     * Export to excel - This method is called when the user clicks on the excel icon in the JSP. Reflection is used in the
     * ResponseDispatcherHttpServlet to call this method based on the http parameters.
     *
     * @param request HTTP Request
     * @param response HTTP Response
     * @throws ServletException
     * @throws IOException
     */
    public void exportToExcel(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {

		// Create a map of key which is based on the result data key and the
        // heading value
        // The heading is used to create the column headers and the key is used
        // to pull the data from the results
        final Map<String, String> inboundDocumentMap = new LinkedHashMap<String, String>();

        final Date startDateStr = ReportHelper.getStartDate(request.getParameter("startDate"));
        final Date endDateStr = ReportHelper.getEndDate(request.getParameter("endDate"));

        // Generate filters.
        final Map<String, List<Object>> filterMap = new LinkedHashMap<String, List<Object>>();
        final LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();

        filters.put("SSN", request.getParameter("ssn"));
        filters.put("Last Name", request.getParameter("lastName"));
        filters.put("First Name", request.getParameter("firstName"));
        filters.put("User ID", request.getParameter("userId"));
        filters.put("Start Date", this.getReportHelper().getFormattedDate( startDateStr));
        filters.put("End Date", this.getReportHelper().getFormattedDate(endDateStr));
        filters.put("Purpose of Use", ExcelExporter.getFilterValue(request.getParameter("purposeOfUse")));
        filters.put("Patient Preferred Facility", ExcelExporter.getPatientPreferredFacilityFilter(getFacilityDAO(), request.getParameter("facility")));
        filters.put("eHealth Exchange Org", ExcelExporter.getFilterValue(request.getParameter("organizationName")));
        ExcelExporter.populateFilterMapForExport(request, filters, filterMap, request.getParameter("patientTypes"));

        inboundDocumentMap.put("ssn", "SSN");
        inboundDocumentMap.put("lastName", "Patient Last Name");
        inboundDocumentMap.put("firstName", "Patient First Name");
        inboundDocumentMap.put("auditTimeFormatted", "Date Received (CT)");
        inboundDocumentMap.put("documentTitle", "Document Title");
        inboundDocumentMap.put("patientFacilityName", "Patient Preferred Facility");
        inboundDocumentMap.put("patientFacilityNumber", "Patient Preferred Facility Station ID");
        inboundDocumentMap.put("remoteOrganizationName", "eHealth Exchange Organization");
        inboundDocumentMap.put("remoteFacilityOid", "OID");
        inboundDocumentMap.put("userId", "User ID");
        inboundDocumentMap.put("userFacilityCode", "User Facility Code");
        inboundDocumentMap.put("userFacilityName", "User Facility");
        inboundDocumentMap.put("userName", "User Name");
        inboundDocumentMap.put("purposeForUse", "Purpose of Use");
        inboundDocumentMap.put("roleName", "User Role");

        int minimumThreshold = Integer.parseInt((String) this.getServletContext().getAttribute("scheduledExportMin"));
        int total = Integer.parseInt(request.getParameter("totalRows"));

        //Start a scheduled export with its own thread if greater than the minimum threshold
        if (total >= minimumThreshold) {
            ExcelGeneratorThread exGenThread = new ExcelGeneratorThread("exGenThread");
            exGenThread.setFilterMap(filterMap);
            exGenThread.setReportMap(inboundDocumentMap);

            // Set names for Excel generator thread
            exGenThread.setTitle(REPORT_TITLE);

            exGenThread.setExcelExporter(this.getExcelExporter());
            exGenThread.setAdapterAuditManager(adapterAuditManager);
            exGenThread.setReportHelper(getReportHelper());
            exGenThread.setFacilityHelper(getFacilityHelper());
            exGenThread.setUserId(UserHelper.getUserName(request));
            exGenThread.setUserDocumentDao(getUserDocumentDAO());

            // Set search attributes for getting audit results
            exGenThread.setAttributes(mapSessionAttributes(request));

            exGenThread.run();
        }
        //Otherwise generate and download the export directly
        else {
            // Create workbook
            List<Map<String, Object>> results;
            InboundDocumentReport.SearchPackage packedResults;
            packedResults = this.getResults(request, true);
            results = packedResults.getResults();

            final Workbook wb = this.getExcelExporter().exportToExcel(REPORT_TITLE, REPORT_TITLE, inboundDocumentMap, results, filterMap, null);

            // Write Excel workbook to Stream
            this.getExcelExporter().writeExcelToStream(REPORT_TITLE.replace(" ", "_"), wb, response);
        }
    }


    private Map<String, Object> mapSessionAttributes(HttpServletRequest request) {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("ssn", request.getParameter("ssn"));
        attributes.put("lastName", request.getParameter("lastName"));
        attributes.put("firstName", request.getParameter("firstName"));
        attributes.put("userId", request.getParameter("userId"));
        attributes.put("startDate", ReportHelper.getStartDate(request.getParameter("startDate")));
        attributes.put("endDate", ReportHelper.getEndDate(request.getParameter("endDate")));
        attributes.put("facility", request.getParameter("facility"));
        attributes.put("purposeOfUse", request.getParameter("purposeOfUse"));
        attributes.put("remoteOrganization", request.getParameter("remoteOrganization"));
        attributes.put("patientTypes", Integer.parseInt(request.getParameter("patientTypes")));
        // sort
        attributes.put("sortValue", getSortValue(request.getParameter("sortBy")));
        attributes.put("sortDirection", request.getParameter("sortOrder"));

        // Set Action Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT_OUT);
        attributes.put("actionsType", actionsType);

        return attributes;
    }

      public void exportToCsv(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException, IOException {


        Map<String, String> csvReportMap = new LinkedHashMap<String, String>();
        csvReportMap.put("SSN", "ssn");
        csvReportMap.put("Patient Last Name", "lastName");
        csvReportMap.put("Patient First Name", "firstName");
        csvReportMap.put("Date Received (CT)", "auditTimeFormatted");
        csvReportMap.put("Document Title", "documentTitle");
        csvReportMap.put("Patient Preferred Facility", "patientFacilityName");
        csvReportMap.put("Patient Preferred Facility Station ID", "patientFacilityNumber");
        csvReportMap.put("eHealth Exchange Organization", "remoteOrganizationName");
        csvReportMap.put("OID", "remoteFacilityOid");
        csvReportMap.put("User ID", "userId");
        csvReportMap.put("User Facility Code", "userFacilityCode");
        csvReportMap.put("User Facility", "userFacilityName");
        csvReportMap.put("User Name", "userName");
        csvReportMap.put("Purpose of Use", "purposeForUse");
        csvReportMap.put("User Role", "roleName");

        int minimumThreshold = Integer.parseInt((String) this.getServletContext().getAttribute("scheduledExportMin"));
        int total = Integer.parseInt(request.getParameter("totalRows"));

        //Start a scheduled export with its own thread if greater than the minimum threshold
        if (total >= minimumThreshold) {
            ExcelGeneratorThread csvGenThread = new ExcelGeneratorThread("csvGenThread");
            csvGenThread.setDocumentType("csv");
            csvGenThread.setReportMap(csvReportMap);

            csvGenThread.setTitle(REPORT_TITLE);
            csvGenThread.setUserId(UserHelper.getUserName(request));
            csvGenThread.setAdapterAuditManager(adapterAuditManager);
            csvGenThread.setReportHelper(getReportHelper());
            csvGenThread.setFacilityHelper(getFacilityHelper());
            csvGenThread.setUserDocumentDao(getUserDocumentDAO());
            csvGenThread.setCsvExport(new CsvExporter());

            // Set search attributes for getting audit results
            csvGenThread.setAttributes(mapSessionAttributes(request));

            csvGenThread.start();
        }
        //Otherwise generate and download the export directly
        else{
            List<Map<String, Object>> results;
            SearchPackage packedResults;

            packedResults = this.getResults(request, true);
            results = packedResults.getResults();

            CsvExporter csvExporter = new CsvExporter();
            csvExporter.exportToCSV(response, REPORT_TITLE.replace(" ", "_"), results, (LinkedHashMap<String, String>) csvReportMap);
        }
    }

    private FacilityDAO getFacilityDAO() {
        return this.getBean("FacilityDAO", FacilityDAO.class);
    }


    private UserDocumentDAO getUserDocumentDAO() {
        return this.getBean("UserDocumentDAO", UserDocumentDAO.class);
    }

	/**
	 * Get the excel exporter class from Spring.
	 *
	 * @return the excel exporter object
	 */
	public ExcelExporter getExcelExporter() {
		final ExcelExporter excelExporter = this.getBean("excelExporter",
				ExcelExporter.class);
		return excelExporter;
	}

    /**
     * Organizational class to pack parameters neatly together
     */
    private class SearchPackage{
        List<Map<String,Object>> results;
        String inboundIcn;
        Long totalCount;

        public SearchPackage(List<Map<String, Object>> results, String inboundIcn) {
            this.results = results;
            this.inboundIcn = inboundIcn;
        }

        public List<Map<String, Object>> getResults() {
            return results;
        }

        public void setResults(List<Map<String, Object>> results) {
            this.results = results;
        }

        public String getInboundIcn() {
            return inboundIcn;
        }

        public void setInboundIcn(String inboundIcn) {
            this.inboundIcn = inboundIcn;
        }

        public Long getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }
    }

}
