package gov.va.nvap.web.report;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.web.dao.FacilityDAO;
import gov.va.nvap.web.dao.VisnDAO;
import gov.va.nvap.web.facility.Facility;
import gov.va.nvap.web.visn.Visn;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 *
 * @author Irakli Kakushadze
 * @since 05/16/2016
 */
public class FacilitiesDialog extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getFacilitiesDialog(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException, ParseException {
        final HttpSession session = request.getSession(false);
        List<Facility> facilityEntities = getFacilityDAO().findAllSortByVisn();
        List<Facility> facilities = new ArrayList<Facility>();
        List<Facility> stations = new ArrayList<Facility>();
        List<Visn> visns = getVisnDAO().findAll();

        for (Facility facility : facilityEntities) {
            if (!NullChecker.isNullOrEmpty(facility.getFacilityStation()) && facility.getFacilityStation().trim().length() == 3) {
                facilities.add(facility);
            } else {
                stations.add(facility);
            }
        }

        session.setAttribute("visns", visns);
        session.setAttribute("facilities", facilities);
        session.setAttribute("stations", stations);

        this.forward(request, response, "getFacilitiesDialogAjax");
    }

    private FacilityDAO getFacilityDAO() {
        return this.getBean("FacilityDAO", FacilityDAO.class);
    }

    private VisnDAO getVisnDAO() {
        return this.getBean("VisnDAO", VisnDAO.class);
    }

}
