package gov.va.nvap.web.report;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.ActionValuesType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldType;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.StringValuesType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.adapter.audit.DirectAuditManager;
import gov.va.nvap.service.adapter.audit.DirectServiceEndpoint;
import gov.va.nvap.service.adapter.audit.DirectServiceException;
import gov.va.nvap.service.adapter.doc.AdapterException;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.web.dao.FacilityDAO;
import gov.va.nvap.web.dao.UserDocumentDAO;
import gov.va.nvap.web.helper.document.DocumentHelper;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.helper.report.ReportHelper;
import gov.va.nvap.web.patient.ExcelGeneratorThread;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.util.Paginator;
import gov.va.nvap.web.util.xls.CsvExporter;
import gov.va.nvap.web.util.xls.ExcelExporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.LinkedHashMap;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Disclosures Detail Report results servlet
 *
 * @author Asha Amritraj
 */
public class DocumentDisclosureReportResults extends
    gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    /**
     * Serial UID.
     */
    private static final long serialVersionUID = -8891575215151013736L;

    private AdapterAuditManager adapterAuditManager;
    private final DirectAuditManager directAuditManager = new DirectServiceEndpoint();

    public void exportToCsv(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException, IOException {

        final HttpSession session = request.getSession(false);
        final String documentDisclosureSource = (String) session.getAttribute("documentDisclosureSource");
        List<Map<String, Object>> results;
        if ("direct".equals(documentDisclosureSource)) {
            results = this.getResults(session, new Paginator(Integer.MAX_VALUE));
        } else {
            results = this.getResults(session, new Paginator(this.getReportHelper().getConsentDirectivesReportCapAsInt()));
        }

        CsvExporter csvExporter = new CsvExporter();

        Map<String, String> csvReportMap = new LinkedHashMap<String, String>();

        csvReportMap.put("SSN", "ssn");
        csvReportMap.put("Patient Last Name", "lastName");
        csvReportMap.put("Patient First Name", "firstName");
        csvReportMap.put("Date of Disclosures (CT)", "auditTimeFormatted");
        csvReportMap.put("Disclosures", "disclosureTitle");
        csvReportMap.put("Patient Preferred Facility", "patientFacilityName");
        csvReportMap.put("Patient Preferred Facility Station ID", "patientFacilityNumber");
        csvReportMap.put("eHealth Exchange Organization", "organizationName");
        csvReportMap.put("OID", "oid");
        csvReportMap.put("User ID", "userId");
        csvReportMap.put("Purpose of Use", "purposeForUse");
        csvReportMap.put("User Role", "roleName");

        csvExporter.exportToCSV(response, "Disclosures_Detail_Report", results, (LinkedHashMap<String, String>) csvReportMap);
    }

    /**
     * Export to excel - This method is called when the user clicks on the excel icon in the JSP. Reflection is used in the
     * ResponseDispatcherHttpServlet to call this method based on the http parameters.
     *
     * @param request HTTP Request
     * @param response HTTP Response
     * @throws ServletException
     * @throws IOException
     */
    public void exportToExcel(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        ExcelGeneratorThread exGenThread = new ExcelGeneratorThread("exGenThread");

        final HttpSession session = request.getSession(false);

        exGenThread.setReportSource((String) session.getAttribute("documentDisclosureSource"));

		// Create a map of key which is based on the result data key and the
        // heading value
        // The heading is used to create the column headers and the key is used
        // to pull the data from the results
        final Map<String, String> disclosureMap = new LinkedHashMap<String, String>();

        final Object startDateStr = session.getAttribute("documentDisclosureQueryStartDate");
        final Object endDateStr = session.getAttribute("documentDisclosureQueryEndDate");

        // Generate filters.
        final Map<String, List<Object>> filterMap = new LinkedHashMap<String, List<Object>>();
        final LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();

        filters.put("Disclosure Source", session.getAttribute("documentDisclosureSource"));
        filters.put("SSN", session.getAttribute("documentDisclosureQuerySSN"));
        filters.put("Last Name", session.getAttribute("documentDisclosureQueryLastName"));
        filters.put("First Name", session.getAttribute("documentDisclosureQueryFirstName"));
        //filters.put("User ID", session.getAttribute("documentDisclosureQueryUserId"));
        filters.put("Start Date", this.getReportHelper().getFormattedDate((Date) startDateStr));
        filters.put("End Date", this.getReportHelper().getFormattedDate((Date) endDateStr));
        filters.put("Purpose of Use", ExcelExporter.getFilterValue(session.getAttribute("purposeOfUse")));
        filters.put("Patient Preferred Facility", ExcelExporter.getPatientPreferredFacilityFilter(getFacilityDAO(), (String) session.getAttribute("documentDisclosureQueryFacility")));
        filters.put("eHealth Exchange Org", ExcelExporter.getFilterValue(session.getAttribute("documentDisclosureQueryOrgName")));
        ExcelExporter.populateFilterMapForExport(request, filters, filterMap, session.getAttribute("patientTypes").toString());
        exGenThread.setFilterMap(filterMap);

        disclosureMap.put("ssn", "SSN");
        disclosureMap.put("lastName", "Patient Last Name");
        disclosureMap.put("firstName", "Patient First Name");
        disclosureMap.put("auditTimeFormatted", "Date of Disclosures (CT)");
        disclosureMap.put("documentTitle", "Disclosures");
        disclosureMap.put("patientFacilityName", "Patient Preferred Facility");
        disclosureMap.put("patientFacilityNumber", "Patient Preferred Facility Station ID");
        disclosureMap.put("organizationName", "eHealth Exchange Organization");
        disclosureMap.put("organizationId", "OID");
        disclosureMap.put("userId", "User ID");
        disclosureMap.put("purposeOfUse", "Purpose of Use");
        disclosureMap.put("roleName", "User Role");
        exGenThread.setReportMap(disclosureMap);

        // Set names for Excel generator thread
        exGenThread.setTitle("Disclosures Detailed Report");

        exGenThread.setExcelExporter(this.getExcelExporter());
        exGenThread.setAdapterAuditManager(adapterAuditManager);
        exGenThread.setDirectAuditManager(directAuditManager);
        exGenThread.setReportHelper(getReportHelper());
        exGenThread.setUserId(UserHelper.getUserName(request));
        exGenThread.setUserDocumentDao(getUserDocumentDAO());
        exGenThread.setCmsHelper(getCmsHelper());

        // Set search attributes for getting audit results
        exGenThread.setAttributes(mapSessionAttributes(session));

        exGenThread.start();

        this.forward(request, response, "show");
    }

    private Map<String, Object> mapSessionAttributes(HttpSession session) {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("ssn", (String) session
                .getAttribute("documentDisclosureQuerySSN"));
        attributes.put("lastName", (String) session
                .getAttribute("documentDisclosureQueryLastName"));
        attributes.put("firstName", (String) session
                .getAttribute("documentDisclosureQueryFirstName"));
        attributes.put("userId", (String) session
                .getAttribute("documentDisclosureQueryUserId"));

        Date startDate = (Date) session.getAttribute("documentDisclosureQueryStartDate");
        Date endDate = (Date) session.getAttribute("documentDisclosureQueryEndDate");
        attributes.put("startDate", startDate);
        attributes.put("endDate", endDate);

        attributes.put("organization", (String) session
                .getAttribute("documentDisclosureQueryOrganization"));
        attributes.put("facility", (String) session.getAttribute("documentDisclosureQueryFacility"));
        attributes.put("purposeOfUse", (String) session.getAttribute("purposeOfUse"));
        attributes.put("patientTypes", (Integer) session.getAttribute("patientTypes"));
        // sort
        attributes.put("sortValue", (String) session
                .getAttribute("documentDisclosureSortValue"));
        attributes.put("sortDirection", (String) session
                .getAttribute("documentDisclosureSortDirection"));

        // Set Action Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT);
        actionsType.setNotIn(false);
        attributes.put("actionsType", actionsType);

        return attributes;
    }

    public ConsentManagementHelper getCmsHelper() {
        final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
            ConsentManagementHelper.class);
        return cmsHelper;
    }

    public DocumentHelper getDocumentHelper() {
        return this.getBean("adapterDocumentHelper", DocumentHelper.class);
    }

    /**
     * Get the excel exporter class from Spring.
     *
     * @return the excel exporter object
     */
    public ExcelExporter getExcelExporter() {
        final ExcelExporter excelExporter = this.getBean("excelExporter",
            ExcelExporter.class);
        return excelExporter;
    }

    public ReportHelper getReportHelper() {
        final ReportHelper reportHelper = this.getBean("reportHelper",
            ReportHelper.class);
        return reportHelper;
    }

	// private List<HashMap<String, Object>> getResults(final HttpSession
    // session,
    private List<Map<String, Object>> getResults(final HttpSession session,
            final Paginator paginator) throws AuditException, DirectServiceException {
        // Get the information entered by the user in the GUI
        final String ssn = (String) session
            .getAttribute("documentDisclosureQuerySSN");
        final String lastName = (String) session
            .getAttribute("documentDisclosureQueryLastName");
        final String firstName = (String) session
            .getAttribute("documentDisclosureQueryFirstName");
        final String userId = (String) session
            .getAttribute("documentDisclosureQueryUserId");
        final String facility = (String) session
            .getAttribute("documentDisclosureQueryFacility");
        final String purposeOfUse = (String) session
            .getAttribute("purposeOfUse");

        final Date sd = (Date) session
            .getAttribute("documentDisclosureQueryStartDate");
        final Date ed = (Date) session
            .getAttribute("documentDisclosureQueryEndDate");
        final String organization = (String) session
            .getAttribute("documentDisclosureQueryOrganization");
        final String documentDisclosureSource = (String) session.getAttribute("documentDisclosureSource");
        final int patientTypes = (Integer) session
            .getAttribute("patientTypes");
        // sorting
        final String documentDisclosureSortValue = (String) session
            .getAttribute("documentDisclosureSortValue");
        final String documentDisclosureSortDirection = (String) session
            .getAttribute("documentDisclosureSortDirection");

        final GetAudits getAuditsRequest = new GetAudits();
        if (NullChecker.isNotEmpty(sd)) {
            getAuditsRequest.setFromDate(GregorianDateUtil
                .getGregorianCalendarByDate(sd));
        }
        if (NullChecker.isNotEmpty(ed)) {
            getAuditsRequest.setToDate(GregorianDateUtil
                .getGregorianCalendarByDate(ed));
        }

        // Set Patient Types
        getAuditsRequest.setPatientTypes(patientTypes);

        /*
         * // Set Patient Ids StringValuesType patientIdsType = new
         * StringValuesType(); patientIdsType.setNotIn(false);
         * patientIdsType.getValue().add(icn);
         * getAuditsRequest.setPatientIds(patientIdsType);
         */
        /*
         * // Set Patient Ids if (NullChecker.isNotEmpty(icn)) { final
         * StringValuesType patientIds = new StringValuesType();
         * patientIds.getValue().add(icn); patientIds.setNotIn(false);
         * getAuditsRequest.setPatientIds(patientIds); }
         */
        // Set SSN
        if (NullChecker.isNotEmpty(ssn)) {
            final StringValuesType patientSSNs = new StringValuesType();
            patientSSNs.getValue().add(ssn);
            patientSSNs.setNotIn(false);
            getAuditsRequest.setPatientSSNs(patientSSNs);
        }
        // Set Last Name
        if (NullChecker.isNotEmpty(lastName)) {
            final StringValuesType patientLastNames = new StringValuesType();
            patientLastNames.getValue().add(lastName);
            patientLastNames.setNotIn(false);
            getAuditsRequest.setPatientLastNames(patientLastNames);
        }
        // Set First Name
        if (NullChecker.isNotEmpty(firstName)) {
            final StringValuesType patientFirstNames = new StringValuesType();
            patientFirstNames.getValue().add(firstName);
            patientFirstNames.setNotIn(false);
            getAuditsRequest.setPatientGivenNames(patientFirstNames);
        }
        //Set User ID
        if (NullChecker.isNotEmpty(userId)) {
            final StringValuesType userIdValue = new StringValuesType();
            userIdValue.getValue().add(userId);
            userIdValue.setNotIn(false);
            getAuditsRequest.setUserIds(userIdValue);
        }
        // Set Purpose of Use
        if (!NullChecker.isNullOrEmpty(purposeOfUse)) {
            final StringValuesType purposeForUses = new StringValuesType();
            purposeForUses.getValue().add(purposeOfUse);
            purposeForUses.setNotIn(false);
            getAuditsRequest.setPurposeForUses(purposeForUses);
        }

        // Set Facility Ids
        if (NullChecker.isNotEmpty(facility)) {
            final StringValuesType facilityIds = new StringValuesType();
            facilityIds.setNotIn(false);
            facilityIds.getValue().add(facility);
            getAuditsRequest.setPatientFacilityNumbers(facilityIds);
        }

        // Set Organization Types
        if (NullChecker.isNotEmpty(organization)) {
            final StringValuesType organizationIds = new StringValuesType();
            organizationIds.setNotIn(false);
            organizationIds.getValue().add(organization);
            getAuditsRequest.setOrganizationIds(organizationIds);
        } else {
            // input orgs are empty - intent is to retrieve all orgs except VA
            final StringValuesType organizationIds = new StringValuesType();
            organizationIds.setNotIn(true);
            organizationIds.getValue().add(
                this.getCmsHelper().getCompleteHomeCommunityId());
            getAuditsRequest.setOrganizationIds(organizationIds);
        }

        // sorting
        if (NullChecker.isNotEmpty(documentDisclosureSortValue)) {
            final SortFieldType sortField = new SortFieldType();
            sortField
                .setField(FieldType.fromValue(documentDisclosureSortValue));
            if ("DESC".equalsIgnoreCase(documentDisclosureSortDirection)) {
                sortField.setDirection(SortDirection.DESC);
            } else {
                sortField.setDirection(SortDirection.ASC);
            }
            final SortFieldsType sortFieldsType = new SortFieldsType();
            sortFieldsType.getSortField().add(sortField);
            getAuditsRequest.setSortFields(sortFieldsType);
        }

        /*
         * StringValuesType orgTypes = new StringValuesType(); if
         * (NullChecker.isNotEmpty(organization) &&
         * "external".equals(organization)) { orgTypes.getValue().add("%" +
         * this.getCmsHelper().getHomeCommunity().getOrgOid());
         * orgTypes.setNotIn(true); } else {
         * orgTypes.getValue().add(organization); orgTypes.setNotIn(false); }
         * getAuditsRequest.setOrganizationIds(orgTypes);
         *
         * // Set Remote Organization Types StringValuesType remoteOrgTypes =
         * new StringValuesType(); remoteOrgTypes.setNotIn(false);
         * getAuditsRequest.setRemoteOrganizationIds(remoteOrgTypes);
         */
        // Set Action Value Types
        final ActionValuesType actionsType = new ActionValuesType();
        actionsType.getValue().add(ActionType.RETRIEVE_DOCUMENT);
        actionsType.setNotIn(false);
        getAuditsRequest.setActions(actionsType);
        // Set Page information
        final PageInfoType pageInfoType = new PageInfoType();
        pageInfoType.setPageNumber(paginator.getCurrentPage());
        pageInfoType.setPageSize(paginator.getRecordsPerPage());
        getAuditsRequest.setPageInfo(pageInfoType);

        final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try {
            final GetAuditsResponse queryResponse;
            session.setAttribute("documentDisclosureSource", documentDisclosureSource);
            if (documentDisclosureSource.equals("direct")) {
                queryResponse = this.directAuditManager.getAudits(getAuditsRequest);
            } else {
                queryResponse = this.adapterAuditManager.getAudits(getAuditsRequest);
            }
            if (NullChecker.isNotEmpty(queryResponse)
                && NullChecker.isNotEmpty(queryResponse.getAudits())
                && NullChecker.isNotEmpty(queryResponse.getAudits()
                    .getAudit())) {
                final List<AuditType> auditTypeList = queryResponse.getAudits()
                    .getAudit();
                int pageSize = paginator.getRecordsPerPage();
                for (final AuditType auditType : auditTypeList) {
                    final Map<String, Object> resultMap = new HashMap<String, Object>();
                    // Replace SSN with Mask
                    ReportDataProcessor.addSsnToResultMap(resultMap, auditType.getPatientSSN());
					// final HashMap<String, Object> resultMap = new
                    // HashMap<String, Object>();
                    resultMap.put("patientICN", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getPatientId()));
                    resultMap.put("auditTime", GregorianDateUtil
                        .getDateFromGregorianCalendar(auditType
                            .getAuditTime()));
                    resultMap.put("auditTimeFormatted", this.getReportHelper().getFormattedDateTime(GregorianDateUtil
                        .getDateFromGregorianCalendar(auditType
                            .getAuditTime())));

                    resultMap.put("purposeForUse", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getPurposeForUse()));

                    resultMap
                        .put("userId", ReportDataProcessor
                            .nullEmptyReplaceWithUnknown(auditType
                                .getUserId()));

                    resultMap.put("lastName", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getPatientLastName()));
                    resultMap.put("firstName", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getPatientGivenName()));
                    resultMap.put("patientFacilityName", ReportDataProcessor
                        .fixStation(auditType.getPatientFacilityName()));
                    resultMap.put("patientFacilityNumber", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getPatientFacilityNumber()));
                    resultMap.put("organizationName", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getOrganizationName()));
                    resultMap.put("oid", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getOrganizationId()));
                     resultMap.put("roleName", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getRoleName()));
                    /*
                     * resultMap.put( "facility", this.getCmsHelper()
                     * .getOrganizationByHomeCommunityId(
                     * auditType.getOrganizationId()));
                     */
                    resultMap.put("documentId", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getDocumentId()));
                    resultMap.put("disclosureTitle", ReportDataProcessor
                        .nullEmptyReplaceWithUnknown(auditType
                            .getDocumentTitle()));
                    results.add(resultMap);
                }

				// TODO: Move setting of session variables to a different method
                // Check if any of the patient match criteria exists
                if (NullChecker.isNotEmpty(ssn)
                    || NullChecker.isNotEmpty(lastName)
                    || NullChecker.isNotEmpty(firstName)) {
                    // Default to unknown
                    String resultIcn = "";
                    if (NullChecker.isNotEmpty(auditTypeList)) {
                        final AuditType result = auditTypeList.get(0);
                        resultIcn = result.getPatientId();

                        if (NullChecker.isNotEmpty(resultIcn)) {
                            for (final AuditType auditType : auditTypeList) {
                                if (!resultIcn.equals(auditType.getPatientId())) {
                                    resultIcn = "Multiple ICNs";
                                    break;
                                }
                            }
                        } else if (NullChecker.isNotEmpty(result
                            .getPatientGivenName())
                            && NullChecker.isNotEmpty(result
                                .getPatientLastName())
                            && NullChecker.isNotEmpty(result
                                .getPatientSSN())) {
                            final String patientGivenName = result
                                .getPatientGivenName();
                            final String patientLastName = result
                                .getPatientLastName();
                            final String patientSsn = result.getPatientSSN();
                            boolean multipleIcns = false;
                            for (final AuditType auditType : auditTypeList) {
                                if (!patientGivenName.equals(auditType
                                    .getPatientGivenName())
                                    || !patientLastName.equals(auditType
                                        .getPatientLastName())
                                    || !patientSsn.equals(auditType
                                        .getPatientSSN())) {
                                    multipleIcns = true;
                                    break;
                                }
                            }
                            if (multipleIcns) {
                                resultIcn = "Multiple ICNs";
                            } else {
                                resultIcn = this.getReportHelper().resolveICN(
                                    result.getPatientGivenName(),
                                    result.getPatientLastName(),
                                    result.getPatientSSN());
                            }
                        }
                    } else if (NullChecker.isNotEmpty(ssn)
                        && NullChecker.isNotEmpty(lastName)
                        && NullChecker.isNotEmpty(firstName)) {
                        // Try to get from what was typed
                        resultIcn = this.getReportHelper().resolveICN(
                            firstName, lastName, ssn);
                    }
                    // Set in Session
                    if (NullChecker.isEmpty(resultIcn)) {
                        resultIcn = "Unknown";
                    }
                    session.setAttribute("documentDisclosureQueryICN",
                        resultIcn);
                }
                //return results;
            }
        } catch (final AuditException ex) {
            throw new AuditException();
        } catch (final DirectServiceException ex) {
            throw new DirectServiceException();
        }

        return results;
    }

    private boolean isPaginatorPresent(final HttpSession session) {
        return !NullChecker.isNullOrEmpty(session.getAttribute("paginator"));
    }

    public void next(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        final HttpSession session = request.getSession(false);
        if (this.isPaginatorPresent(session)) {
            final Paginator paginator = (Paginator) session.getAttribute("paginator");
            paginator.next(request);
            session.setAttribute("paginator", paginator);
            session.setAttribute("documentDisclosureResults",
                this.getResults(session, paginator));
            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    public void prev(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        final HttpSession session = request.getSession(false);
        if (this.isPaginatorPresent(session)) {
            final Paginator paginator = (Paginator) session.getAttribute("paginator");
            paginator.previous(request);
            session.setAttribute("paginator", paginator);
            session.setAttribute("documentDisclosureResults",
                this.getResults(session, paginator));
            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    @EJB(beanInterface = AdapterAuditManager.class, mappedName = "AdapterAuditManager")
    public void setAdapterAuditManager(
        final AdapterAuditManager adapterAuditManager) {
        this.adapterAuditManager = adapterAuditManager;
    }

    @Override
    public void unspecified(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        final HttpSession session = request.getSession(false);

        // sort
        final String documentDisclosureSortValue = request
            .getParameter("documentDisclosureSortValue");
        final String documentDisclosureSortDirection = request
            .getParameter("documentDisclosureSortDirection");
        session.setAttribute("documentDisclosureSortValue",
            documentDisclosureSortValue);
        session.setAttribute("documentDisclosureSortDirection",
            documentDisclosureSortDirection);

        if (this.isPaginatorPresent(session)) {
            Paginator paginator = (Paginator) session.getAttribute("paginator");
            if (NullChecker.isEmpty(paginator)) {
                paginator = new Paginator(0);
                session.setAttribute("paginator", paginator);
            }
            paginator.reset();
            session.setAttribute("documentDisclosureResults",
                this.getResults(session, paginator));

            this.forward(request, response, "show");
        } else {
            this.forward(request, response, "noshow");
        }
    }

    public void view(final HttpServletRequest request,
        final HttpServletResponse response) throws ServletException,
        IOException {
        final HttpSession session = request.getSession(false);
        final String icn = request.getParameter("icn");
        final String documentUniqueId = request
            .getParameter("documentUniqueId");
        final String styleSheetViewType = request
            .getParameter("styleSheetViewType");

        String document = null;
        try {
            document = this.getDocumentHelper().getDocument(icn,
                documentUniqueId, UserHelper.getUserName(request),
                this.getCmsHelper().getCompleteHomeCommunityId());
        } catch (final AdapterException ex) {
            throw new ServletException(ex);
        }
        session.setAttribute("document", document);
        session.setAttribute("icn", icn);
        session.setAttribute("documentUniqueId", documentUniqueId);
        session.setAttribute("isXmlViewEnabled", this.getDocumentHelper()
            .isXmlViewEnabled());

        if ("xml".equals(styleSheetViewType)) {
            document = document
                .replaceAll(
                    "<?xml-stylesheet type=\"text/xsl\" href=\"CCD.xsl\"?>",
                    "");
            response.setContentType("text/xml;charset=UTF-8");
            response.getWriter().write(document);
        } else {
            // Update session in the document
            final String html = this.getDocumentHelper().getHtml(document,
                styleSheetViewType);
            session.setAttribute("updatedDocument", html);
            this.forward(request, response,
                "showDocumentDisclosureReportDocument");
        }
    }

    private FacilityDAO getFacilityDAO() {
        return this.getBean("FacilityDAO", FacilityDAO.class);
    }

    private UserDocumentDAO getUserDocumentDAO() {
        return this.getBean("UserDocumentDAO", UserDocumentDAO.class);
    }
}
