package gov.va.nvap.web.patient;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.web.helper.facility.FacilityHelper;
import gov.va.nvap.web.user.UserHelper;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Stephen Miller
 */
public class SetDefaultFacility extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {
	static private final Log LOG = LogFactory.getLog(SetDefaultFacility.class);
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 5356729716646683218L;

	public void setManualFacility(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {

		if (this.validate(request, response)) {
			final HttpSession session = request.getSession(false);

			final String newFacility = request.getParameter("facility");
			session.setAttribute("defaultUserFacility", newFacility);
			response.addCookie(setFacilityCookie(newFacility));
			this.forward(request, response, "success");
		}else {
			this.forward(request, response, "validate");
			return;
		}
	}

	public void removeManualFacility(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		if (this.validate(request, response)) {
			final HttpSession session = request.getSession(false);
			gov.va.nvap.svc.facility.data.Facility defaultAutoUserFacility = this.getFacilityHelper().getFacilityStationByVHAUserId(
					UserHelper.getUserName(request));
			if(!NullChecker.isNullOrEmpty(defaultAutoUserFacility)){//there is an automatic
				session.setAttribute("defaultUserFacility", defaultAutoUserFacility);
			}else{// there is no automatic or manual
				session.removeAttribute("defaultUserFacility");
			}
			response.addCookie(removeFacilityCookie());
			this.forward(request, response, "success");
		}else {
			this.forward(request, response, "validate");
			return;
		}
	}

	private Cookie removeFacilityCookie() {
		Cookie vapCookie = null;
		vapCookie = new Cookie("facility", "");
		vapCookie.setMaxAge(0);
		return vapCookie;
	}

    private boolean isAlphaNumeric(String s){
        String pattern= "^[a-zA-Z0-9]*$";

        return s.matches(pattern);
    }

	private Cookie setFacilityCookie(final String setFacility) {

		Cookie vapCookie = null;
        //Create the facility object and lookup the facility by the station number sent in the request.
        Facility newDefaultFacility;
        newDefaultFacility = this.getFacilityHelper().getFacilityByStationId(setFacility);
		if (newDefaultFacility != null) {
			if (newDefaultFacility.getFacilityStation().equals("")) {
				vapCookie = new Cookie("facility", "");
				vapCookie.setMaxAge(0);
			} else if (isAlphaNumeric(newDefaultFacility.getFacilityStation())) {
				vapCookie = new Cookie("facility", newDefaultFacility.getFacilityStation());
				vapCookie.setMaxAge(5 * 365 * 24 * 60 * 60);
			}
		}
		return vapCookie;
	}

	/**
	 * Get the facility helper from Spring.
	 */
	public FacilityHelper getFacilityHelper() {
		final FacilityHelper facilityHelper = this.getBean("facilityHelper",
				FacilityHelper.class);
		return facilityHelper;
	}

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);

		request.setAttribute("facilities", this.getFacilityHelper()
				.getAllVistAFacilities());

		String facilityName = "";
		String facilityStation = "";

		Cookie[] vapCookies = request.getCookies();
		gov.va.nvap.svc.facility.data.Facility defaultUserFacility = null;
		if (vapCookies != null){
			for (Cookie vapCookie : vapCookies){
				if (vapCookie.getName().equals("facility")){
					if (NullChecker.isNotEmpty(vapCookie.getValue())) {
						defaultUserFacility = new Facility();
                        try {
                            Facility facility = this.getFacilityHelper().getFacilityByStationId(vapCookie.getValue());
                            if (facility != null) {
                                defaultUserFacility.setFacilityStation(facility.getFacilityStation());
                                defaultUserFacility.setFacilityName(facility.getFacilityName());
                                defaultUserFacility.setVisnId(facility.getVisnId());
                                session.setAttribute("defaultUserFacility", defaultUserFacility);
                                request.setAttribute("visualDefaultUserFacility", facility.getFacilityName()+" ("+facility.getFacilityStation()+")");
                                request.setAttribute("facilityState", "manual");
                            }
                        } catch (Exception e) {
                            // TODO: couldn't set the default facility...
                        }
					}
				}
			}
		}

		if(NullChecker.isNullOrEmpty(defaultUserFacility)){
			final gov.va.nvap.svc.facility.data.Facility defaultAutoUserFacility = this
					.getFacilityHelper().getFacilityStationByVHAUserId(
							UserHelper.getUserName(request));
			if (!(NullChecker.isNullOrEmpty(defaultAutoUserFacility))) {
				facilityName = defaultAutoUserFacility.getFacilityName();
				facilityStation = defaultAutoUserFacility.getFacilityStation();
				request.setAttribute("visualDefaultUserFacility", facilityName+" ("+facilityStation+")");
				request.setAttribute("facilityState", "auto");
			}else{
				request.setAttribute("facilityState", "none");
			}
		}

		this.forward(request, response, "show");
	}
}