package gov.va.nvap.web.patient;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Search results after searching a patient and when there are no/multiple
 * results from the MPI.
 * 
 * @author David Vazquez Modified By: Asha Amritraj
 */
public class PatientSearchResults extends ResponseDispatcherHttpServlet {
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 4867841720319766661L;

	public void select(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		final String icn = request.getParameter("icn");
		String icnAttributeName = this.getServletConfig().getInitParameter(
				"icnAttributeName");

		if (NullChecker.isNullOrEmpty(icnAttributeName)) {
			icnAttributeName = "icn";
		}

		if (this.validate(request, response, "select")) {
			session.setAttribute(icnAttributeName, icn);
			this.forward(request, response, "select");
		} else {
			this.forward(request, response, "validate");
		}
	}

	@Override
	public void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);

		if (session.getAttribute("patients") != null) {
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}
}
