package gov.va.nvap.web.patient;

import gov.va.nvap.service.pdq.PatientMatchQuery;
import gov.va.nvap.service.pdq.PatientMatchResponse;
import gov.va.nvap.service.pdq.PatientProfile;
import gov.va.nvap.service.pdq.PdqException;
import gov.va.nvap.service.pdq.PdqService;
import java.io.IOException;
import java.util.List;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Calls the authorization service to search for a patient.
 * 
 * @author Asha Amritraj
 */
public class PatientSearch extends
		gov.va.nvap.web.app.ResponseDispatcherHttpServlet {
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 8307602438204383826L;

	@EJB(beanInterface = PdqService.class, mappedName = "PdqService")
	PdqService pdqService;

	/**
	 * Search for a patient.
	 */
	public void search(final HttpServletRequest request,
            final HttpServletResponse response) throws ServletException,
            IOException, PdqException {
		final HttpSession session = request.getSession(false);
		final String ssn = request.getParameter("ssn");
		final String lastName = request.getParameter("lastName");
		final String firstName = request.getParameter("firstName");

		if (this.validate(request, response, "search")) {
			try {
				// Create a patient profile and search for patient
				final PatientProfile patient = new PatientProfile();
				patient.setFirstName(firstName);
				patient.setLastName(lastName);
				patient.setSsn(ssn);
				final PatientMatchQuery patientSearchRequest = new PatientMatchQuery();
				patientSearchRequest.setPatientProfile(patient);
				// Call PDQ service to get the matching patient
                final PatientMatchResponse patientSearchResponse = this.getPatientMatch(patientSearchRequest);
				final List<PatientProfile> patients = patientSearchResponse.getPatients().getPatientProfile();

				if (patients.isEmpty()) {
					session.setAttribute("patients", patients);
					this.forward(request, response, "none");
				} else if (patients.size() >= 2) {
					session.setAttribute("patients", patients);
					this.forward(request, response, "multiple");
				} else {
					final String icn = patients.get(0).getIcn();
					session.setAttribute("icn", icn);
					this.forward(request, response, "single");
				}
			} catch (final PdqException ex) {
				throw new PdqException();
			}
		} else {
			this.forward(request, response, "validate");
		}
	}

	@Override
	public void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		session.setAttribute("patients", null);
		session.setAttribute("icn", null);
		this.forward(request, response, "show");
	}
    
    private PatientMatchResponse getPatientMatch(PatientMatchQuery pmq) throws PdqException {
        try {
            PatientMatchResponse patientSearchResponse = this.pdqService.searchPatient(pmq);

            return patientSearchResponse;
        } catch(Exception e) {
            throw new PdqException();
        }
    }
}
