package gov.va.nvap.web.patient;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Johann Sonnenberg
 * @author Darren Henderson
 */
public class PatientCommentDAO {

    /**
     * Entity Manager instance.
     */
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public PatientComment create(PatientComment comment) {
        em.persist(comment);
        return comment;
    }

    public List<PatientComment> getCommentsByPatientIen(String patientIen) {
        Query query = em.createQuery("SELECT c FROM PatientComment c WHERE c.patientIen = :patientIen ORDER BY c.dateAdded DESC");
        query.setParameter("patientIen", patientIen);

        return (List<PatientComment>) query.getResultList();
    }

    /**
     * Set the entity manager (Injected by Spring).
     *
     * @param em Entity manager to be stored
     */
    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
}
