package gov.va.nvap.web.patient;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Johann Sonnenberg
 * @author Darren Henderson
 */
@Entity
@Table(name = "PATIENT_COMMENT")
@NamedQueries({
    @NamedQuery(name = "PatientComment.findAll", query = "SELECT c FROM PatientComment c"),
    @NamedQuery(name = "PatientComment.findByCommentId", query = "SELECT c FROM PatientComment c WHERE c.commentId = :commentId"),
    @NamedQuery(name = "PatientComment.findByUserId", query = "SELECT c FROM PatientComment c WHERE c.userId = :userId"),
    @NamedQuery(name = "PatientComment.findByDateAdded", query = "SELECT c FROM PatientComment c WHERE c.dateAdded = :dateAdded"),
    @NamedQuery(name = "PatientComment.findByPatientIen", query = "SELECT c FROM PatientComment c WHERE c.patientIen = :patientIen")})
public class PatientComment implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name = "consentCommentSequence", sequenceName = "CONSENT_COMMENT_SEQ", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "consentCommentSequence")
    @Basic(optional = false)
    @Column(name = "COMMENT_ID")
    private Long commentId;
    @Basic(optional = false)
    @Column(name = "USER_ID")
    private String userId;
    @Basic(optional = false)
    @Column(name = "DATE_ADDED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateAdded;
    @Basic(optional = false)
    @Lob
    @Column(name = "COMMENTS")
    private String comments;
    @Basic(optional = false)
    @Column(name = "PATIENT_IEN")
    private String patientIen;

    public PatientComment() {
    }

    public PatientComment(Long commentId) {
        this.commentId = commentId;
    }

    public PatientComment(Long commentId, String userId, Date dateAdded, String comments, String patientIen) {
        this.commentId = commentId;
        this.userId = userId;
        this.dateAdded = dateAdded;
        this.comments = comments;
        this.patientIen = patientIen;
    }

    public Long getCommentId() {
        return commentId;
    }

    public void setCommentId(Long commentId) {
        this.commentId = commentId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Date getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public String getComments() {
        return comments.replace("&#39;", "'");
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getPatientIen() {
        return patientIen;
    }

    public void setPatientIen(String patientIen) {
        this.patientIen = patientIen;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (commentId != null ? commentId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof PatientComment)) {
            return false;
        }
        PatientComment other = (PatientComment) object;
        if ((this.commentId == null && other.commentId != null) || (this.commentId != null && !this.commentId.equals(other.commentId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return 
            "commentId=[" + commentId + "] " +
            "userId=[" + userId + "] " +
            "dateAdded=[" + dateAdded.toString() + "] " +
            "comments=[" + comments + "] " +
            "patientIen=[" + patientIen + "]";
    }
    
}
