package gov.va.nvap.web.patient;

import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * @author Nusrath Mohammed
 */
public class ExpiringConsentNotification extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {
	
	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = -2352784389624881604L;
	
	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}
    
    public Map<String, String> getPreLoadValues() {
        final Map<String, String> values = this.getCmsHelper().getExpiringConsentConfiguration();
        String convertedEmails = values.get("emailAddresses");
        // Convert ';' to line breaks for display purposes
        if (convertedEmails != null && !convertedEmails.isEmpty()) {
            convertedEmails = convertedEmails.replaceAll(";", "\n");
        }
        values.put("emailAddresses", convertedEmails);
        return values;
    }

	public void save(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		
		final String distributionList = 
                request.getParameter("distributionList").replaceAll("\\s+", ";");
		final String maxDaysToExpiration = request.getParameter("maxDaysToExpiration");
		final String frequency = request.getParameter("frequency");

		this.getCmsHelper().updateExpiringConsentConfiguration
							(frequency, Long.valueOf(maxDaysToExpiration), distributionList);
		
		this.forward(request, response, "success");
		
	}

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);

		session.setAttribute("configurationValues", this.getPreLoadValues());

		this.forward(request, response, "show");
	}

}