package gov.va.nvap.web.helper.facility;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityService;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

/**
 * A Utility class to get the assigning authority name based on a organization
 * oid.
 * 
 * @author Asha Amritraj
 * 
 */
public class FacilityHelper implements InitializingBean {

	private static final Logger logger = Logger.getLogger(FacilityHelper.class
			.getName());

	// Keep a cache of names - they would not change.
	private final Map<String, String> aaNames = new HashMap<String, String>();
	private FacilityService facilityService;
	
	//Collection<Facility> allFacilities = null;
	//Collection<Facility> supportedFacilities = null;

	@Override
	public void afterPropertiesSet() throws Exception {
		// Pre-load if needed!
	//	allFacilities = this.facilityService.getAllVistAFacilities();
	//	supportedFacilities = this.facilityService.getAllowedVistAFacilities();
	}

	/**
	 * Get the allowed VistA Facilities.
	 */
	public Collection<Facility> getAllowedVistAFacilities() {
		return this.facilityService.getAllowedVistAFacilities();
		//return this.supportedFacilities;
	}
	
	/**
	 * Get the All VistA Facilities.
	 */
	public Collection<Facility> getAllVistAFacilities() {
		return this.facilityService.getAllVistAFacilities();
		//return this.allFacilities;
	}

	/**
	 * Get the authority name by the organization oid. Calls the PIP to get the
	 * information.

	public String getAuthorityName(final String oid) {
		if (this.aaNames.containsKey(oid)) {
			return this.aaNames.get(oid);
		} else {
			final String value = this.pip.getAuthorityName(oid);
			this.aaNames.put(oid, value);
			return value;
		}

	}
	 */
	public Facility getFacilityByStationId(final String stationId) {
		Facility fac = null;
		if (NullChecker.isNullOrEmpty(stationId)) {
			return fac;
		}
		try {
			fac = this.facilityService.getFacilityByStationNumber(stationId);
		} catch (final Exception ex) {
			//FacilityHelper.logger
			//		.warning("Exception thrown trying to execute getFacilityByStationId["
			//				+ stationId + "] -" + ex.getMessage());
			FacilityHelper.logger
			.warning("Exception thrown trying to execute getFacilityByStationId");			
		}
		return fac;

	}

	public String getFacilityNameByStationId(final String stationId) {
		final Facility fac = this.getFacilityByStationId(stationId);
		String facilityName = "";
		if (fac != null) {
			facilityName = fac.getFacilityName();
		}
		return facilityName;
	}
	
	@Required
	public void setFacilityService(final FacilityService facilityService) {
		this.facilityService = facilityService;
	}
	
	public  String getFaciltyStationIdByUserId(final String userId) {
		String facilityStationId = "";
		Facility fac = getFacilityStationByVHAUserId(userId);
		if (fac != null) {
			facilityStationId = fac.getFacilityStation();
		}
		return facilityStationId;
	}
	

	public Facility getFacilityStationByVHAUserId(final String userId) {
		Facility fac = null;
		try {
			fac = this.facilityService.getVHAUserFacility(userId);
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
		} catch (EntityDoesNotExistException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
		}
		return fac;
	}

}
