package gov.va.nvap.web.helper.document;

public enum MediaType {
	APPLICATIONBINARY("application/binary", "bin"), APPLICATIONPDF(
			"application/pdf", "pdf"), 
			MULTIPARTFORMDATAXLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"),
			MULTIPARTFORMDATAXLS("application/vnd.ms-excel", "xls"),
			MULTIPARTFORMDATACSV("application/vnd.ms-excel", "csv"),
			IMAGEBMP("image/bmp", "bmp"), IMAGECOD(
			"image/cis-cod", "cod"), IMAGEGIF("image/gif", "gif"), IMAGEIEF(
			"image/ief", "ief"), IMAGEJPEG("image/jpeg", "jpg"), IMAGEPJPEG(
			"image/pjpeg", "jpg"), IMAGEPNG("image/png", "png"), IMAGEPNG2(
			"image/x-png", "png"), IMAGESVG("image/svg+xml", "svg"), IMAGETIF(
			"image/tiff", "tif"), PLAINTEXT("text/plain", "txt");

	public static MediaType fromValue(final String value) {
		for (final MediaType type : MediaType.values()) {
			if (type.mediaType().equals(value)) {
				return type;
			}
		}
		throw new RuntimeException("Media Type " + value + " not supported!");
	}

	public static String getSupportedTypes() {
		String supportedTypes = "";
		for (int i = 0; i < MediaType.values().length; i++) {
			supportedTypes = supportedTypes + MediaType.values()[i].extension;
			if (i + 1 < MediaType.values().length) {
				supportedTypes = supportedTypes + ',';
			}
		}
		return supportedTypes;
	}

	public static boolean isSupported(final String value) {
		for (final MediaType type : MediaType.values()) {
			if (type.mediaType().equals(value)) {
				return true;
			}
		}
		return false;
	}

	private String extension;

	private String mediaTypeString;

	private MediaType(final String mediaTypeString, final String extension) {
		this.mediaTypeString = mediaTypeString;
		this.extension = extension;
	}

	public String extension() {
		return this.extension;
	}

	public String mediaType() {
		return this.mediaTypeString;
	}

}
