package gov.va.nvap.web.helper.document;

public enum DocumentType {
	C62("C62"), PrivacyConsentDirective("PrivacyConsentDirective");

	public static DocumentType fromValue(final String value) {
		for (final DocumentType type : DocumentType.values()) {
			if (type.value().equals(value)) {
				return type;
			}
		}
		throw new RuntimeException("Document Type " + value + " not supported!");

	}

	private String documentType;

	private DocumentType(final String documentType) {
		this.documentType = documentType;
	}

	public String value() {
		return this.documentType;
	}
}
