package gov.va.nvap.web.document;

import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.common.xpath.XPathException;
import gov.va.nvap.web.helper.document.DocumentHelper;
import gov.va.nvap.web.helper.document.DocumentType;
import gov.va.nvap.web.helper.document.MediaType;
import gov.va.nvap.web.helper.document.RepresentationType;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Helps in viewing documents such as the C32. TODO: Create a XSL for C62
 * documents.
 * 
 * @author Asha Amritraj
 */
public class ViewAttachment extends
		gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 2743404151409143023L;

	/**
	 * Get the document helper from Spring.
	 */
	public DocumentHelper getDocumentHelper() {
		return this.getBean("adapterDocumentHelper", DocumentHelper.class);
	}

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {

		final HttpSession session = request.getSession(false);
		// Get the document from session
		final String document = (String) session.getAttribute("document");
		// Get the mediaType, representation and document type from the URL
		// parameter
		final String mediaTypeStr = request.getParameter("mediaType");
		final String representationStr = request.getParameter("representation");
		final String docTypeStr = request.getParameter("docType");

		final DocumentType docType = DocumentType.fromValue(docTypeStr);
		final MediaType mediaType = MediaType.fromValue(mediaTypeStr);
		final RepresentationType representationType = RepresentationType
				.fromValue(representationStr);

		// Proceed only if the required paramters are present
		if (NullChecker.isNotEmpty(mediaType)
				&& NullChecker.isNotEmpty(document)) {
			try {
				String attachmentContent = null;
				switch (docType) {
				case C62:
					attachmentContent = this.getDocumentHelper()
							.getC62Attachment(document);
					break;
				case PrivacyConsentDirective:
					attachmentContent = this.getDocumentHelper()
							.getPrivacyConsentDirectiveAttachment(document);
					break;
				default:
					throw new RuntimeException("Document type not supported!");
				}
				if (NullChecker.isNotEmpty(attachmentContent)) {
					this.getDocumentHelper().writeAttachmentToStream(response,
							attachmentContent, mediaType, representationType);
				} else {
					session.setAttribute("informationMessage",
							"There are no attachments associated with this record.");
					this.forward(request, response, "noattachment");
				}
			} catch (final TransformerException ex) {
				throw new ServletException(ex);
			} catch (final XPathException ex) {
				throw new ServletException(ex);
			}
		} else {
			// Media type & document has to be set
			this.forward(request, response, "error");
		}
	}
}
