package gov.va.nvap.web.dao;

import gov.va.nvap.web.user.role.UserRole;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author Zack Peterson
 */
public class UserRoleDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<UserRole> findAll() {
        try {
            final Query q = this.em.createNamedQuery("UserRole.findAll");
            return (List<UserRole>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<>();
        }
    }

    public List<UserRole> findByUserName(String userName) {
        try {
            final Query q = this.em.createNamedQuery("UserRole.findByUserName");
            q.setParameter("userName", userName);
            return (List<UserRole>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<>();
        }
    }

    public List<String> findUserRoleNames(String userName) {
        try {
            final Query q = this.em.createNamedQuery("UserRole.findUserRoleNames");
            q.setParameter("userName", userName);
            return (List<String>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<>();
        }
    }
}
