/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.Date;

/**
 *
 * @author Raul Alfaro
 */
public class UserAuditDAO {
    @PersistenceContext
	private EntityManager em;

    /**
     * Set the entity manager (Injected by Spring).
     * @param em
     */
    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
    
    /**
     * creates query with two parameters that need to be filled in, startDate and endDate, both inclusive
     * @return 
     */
    private Query makeHourlyCountQuery(){
        return this.em.createNamedQuery("UserAccessAudit.hourCount");
    }
    
    /**
     * Gets count for log ins between provided dates, dates should include timestamps
     * @param query
     * @param startDate
     * @param endDate
     * @return 
     */
    public final List<Object> getResults(final Date startDate, final Date endDate){
        
        final Query query = makeHourlyCountQuery();
        //add parameter dats to query
        query.setParameter("startDate", startDate);
        query.setParameter("endDate", endDate);
        
        return query.getResultList();
    }
    
    
}
