package gov.va.nvap.web.dao;

import gov.va.nvap.web.entities.PurposeOfUse;

import java.util.Collection;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;


/**
 * DAO for getting the PurposeOfUse from the PURPOSE_OF_USE table.
 * @author Sridhar Varma Alluri
 * @since 12/16/2014
 */
public class PurposeOfUseDAO {

	/**
	 * Entity Manager instance.
	 */
	@PersistenceContext
	private EntityManager em;

	/**
	 * Set the entity manager (Injected by Spring).
	 */
	public void setEntityManager(final EntityManager em) {
		this.em = em;
	}

	@SuppressWarnings("unchecked")
	public Collection<PurposeOfUse> findPurposeOfUse() {
		Query query = em.createQuery("SELECT p FROM PurposeOfUse p");
	    return (Collection<PurposeOfUse>) query.getResultList();
	}	
}