package gov.va.nvap.web.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Johann Sonnenberg
 */
public class OrganizationDAO {
    /**
    * Entity Manager instance.
    */
    @PersistenceContext
    private EntityManager em;
    
    /**
     * Set the entity manager (Injected by Spring).
     */
    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
    
    public Organization getOrganization(final Long orgId) {
        return this.em.find(Organization.class, orgId);
    }
    
    @Transactional
    public Organization create(final Organization o)
            throws Exception {
        try {
            this.em.persist(o);
        } catch (final Exception ex) {
            throw ex;
        }
        return o;
    }
    
    @Transactional
    public Organization update(final Organization o)
            throws Exception {
        try {
            this.em.merge(o);
        } catch (final Exception ex) {
            throw ex;
        }
        return o;
    }
    
    public HashMap listAllOrganizations(final Integer maxRows, final Integer startRow, String sortBy, String sortOrder) {
        String query = "SELECT o FROM Organization o WHERE 1 = 1";
        String countQuery = "SELECT COUNT(o.orgId) FROM Organization o WHERE 1 = 1";
        String queryParams = "";
        
        //handle the sort by
        Integer sort = sortBy.isEmpty() ? 7 : Integer.parseInt(sortBy);

        switch (sort) {
            case 0: 
                queryParams = queryParams + " ORDER BY o.active";
                break;
            case 1: 
                queryParams = queryParams + " ORDER BY lower(o.oorgPhoneNumber)";
                break;
            case 2: 
                queryParams = queryParams + " ORDER BY lower(o.orgCommunityIdPrefix)";
                break;
            case 3: 
                queryParams = queryParams + " ORDER BY o.orgConsumerOnly";
                break;
            case 4: 
                queryParams = queryParams + " ORDER BY lower(o.orgContact)";
                break;
            case 5: 
                queryParams = queryParams + " ORDER BY lower(o.orgDomain)";
                break;
            case 6: 
                queryParams = queryParams + " ORDER BY lower(o.orgName)";
                break;
            case 7: 
                queryParams = queryParams + " ORDER BY lower(o.orgNumber)";
                break;
            case 8: 
                queryParams = queryParams + " ORDER BY lower(o.orgOid)";
                break;
            case 9: 
                queryParams = queryParams + " ORDER BY o.isTrustedClinicalSource";
                break;
            default: 
                queryParams = queryParams + " ORDER BY lower(o.orgName) ASC";
                break;
        }

        //handle the sort order
        sortOrder = sortOrder.isEmpty() ? " DESC" : " " + sortOrder;
        queryParams = queryParams + sortOrder;

        query = query + queryParams;
        countQuery = countQuery + queryParams;
        
        Query q = em.createQuery(query).setFirstResult(startRow);
        
        if( maxRows != -1 ) //set the max rows if we have it
        {
            q.setMaxResults(maxRows);
        } 
        
        Query cq = em.createQuery(countQuery);
        
        HashMap hm = new HashMap();
        hm.put("results", (List<Organization>) q.getResultList());
        hm.put("count", (Long) cq.getSingleResult());

        return hm;
    }
}
