/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.dao;

import gov.va.nvap.web.facility.Facility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author Johann Sonnenberg
 */
public class FacilityDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }
    
    public List<Facility> findAll() {
        try {
            final Query q = this.em.createNamedQuery("Facility.findAll");
            return (List<Facility>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<Facility>();
        }
    }
    
    public List<Facility> findAllSortByVisn() {
        try {
            final Query q = this.em.createNamedQuery("Facility.findAllSortByVisn");
            return (List<Facility>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<Facility>();
        }
    }
    
    public Facility findByStationNumber(String stationNumber) {
        try {
            final Query q = this.em.createNamedQuery("Facility.findByFacilityStation");
            q.setParameter("facilityStation", stationNumber);
            return (Facility) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }

    public List<Facility> findByStationNumbers(String stationNumbers) {
        try {
            final Query q = this.em.createNamedQuery("Facility.findByFacilityStations");
            List<String> items = Arrays.asList(stationNumbers.split(","));
            q.setParameter("facilityStations", items);
            return (List<Facility>) q.getResultList();
        } catch (final NoResultException nre) {
            return null;
        }
    }
}
