package gov.va.nvap.web.dao;

import gov.va.nvap.web.user.role.AllowedRole;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author Zack Peterson
 */
public class AllowedRoleDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<AllowedRole> findAll() {
        try {
            final Query q = this.em.createNamedQuery("AllowedRole.findAll");
            return (List<AllowedRole>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<>();
        }
    }

    public AllowedRole findByRoleId(String roleId) {
        try {
            final Query q = this.em.createNamedQuery("AllowedRole.findByRoleId");
            q.setParameter("roleId", roleId);
            return (AllowedRole) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }

    public AllowedRole findByRoleName(String roleName) {
        try {
            final Query q = this.em.createNamedQuery("AllowedRole.findByRoleName");
            q.setParameter("roleName", roleName);
            return (AllowedRole) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }

    public boolean containsAllowedRole(List<String> roleNames) {
        try {
            final Query q = this.em.createNamedQuery("AllowedRole.findRoleInCollection");
            q.setParameter("roleNames", roleNames);
            if (!q.getResultList().isEmpty()) return true;
        } catch (final Exception e) {
            return false;
        }
        return false;
    }
}
