package gov.va.nvap.web.consent.comment;

import gov.va.nvap.common.validation.NullChecker;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Johann Sonnenberg
 */
public class ConsentCommentDAO {

    /**
     * Entity Manager instance.
     */
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public ConsentComment create(ConsentComment comment) {
        em.persist(comment);
        return comment;
    }

    public List<ConsentComment> getCommentsByConsentIds(List<Long> consentIds) {
        if (NullChecker.isNullOrEmpty(consentIds)) {
            return new ArrayList<ConsentComment>();
        } else {
            Query query = em.createQuery("SELECT c FROM ConsentComment c WHERE c.consentId IN (:consentIds) ORDER BY c.dateAdded DESC");
            query.setParameter("consentIds", consentIds);

            return (List<ConsentComment>) query.getResultList();
        }
    }

    public List<ConsentComment> getCommentsByDelayedConsentIds(List<Long> delayedConsentIds) {
        if (NullChecker.isNullOrEmpty(delayedConsentIds)) {
            return new ArrayList<ConsentComment>();
        } else {
            Query query = em.createQuery("SELECT c FROM ConsentComment c WHERE c.delayedConsentId IN (:delayedConsentIds) ORDER BY c.dateAdded DESC");
            query.setParameter("delayedConsentIds", delayedConsentIds);

            return (List<ConsentComment>) query.getResultList();
        }
    }

    /**
     * Set the entity manager (Injected by Spring).
     *
     * @param em EntityManager instance
     */
    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
    
}
