package gov.va.nvap.web.consent.comment;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @since 04/06/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "CONSENT_COMMENT")
@NamedQueries({
    @NamedQuery(name = "ConsentComment.findAll", query = "SELECT c FROM ConsentComment c"),
    @NamedQuery(name = "ConsentComment.findByCommentId", query = "SELECT c FROM ConsentComment c WHERE c.commentId = :commentId"),
    @NamedQuery(name = "ConsentComment.findByUserId", query = "SELECT c FROM ConsentComment c WHERE c.userId = :userId"),
    @NamedQuery(name = "ConsentComment.findByDateAdded", query = "SELECT c FROM ConsentComment c WHERE c.dateAdded = :dateAdded"),
    @NamedQuery(name = "ConsentComment.findByConsentType", query = "SELECT c FROM ConsentComment c WHERE c.consentType = :consentType")})
public class ConsentComment implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name = "consentCommentSequence", sequenceName = "CONSENT_COMMENT_SEQ", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "consentCommentSequence")
    @Basic(optional = false)
    @Column(name = "COMMENT_ID")
    private Long commentId;
    @Basic(optional = false)
    @Column(name = "USER_ID")
    private String userId;
    @Basic(optional = false)
    @Column(name = "DATE_ADDED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateAdded;
    @Basic(optional = false)
    @Lob
    @Column(name = "COMMENTS")
    private String comments;
    @Column(name = "CONSENT_ID")
    private Long consentId;
    @Basic(optional = false)
    @Column(name = "CONSENT_TYPE")
    private String consentType;
    @Column(name = "DELAYED_CONSENT_ID")
    private Long delayedConsentId;
    
    public ConsentComment() {
    }

    public ConsentComment(Long commentId) {
        this.commentId = commentId;
    }

    public ConsentComment(Long commentId, String userId, Date dateAdded, String comments, Long consentId, String consentType, Long delayedConsentId) {
        this.commentId = commentId;
        this.userId = userId;
        this.dateAdded = dateAdded;
        this.comments = comments;
        this.consentId = consentId;
        this.consentType = consentType;
        this.delayedConsentId = delayedConsentId;
    }

    public Long getCommentId() {
        return commentId;
    }

    public void setCommentId(Long commentId) {
        this.commentId = commentId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Date getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public String getComments() {
        return comments.replace("&#39;", "'");
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Long getConsentId() {
        return consentId;
    }

    public void setConsentId(Long consentId) {
        this.consentId = consentId;
    }

    public String getConsentType() {
        return consentType;
    }

    public void setConsentType(String consentType) {
        this.consentType = consentType;
    }
    
    public Long getDelayedConsentId() {
        return delayedConsentId;
    }

    public void setDelayedConsentId(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (commentId != null ? commentId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof ConsentComment)) {
            return false;
        }
        ConsentComment other = (ConsentComment) object;
        if ((this.commentId == null && other.commentId != null) || (this.commentId != null && !this.commentId.equals(other.commentId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return 
            "commentId=[" + commentId + "] " +
            "userId=[" + userId + "] " +
            "dateAdded=[" + dateAdded.toString() + "] " +
            "comments=[" + comments + "] " +
            "consentId=[" + consentId + "] " +
            "consentType=[" + consentType + "]";
    }
    
}
