package gov.va.nvap.web.consent.audit;

/**
 * @author Robert Snelling
 */
public final class AuditedConsentSummary {

	private String consentType;
	private Long count;
	private String facility;

	public AuditedConsentSummary(final String consentType,
			final String facility, final Long count) {
		this.setConsentType(consentType);
		this.setFacility(facility);
		this.setCount(count);
	}

	/**
	 * @return the actionType
	 */
	public String getConsentType() {
		return this.consentType;
	}

	/**
	 * @return the count
	 */
	public Long getCount() {
		return this.count;
	}

	/**
	 * @return the facility
	 */
	public String getFacility() {
		return this.facility;
	}

	/**
	 * @param actionType
	 *            the actionType to set
	 */
	public void setConsentType(final String consentType) {
		this.consentType = consentType;
	}

	/**
	 * @param count
	 *            the count to set
	 */
	public void setCount(final Long count) {
		this.count = count;
	}

	/**
	 * @param facility
	 *            the facility to set
	 */
	public void setFacility(final String facility) {
		this.facility = facility;
	}
}

