package gov.va.nvap.web.consent.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "CONSENT_AUDIT_EX")
public class AuditedConsentEx implements Serializable {

    private static final long serialVersionUID = 1L;
    
    @Id
    @Column(name = "CONSENT_AUDIT_ID")
    private Long consentAuditId;
    
    @Column(name = "ACTION_TYPE")
    private String actionType;
    
    @Column(name = "CONSENT_TYPE")
    private String consentType;
    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "CREATED_DATE")
    private Date createdDate;
    
    @Column(name = "FACILITY")
    private String facility;
    
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    
    @Column (name = "IS_TEST_PATIENT")
    private int isTestPatient;
    
    @Column(name = "OPTOUT_REASON")
    private String optoutReason;
    
    @Column(name = "PARENT_FACILITY_NAME")
    private String parentFacilityName;
    
    @Column(name = "PARENT_STATION_NUMBER")
    private String parentStationNumber;
    
    @Column(name = "PATIENT_GIVEN_NAME")
    private String patientGivenName;
    
    @Column(name = "PATIENT_ID")
    private String patientId;
    
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    
    @Column(name = "PATIENT_SSN")
    private String patientSsn;
    
    @Column(name = "POU_VALUE")
    private String pouValue;
    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "TIME_OF_EVENT")
    private Date timeOfEvent;
    
    @Column(name = "USER_ID")
    private String userId;
    
    @Column(name = "PATIENT_MIDDLE_NAME")
    private String patientMiddleName;
    
    @Column(name = "VISN_NAME")
    private String visnName;
    
    @Column(name = "VISN_NUMBER")
    private Long visnNumber;
    
    //getters and setters
    
    public Long getConsentAuditId() {
        return consentAuditId;
    }

    public void setConsentAuditId(Long consentAuditId) {
        this.consentAuditId = consentAuditId;
    }

    public String getActionType() {
        return actionType;
    }
    
    public void setActionType(String actionType) {
        this.actionType = actionType;
    }
    
    public String getConsentType() {
        return consentType;
    }
    
    public void setConsentType(String consentType) {
        this.consentType = consentType;
    }
    
    public Date getCreatedDate() {
        return createdDate;
    }
    
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }
    
    public String getFacility() {
        return facility;
    }
    
    public void setFacility(String facility) {
        this.facility = facility;
    }
    
    public String getFacilityName() {
        return facilityName;
    }
    
    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }
    
    public int getIsTestPatient() {
        return isTestPatient;
    }
    
    public void setIsTestPatient(int isTestPatient) {
        this.isTestPatient = isTestPatient;
    }
    
    public String getOptoutReason() {
        return optoutReason;
    }
    
    public void setOptoutReason(String optoutReason) {
        this.optoutReason = optoutReason;
    }
    
    public String getParentFacilityName() {
        return parentFacilityName;
    }
    
    public void setParentFacilityName(String parentFacilityName) {
        this.parentFacilityName = parentFacilityName;
    }
    
    public String getParentStationNumber() {
        return parentStationNumber;
    }
    
    public void setParentStationNumber(String parentStationNumber) {
        this.parentStationNumber = parentStationNumber;
    }
    
    public String getPatientGivenName() {
        return patientGivenName;
    }
    
    public void setPatientGivenName(String patientGivenName) {
        this.patientGivenName = patientGivenName;
    }
    
    public String getPatientId() {
        return patientId;
    }
    
    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }
    
    public String getPatientLastName() {
        return patientLastName;
    }
    
    public void setPatientLastName(String patientLastName) {
        this.patientLastName = patientLastName;
    }
    
    public String getPatientSsn() {
        return patientSsn;
    }
    
    public void setPatientSsn(String patientSsn) {
        this.patientSsn = patientSsn;
    }
    
    public String getPouValue() {
        return pouValue;
    }
    
    public void setPouValue(String pouValue) {
        this.pouValue = pouValue;
    }
    
    public Date getTimeOfEvent() {
        return timeOfEvent;
    }
    
    public void setTimeOfEvent(Date timeOfEvent) {
        this.timeOfEvent = timeOfEvent;
    }
    
    public String getUserId() {
        return userId;
    }
    
    public void setUserId(String userId) {
        this.userId = userId;
    }
    
    public String getPatientMiddleName() {
        return patientMiddleName;
    }
    
    public void setPatientMiddleName(String patientMiddleName) {
        this.patientMiddleName = patientMiddleName;
    }
    
    public String getVisnName() {
        return visnName;
    }
    
    public void setVisnName(String visnName) {
        this.visnName = visnName;
    }
    
    public Long getVisnNumber() {
        return visnNumber;
    }
    
    public void setVisnNumber(Long visnNumber) {
        this.visnNumber = visnNumber;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (consentAuditId != null ? consentAuditId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof AuditedConsentEx)) {
            return false;
        }
        AuditedConsentEx other = (AuditedConsentEx) object;
        if ((this.consentAuditId == null && other.consentAuditId != null) || (this.consentAuditId != null && !this.consentAuditId.equals(other.consentAuditId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.web.consent.audit.AuditedConsentXE[ consentAuditId=" + consentAuditId + " ]";
    }
    
}
