package gov.va.nvap.web.consent.audit;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * This is a separate entity class for the CONSENT_AUDIT to use the paginations
 * and the NON-XA driver.
 * 
 * @author Asha Amritraj
 */
@Entity
@Table(name = "CONSENT_AUDIT")
@NamedQueries({

		@NamedQuery(name = "ConsentAudit.findByPatientIdAndDate", query = "SELECT a FROM AuditedConsent a WHERE a.patientId = :patientId AND a.timeOfEvent BETWEEN :startDate AND :endDate order by a.createdDate desc"),
		@NamedQuery(name = "ConsentAudit.findByDate", query = "SELECT a FROM AuditedConsent a WHERE a.timeOfEvent BETWEEN :startDate AND :endDate order by a.createdDate desc"),
		@NamedQuery(name = "ConsentAudit.findAll", query = "SELECT a FROM AuditedConsent a order by a.createdDate desc"),
		@NamedQuery(name = "ConsentAudit.findByPatientId", query = "SELECT a FROM AuditedConsent a WHERE a.patientId = :patientId order by a.createdDate desc") })
public class AuditedConsent implements Serializable {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = -3582099211173270999L;
	@Column(name = "ACTION_TYPE")
	private String actionType;
	@Id
	@Basic(optional = false)
	@Column(name = "CONSENT_AUDIT_ID")
	@SequenceGenerator(name = "consentAuditSequence", sequenceName = "CONSENT_AUDIT_SEQ")
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "consentAuditSequence")
	private Long consentAuditId;
	@Column(name = "CONSENT_TYPE")
	private String consentType;
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	@Column(name = "FACILITY")
	private String facility;
	@Column(name = "FACILITY_NAME")
	private String facilityName;
	@Column(name = "OPTOUT_REASON", length = 4000)
	private String optoutReason;
	@Column(name = "POU_VALUE")
	private String pouValue;
	@Column(name = "PATIENT_GIVEN_NAME")
	private String patientGivenName;
	@Column(name = "PATIENT_ID")
	private String patientId;
	@Column(name = "PATIENT_LAST_NAME")
	private String patientLastName;
	@Column(name = "PATIENT_SSN")
	private String patientSsn;
	// @Column(name = "PATIENT_FACILITY")
	// private String patientFacility;
	@Column(name = "TIME_OF_EVENT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date timeOfEvent;
	@Column(name = "USER_ID")
	private String userId;
	@Column(name = "PATIENT_MIDDLE_NAME")
	private String patientMiddleName;
	
	public AuditedConsent() {
	}

	/**
	 * @return the actionType
	 */
	public String getActionType() {
		return this.actionType;
	}

	/**
	 * @return the consentAuditId
	 */
	public Long getConsentAuditId() {
		return this.consentAuditId;
	}

	public String getConsentType() {
		return this.consentType;
	}

	/**
	 * @return the createdDate
	 */
	public Date getCreatedDate() {
		return this.createdDate;
	}

	/**
	 * @return the facility
	 */
	public String getFacility() {
		return this.facility;
	}

	/**
	 * @return the facility name
	 */
	public String getFacilityName() {
		return this.facilityName;
	}
	
	/**
	 * @return the patientFacility
	 * 
	 *         public String getPatientFacility() { return this.patientFacility;
	 *         }
	 */

	/**
	 * @return the optoutReason
	 */
	public String getOptoutReason() {
		return this.optoutReason;
	}

	public String getPatientGivenName() {
		return this.patientGivenName;
	}

	/**
	 * @return the patientId
	 */
	public String getPatientId() {
		return this.patientId;
	}

	public String getPatientLastName() {
		return this.patientLastName;
	}

	public String getPatientSsn() {
		return this.patientSsn;
	}

	/**
	 * @return the timeOfEvent
	 */
	public Date getTimeOfEvent() {
		return this.timeOfEvent;
	}

	/**
	 * @return the userId
	 */
	public String getUserId() {
		return this.userId;
	}

	/**
	 * @param actionType
	 *            the actionType to set
	 */
	public void setActionType(final String actionType) {
		this.actionType = actionType;
	}

	/**
	 * @param consentAuditId
	 *            the consentAuditId to set
	 */
	public void setConsentAuditId(final Long consentAuditId) {
		this.consentAuditId = consentAuditId;
	}

	/**
	 * 
	 * @param consentType
	 *            the consentType to set
	 */
	public void setConsentType(final String consentType) {
		this.consentType = consentType;
	}

	/**
	 * @param patientFacility
	 *            the patientFacility to set
	 * 
	 *            public void setPatientFacility(final String patientFacility) {
	 *            this.patientFacility = patientFacility; }
	 */

	/**
	 * @param createdDate
	 *            the createdDate to set
	 */
	public void setCreatedDate(final Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * @param facility
	 *            the facility to set
	 */
	public void setFacility(final String facility) {
		this.facility = facility;
	}

	/**
	 * @param facility
	 *            the facility name to set
	 */
	public void setFacilityName(final String facilityName) {
		this.facilityName = facilityName;
	}
	
	/**
	 * @param optoutReason
	 *            the optoutReason to set
	 */
	public void setOptoutReason(final String optoutReason) {
		this.optoutReason = optoutReason;
	}

	public void setPatientGivenName(final String patientGivenName) {
		this.patientGivenName = patientGivenName;
	}

	/**
	 * @param patientId
	 *            the patientId to set
	 */
	public void setPatientId(final String patientId) {
		this.patientId = patientId;
	}

	public void setPatientLastName(final String patientLastName) {
		this.patientLastName = patientLastName;
	}

	public void setPatientSsn(final String patientSsn) {
		this.patientSsn = patientSsn;
	}

	/**
	 * @param timeOfEvent
	 *            the timeOfEvent to set
	 */
	public void setTimeOfEvent(final Date timeOfEvent) {
		this.timeOfEvent = timeOfEvent;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public void setUserId(final String userId) {
		this.userId = userId;
	}

	public void setPouValue(String pouValue) {
		this.pouValue = pouValue;
	}
	
	public String getPouValue() {
		return pouValue;
	}

	/**
	 * @return the patientMiddleName
	 */
	public String getPatientMiddleName() {
		return patientMiddleName;
	}

	/**
	 * @param patientMiddleName the patientMiddleName to set
	 */
	public void setPatientMiddleName(String patientMiddleName) {
		this.patientMiddleName = patientMiddleName;
	}
		
}
