package gov.va.nvap.web.consent.audit;

import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.Table;

/**
 * This is an entity class for the summary Opt-In Patients reports.
 * 
 * @author Irakli Kakushadze
 * @since 07/16/2016
 */
@Entity
@Table(name = "PATIENT_CONSENT_DIR")
@NamedNativeQueries({
    @NamedNativeQuery(
        name = "FacilityOptInConsent.activeConsentSummaryNativeSQL",
        query = ActiveConsentSummary.activeConsentSummaryNativeSQL,
        resultClass = ActiveConsentSummary.class
    )
})

public class ActiveConsentSummary implements Serializable {

//    public static final String activeConsentSummaryNativeSQL
//        = " select"
//        + "   row_number() over(order by lower(ca.FACILITY_NAME)) id,"
//        + "   ca.FACILITY_NAME as FACILITY_NAME,"
//        + "   p.OPTIN_CONSENT_TYPE_ID,"
//        + "   count(1) TOTAL,"
//        + "   sum(1 - ca.IS_TEST_PATIENT) COUNT_REAL"
//        + " from"
//        + "   PATIENT_CONSENT_DIR p,"
//        + "   CONSENT_TYPE ct,"
//        + "   CONSENT_AUDIT_EX ca"
//        + " where"
//        + "   p.OPTIN_CONSENT_TYPE_ID = ct.CONSENT_TYPE_ID"
//        + "   and p.PATIENT_IEN = ca.PATIENT_ID"
//        + "   and p.OPTOUT_TS is null"
//        + "   and p.OPTOUT_DATE is null"
//        + "   and (p.EXPIRATION_DATE > systimestamp)"
//        + "   and ca.ACTION_TYPE = 'OPT-IN'"
//        + "   and ca.TIME_OF_EVENT = ("
//        + "     select max(ica.TIME_OF_EVENT)"
//        + "     from CONSENT_AUDIT ica"
//        + "     where ica.PATIENT_ID = ca.PATIENT_ID and ica.CONSENT_TYPE = ct.NAME"
//        + "   )"
//        + "   /*facility_filter*/"
//        + " group by ca.FACILITY_NAME, p.OPTIN_CONSENT_TYPE_ID"
//        + " order by lower(ca.FACILITY_NAME)";

    public static final String activeConsentSummaryNativeSQL
        = "  select "
        + "    row_number() over(order by lower(ca.FACILITY_NAME)) id,"
        + "    ca.FACILITY_NAME as FACILITY_NAME,"
        + "    p.OPTIN_CONSENT_TYPE_ID,"
        + "    count(1) TOTAL,"
        + "    sum(1 - ca.IS_TEST_PATIENT) COUNT_REAL"
        + "  from ("
        + "    select OPTIN_CONSENT_TYPE_ID, PATIENT_IEN"
        + "    from PATIENT_CONSENT_DIR"
        + "    where OPTOUT_TS is null and"
        + "      OPTOUT_DATE is null and"
        + "      EXPIRATION_DATE > systimestamp"
        + "  ) p,"
        + "  ("
        + "    select a.CONSENT_AUDIT_ID, a.PATIENT_ID, a.CONSENT_TYPE"
        + "    from ("
        + "      select CONSENT_AUDIT_ID, PATIENT_ID, CONSENT_TYPE"
        + "      from CONSENT_AUDIT ca"
        + "      where"
        + "        (ca.CONSENT_TYPE = 'NwHIN Authorization' or ca.CONSENT_TYPE = 'SSA Authorization')"
        + "        and TIME_OF_EVENT = ("
        + "          select max(ica.TIME_OF_EVENT)"
        + "          from CONSENT_AUDIT ica"
        + "          where ica.PATIENT_ID = ca.PATIENT_ID and ica.CONSENT_TYPE = ca.CONSENT_TYPE"
        + "        )"
        + "    ) a"
        + "    group by a.CONSENT_AUDIT_ID, a.PATIENT_ID, a.CONSENT_TYPE"
        + "  ) g,"
        + "  CONSENT_AUDIT_EX ca"
        + "  where g.CONSENT_AUDIT_ID = ca.CONSENT_AUDIT_ID and"
        + "    g.PATIENT_ID = p.PATIENT_IEN and"
        + "    ((g.CONSENT_TYPE = 'NwHIN Authorization' and p.OPTIN_CONSENT_TYPE_ID = 100) or ((g.CONSENT_TYPE = 'SSA Authorization' and p.OPTIN_CONSENT_TYPE_ID = 102)))"
        + "    /*facility_filter*/"
        + "  group by ca.FACILITY_NAME, p.OPTIN_CONSENT_TYPE_ID"
        + "  order by lower(ca.FACILITY_NAME)";
    
    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "ID")
    private Long id;
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    @Basic(optional = false)
    @Column(name = "TOTAL")
    private Long total;
    @Basic(optional = false)
    @Column(name = "COUNT_REAL")
    private Long countReal;
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "OPTIN_CONSENT_TYPE_ID")
    private ConsentType optinConsentType;

    public ActiveConsentSummary() {
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (this.facilityName != null ? this.facilityName.hashCode() : 0);
        hash += (this.optinConsentType != null ? this.optinConsentType.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final ActiveConsentSummary other = (ActiveConsentSummary) obj;
        if (this.optinConsentType != other.optinConsentType && (this.optinConsentType == null || !this.optinConsentType.equals(other.optinConsentType))) {
            return false;
        }
        if ((this.facilityName == null) ? (other.facilityName != null) : !this.facilityName.equals(other.facilityName)) {
            return false;
        }
        return true;
    }

    public void setOptinConsentType(ConsentType optinConsentType) {
        this.optinConsentType = optinConsentType;
    }

    public ConsentType getOptinConsentType() {
        return optinConsentType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Long getCountReal() {
        return countReal;
    }

    public void getCountReal(Long countReal) {
        this.countReal = countReal;
    }

    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public Long getCountTest() {
        return total - countReal;
    }
    
}
