/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.web.auth;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.service.audit.AuditService;
import gov.va.nvap.service.audit.data.UserAccessAudit;
import gov.va.nvap.svc.consentmgmt.stub.dao.DescriptorDAO;
import gov.va.nvap.svc.consentmgmt.stub.data.Descriptor;
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.web.dao.UserRoleDAO;
import gov.va.nvap.web.helper.facility.FacilityHelper;
import gov.va.nvap.web.user.User;
import gov.va.nvap.web.user.role.UserNameException;
import gov.va.nvap.web.util.ValidatorMessage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import weblogic.servlet.security.ServletAuthentication;

/**
 * @author Asha Amritraj
 */
public class Login extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {
	static private final Log LOG = LogFactory.getLog(Login.class);

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 8573087737791718162L;

    private static final String VA_USERNAME = "adSamAccountName";

	@EJB(beanInterface = AuditService.class, mappedName = "AuditService")
	AuditService auditService;

    public void checkSession(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if (request.getSession(false) == null || !request.isRequestedSessionIdValid()) {
            response.getWriter().write("0");
        } else {
            response.getWriter().write("1");
        }
    }

	/**
	 * This is called when the Login button is pressed in the GUI.
	 */
	public void login(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		// Get the username and password from the web page.
		final String username = request.getParameter("username");
		final String password = request.getParameter("password");

		// Check the session if it is still valid
		//final HttpSession session = request.getSession(false);
		/*if (session != null) {
			session.invalidate();
		}*/
		// Call the apache commons validator to validate the fields in the page
		if (this.validate(request, response)) {
			// Call back for authentication
			final CallbackHandler callbackHandler = new CallbackHandler() {
				@Override
				public void handle(final Callback[] callbacks)
						throws IOException, UnsupportedCallbackException {
					for (final Callback cb : callbacks) {
						if (cb instanceof NameCallback) {
							((NameCallback) cb).setName(username);
						} else if (cb instanceof PasswordCallback) {
							((PasswordCallback) cb).setPassword(password
									.toCharArray());
						} else {
							throw new UnsupportedCallbackException(cb,
									"Callback is not supported.");
						}
					}
				}
			};
			// Authenticate
			if (ServletAuthentication.authenticate(callbackHandler, request) == 0) {
				if (Login.LOG.isInfoEnabled()) {
					//Login.LOG.info("VAP Login Success - user=" + username);
				}
				try {
					// Call VAP Audit to audit the login information
					this.auditService.auditUserAccess(new UserAccessAudit(
							username, "", new Date(), new Date()));
				} catch (final AuditException ex) {
					throw new RuntimeException(ex);
				}
				// Success
				loginSuccess(request, response);

			} else {
				if (Login.LOG.isInfoEnabled()) {
					//Login.LOG.info("VAP Login Failed - user=" + username);
				}
				// Error
				final ValidatorMessage message = new ValidatorMessage();
				// Set message to the formErrors for display in JSP
				message.setMessage("Invalid username and/or password was entered.");
				request.setAttribute("formErrors",
						new ValidatorMessage[] { message });
				// Error
				this.forward(request, response, "error");
			}
		} else {
			// Validate the page
			this.forward(request, response, "validate");
		}
	}

	@Override
	public void unspecified(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {

        // Check username header to see if username from SSOi is present
        if (!NullChecker.isNullOrEmpty(request.getHeader(VA_USERNAME))) {
            try {
                // Call VAP Audit to audit the login information
                this.auditService.auditUserAccess(new UserAccessAudit(
                        request.getHeader("adSamAccountName"), "", new Date(), new Date()));
            } catch (final AuditException ex) {
                throw new AuditException();
            }

            loginSuccess(request, response);
        } else {
            throw new UserNameException("UserNameException");
        }
	}

	/**
	 * Get the facility helper from Spring.
	 */
	public FacilityHelper getFacilityHelper() {
		final FacilityHelper facilityHelper = this.getBean("facilityHelper",
				FacilityHelper.class);
		return facilityHelper;
	}

    private DescriptorDAO getDescriptorDAO() {
        return this.getBean("DescriptorDAO", DescriptorDAO.class);
    }

    private UserRoleDAO getUserRoleDAO() {
        return this.getBean("UserRoleDAO", UserRoleDAO.class);
    }

    private void loginSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {

        // get User's default facility from cookie or from VHAUserId and set it for the session
        gov.va.nvap.svc.facility.data.Facility defaultUserFacility = null;
        Cookie[] vapCookies = request.getCookies();
        if (vapCookies != null){
            for (Cookie vapCookie : vapCookies){
                if (vapCookie.getName().equals("facility")){
                    if (NullChecker.isNotEmpty(vapCookie.getValue())) {
                        defaultUserFacility = new Facility();
                        try {
                            Facility facility = this.getFacilityHelper().getFacilityByStationId(vapCookie.getValue());
                            if (facility != null) {
                                defaultUserFacility.setFacilityStation(facility.getFacilityStation());
                                defaultUserFacility.setFacilityName(facility.getFacilityName());
                                defaultUserFacility.setVisnId(facility.getVisnId());
                            }
                        } catch (Exception e) {
                            // Cookie must contain an invalid station number. We'll ignore the error and set the default facility
                            // based on the user ID.
                        }
                    }
                }
            }
        }

        if (NullChecker.isEmpty(defaultUserFacility)) {
            // Get the Default Facility by user id
            defaultUserFacility = this.getFacilityHelper().getFacilityStationByVHAUserId(
                        request.getHeader(VA_USERNAME));
        }

        final HttpSession session = request.getSession(true);

        if (NullChecker.isNotEmpty(defaultUserFacility)) {
            session.setAttribute("defaultUserFacility",	defaultUserFacility);
        }

        //valid user now, so valid session. add the tool tips (descriptors) to this session for use in many views
        List<Descriptor> dees = this.getDescriptorDAO().getAll();
        HashMap hm = new HashMap();

        for(Descriptor d : dees) {
            hm.put(d.getName(), d.getText());
        }

        session.setAttribute("descriptors", hm);

        // Create user with roles for redirect
        User user = new User(this.getUserRoleDAO().findUserRoleNames(request.getHeader(VA_USERNAME).toLowerCase()));
        session.setAttribute("user", user);

        if (user.hasRole("VAPApplicationWebUser")) {
            this.forward(request, response, "success");
        } else {
            this.forward(request, response, "successReport");
        }
    }
}
