package gov.va.nvap.web.app;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Web application lifecycle listener.
 *
 * @author David Vazquez Modified by: Asha Amritraj
 */
public class AppStateListener implements ServletContextListener {

    static private Log LOG = LogFactory.getLog(AppStateListener.class);

    @Override
    public void contextDestroyed(final ServletContextEvent sce) {
        if (AppStateListener.LOG.isInfoEnabled()) {
            AppStateListener.LOG.info("VAP stopped.");
        }
    }

    @Override
    public void contextInitialized(final ServletContextEvent sce) {
        // Get the version from the MANIFEST.MF file
        try {
            InputStream in = sce.getServletContext().getResourceAsStream("META-INF/MANIFEST.MF");
            in = sce.getServletContext().getResourceAsStream("META-INF/MANIFEST.MF");
            
            if(in!=null){
                in.close();
			}

            final String version = this.getValueFromManifest(in, "Build-VAP");
            // Put the build and version into the context
            sce.getServletContext().setAttribute("version", version);
            if (AppStateListener.LOG.isInfoEnabled()) {
                AppStateListener.LOG.info("VAP (" + version + ") started.");
            }

            Properties properties = new Properties();
        
            properties.load(sce.getServletContext().getResourceAsStream("/WEB-INF/static.properties"));
            sce.getServletContext().setAttribute("systemVersion", properties.getProperty("system.version"));
            sce.getServletContext().setAttribute("organizationName", properties.getProperty("exchange.organizationName"));
            sce.getServletContext().setAttribute("scheduledExportMin", properties.getProperty("scheduled.export.min"));
        } catch (IOException ex) {
            Logger.getLogger(AppStateListener.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Get the value from the MANIFEST File
     */
    private String getValueFromManifest(final InputStream in,
        final String header) {
        String ret = null;
        final LineNumberReader reader = new LineNumberReader(
            new InputStreamReader(in));

        try {
            String line = reader.readLine();
            while ((ret == null) && (line != null)) {
                if (line.startsWith(header)) {
                    ret = line.substring(line.indexOf(":") + 1).trim();
                }
                line = reader.readLine();
            }
        } catch (final IOException ie) {
            ret = null;
        }

        return ret;
    }
}