/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.announce;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncerInterface;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.util.Paginator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 *
 * @author Tim Vu / Asha Amritraj
 *
 */
public class BatchManagerResults extends ResponseDispatcherHttpServlet {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = -6423079359688193531L;

	@EJB(beanInterface = AnnouncerInterface.class, mappedName = "AnnouncerService")
	private AnnouncerInterface announcer;

	/**
	 * Delete records from the batch.
	 */
	public void delete(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final String[] batchIds = request.getParameterValues("batchId");

		if ((null != batchIds) && (batchIds.length > 0)) {
			final List<String> notNullBatchIds = new ArrayList<String>();

			for (final String batchId : batchIds) {
				if (NullChecker.isNotEmpty(batchId)) {
					notNullBatchIds.add(batchId);
				}
			}
			this.announcer.removeAnnouncementBatches(notNullBatchIds);
		}
		// Do the search again
		this.unspecified(request, response);
	}

	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}

	/**
	 * Get the results from the Announcer bean.
	 */
	public List<Map<String, Object>> getResults(
			final HttpServletRequest request, final Paginator paginator) {
		final HttpSession session = request.getSession(false);
		final Date sd = (Date) session
				.getAttribute("batchManagerQueryStartDate");
		final Date ed = (Date) session.getAttribute("batchManagerQueryEndDate");
		final String orgOid = (String) session
				.getAttribute("batchManagerQueryRemoteOrganization");

		// Get the list of AnnouncementBatchSummary by date range. Start/End
		// date can be empty.
		final List<AnnouncementBatchSummary> summaryList = this.announcer
				.retrieveBatchSummaries(sd, ed, orgOid,
						UserHelper.getUserName(request), paginator.getCurrentPage()
								* paginator.getRecordsPerPage(),
						paginator.getRecordsPerPage());

		final List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
		// Put it in a map to prevent hibernate thread issues
		for (final AnnouncementBatchSummary summary : summaryList) {
			final Map<String, Object> map = new HashMap<String, Object>();
			map.put("batchId", summary.getBatchId());
			map.put("batchSize", summary.getBatchSize());
			map.put("createdDate", summary.getCreatedDate());
			map.put("numberCompleted", summary.getNumberCompleted());
			map.put("numberScheduled", summary.getNumberScheduled());
			map.put("targetOrganizationName",
					summary.getTargetOrganizationName());
			resultList.add(map);
		}
		return resultList;
	}

	private boolean isPaginatorPresent(final HttpSession session) {
		return !NullChecker.isNullOrEmpty(session.getAttribute("paginator"));
	}

	public void next(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		if (this.isPaginatorPresent(session)) {
			final Paginator paginator = (Paginator) session
					.getAttribute("paginator");
			paginator.next(request);
			session.setAttribute("paginator", paginator);
			session.setAttribute("batchManagerResults",
					this.getResults(request, paginator));
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

	public void prev(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		final HttpSession session = request.getSession(false);
		if (this.isPaginatorPresent(session)) {
			final Paginator paginator = (Paginator) session
					.getAttribute("paginator");
			paginator.previous(request);
			session.setAttribute("paginator", paginator);
			session.setAttribute("batchManagerResults",
					this.getResults(request, paginator));
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

	/**
	 * Delete records from the batch.
	 */
	public void refresh(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		// Do the search again
		this.unspecified(request, response);
	}

	@Override
	protected void unspecified(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {

		final HttpSession session = request.getSession(false);
		if (this.isPaginatorPresent(session)) {
			Paginator paginator = (Paginator) session.getAttribute("paginator");
			if (NullChecker.isEmpty(paginator)) {
				paginator = new Paginator(0);
				session.setAttribute("paginator", paginator);
			}
			paginator.reset();
			final List<Map<String, Object>> summaryList = this.getResults(
					request, paginator);
			session.setAttribute("batchManagerResults", summaryList);
			this.forward(request, response, "show");
		} else {
			this.forward(request, response, "noshow");
		}
	}

}
