package gov.va.nvap.web.announce;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncerInterface;
import gov.va.nvap.web.app.ResponseDispatcherHttpServlet;
import gov.va.nvap.web.dao.OrganizationDAO;
import gov.va.nvap.web.helper.privacy.ConsentManagementHelper;
import static gov.va.nvap.web.report.ReportDataProcessor.maskSsn;
import gov.va.nvap.web.user.UserHelper;

import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Tim Vu / Asha Amritraj
 */
public class BatchManagerQuery extends ResponseDispatcherHttpServlet {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 8860158686782275698L;

	public ConsentManagementHelper getCmsHelper() {
		final ConsentManagementHelper cmsHelper = this.getBean("cmsHelper",
				ConsentManagementHelper.class);
		return cmsHelper;
	}

    private OrganizationDAO getOrganizationDAO() {
        return this.getBean("OrganizationDAO", OrganizationDAO.class);
    }

    /*public AnnouncerInterface getAnnouncer() {
        final AnnouncerInterface announcer = this.getBean("AnnouncerService", AnnouncerInterface.class);
        return announcer;
    }*/

    @EJB(beanInterface = AnnouncerInterface.class, mappedName = "AnnouncerService")
	private AnnouncerInterface announcer;

    @Override
	protected void unspecified(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,IOException {
		final HttpSession session = request.getSession(false);

        request.setAttribute("organizations", this.getCmsHelper().getAllowedNonConsumerOnlyOrganizations());

        this.forward(request, response, "searchForm");
    }

    public void doSearch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParseException
    {
        final HttpSession session = request.getSession(false);
        String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String remoteOrg = request.getParameter("remoteOrganization");
        final String draw = request.getParameter("draw");
        final String maxRows = request.getParameter("length");
        final String startRow = request.getParameter("start");
        Date sd = null;
        Date ed = null;

        SimpleDateFormat sdFormatter = new SimpleDateFormat("MM/dd/yyyy");
        SimpleDateFormat edFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

        if(!NullChecker.isNullOrEmpty(startDate)) {
            sd = sdFormatter.parse(startDate);
        }
        if(!NullChecker.isNullOrEmpty(endDate)) {
            ed = edFormatter.parse(endDate + " 23:59:59");
        }

        final List<AnnouncementBatchSummary> summaryList = this.announcer.retrieveBatchSummaries(sd, ed, remoteOrg, UserHelper.getUserName(request), Integer.parseInt(startRow), Integer.parseInt(maxRows)); //get the results
        final List<AnnouncementBatchSummary> summaryCount = this.announcer.retrieveBatchSummaries(sd, ed, remoteOrg, UserHelper.getUserName(request), -1,-1); //get the total count

        HashMap hm = new HashMap();
        hm.put("results", summaryList);
        hm.put("count", summaryCount.size());
        hm.put("draw", draw);

        //create JSON here...
        session.setAttribute("results", encodeIntoJSON(hm));
        this.forward(request, response, "searchResultsJSON");
    }

    private String encodeIntoJSON(HashMap results) throws ParseException
    {
        try{
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List<AnnouncementBatchSummary> summaries = (List<AnnouncementBatchSummary>) results.get("results");
            Integer count = (Integer) results.get("count");
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.S");
            SimpleDateFormat finalDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
            Integer draw = Integer.parseInt( (String) results.get("draw"));

            obj.put("draw", draw);
            obj.put("recordsTotal", count);
            obj.put("recordsFiltered", count);

            List<List> data = new ArrayList<List>();

            for(AnnouncementBatchSummary s : summaries) {
                List<String> dataItem = new ArrayList<String>(); //each "row"
                String createdDate = "";

                if(s.getCreatedDate() != null) {
                    Date date = dt.parse(s.getCreatedDate().toString());
                    createdDate = finalDateFormat.format(date);
                }

                dataItem.add("<input type='checkbox' name='batchId' role='group' aria-labelledby='master' class='chk' value='" + s.getBatchId() +"' title='Check to choose Organization' />");
                dataItem.add(s.getTargetOrganizationName());
                dataItem.add(createdDate);
                dataItem.add(s.getNumberScheduled().toString());
                dataItem.add(s.getNumberCompleted().toString());
                dataItem.add(s.getBatchSize().toString());
                dataItem.add("<input type='button' name='" + dataItem.hashCode() + "' id='" + dataItem.hashCode() + "' data-org-id='" + s.getOrgId() + "' data-batch-id='" + s.getBatchId() + "' class='batchDetail' title='View Details' value='View Details' />");

                data.add(dataItem);
            }

            obj.put("data", data);

            obj.write(json);

            return json.toString();
        } catch(JSONException ex) {
            Logger.getLogger(BatchManagerQuery.class.getName()).log(Level.SEVERE, null, ex);
        }

        return "";
    }

    private String encodeBatchDetailsIntoJSON(HashMap results) throws ParseException {
        try{
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List<Announcement> announcements = (List<Announcement>) results.get("results");
            Long count = (Long) results.get("count");

            Integer draw = Integer.parseInt( (String) results.get("draw"));

            obj.put("draw", draw);
            obj.put("recordsTotal", count);
            obj.put("recordsFiltered", count);

            List<List> data = new ArrayList<List>(); //overarching "data"

            for(Announcement a : announcements) {
                List<String> dataItem = new ArrayList<String>(); //each "row"

                dataItem.add(a.getPatientIen());
                dataItem.add(maskSsn(a.getSsn()));
                dataItem.add(a.getLastName());
                dataItem.add(a.getFirstName());

                data.add(dataItem);
            }

            obj.put("data", data);

            obj.write(json);

            return json.toString();
        } catch(JSONException ex) {
            Logger.getLogger(BatchManagerQuery.class.getName()).log(Level.SEVERE, null, ex);
        }

        return "";
    }

    /**
	 * Delete records from the batch.
	 */
	public void delete(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
		final String[] batchIds = request.getParameterValues("batchId");

		if ((null != batchIds) && (batchIds.length > 0)) {
			final List<String> notNullBatchIds = new ArrayList<String>();

			for (final String batchId : batchIds) {
				if (NullChecker.isNotEmpty(batchId)) {
					notNullBatchIds.add(batchId);
				}
			}
			this.announcer.removeAnnouncementBatches(notNullBatchIds);
		}
		// Do the search again
		this.unspecified(request, response);
	}

    public void getDetailView(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final HttpSession session = request.getSession(false);

        List<String> batchIds = new ArrayList();
        batchIds.add(request.getParameter("batchId"));
        List<AnnouncementBatchSummary> a = this.announcer.getBatchSummary(batchIds);
        String orgId = request.getParameter("orgId");
        String announcedToOrg = this.getOrganizationDAO().getOrganization(Long.parseLong(orgId)).getOrgName();

        session.setAttribute("announcedDate", a.get(0).getCreatedDate());
        session.setAttribute("announcedToOrg", announcedToOrg);
        session.setAttribute("batchId", request.getParameter("batchId"));
        session.setAttribute("orgId", request.getParameter("orgId"));

        this.forward(request, response, "getDetailView");
    }

    public void getDetail(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException, ParseException {
        final HttpSession session = request.getSession(false);
        String batchId = request.getParameter("batchId");
        String orgId = request.getParameter("orgId");
        final String draw = request.getParameter("draw");
        final String maxRows = request.getParameter("length");
        final String startRow = request.getParameter("start");

        HashMap hm =  this.announcer.getAnnouncementsByBatchIdWithPaging(batchId, orgId, Integer.parseInt(startRow), Integer.parseInt(maxRows));

        hm.put("results", hm.get("results"));
        hm.put("count", hm.get("count"));
        hm.put("draw", draw);

        session.setAttribute("results", encodeBatchDetailsIntoJSON(hm));

        this.forward(request, response, "searchResultsJSON");
    }
}
