/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.admin.reports;

import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuditDAO;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Johann Sonnenberg
 */
public class ServiceAuditReport extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet
{
    
    //@EJB(beanInterface = ServiceAuditDAO.class, mappedName = "ServiceAuditDAO")
    //ServiceAuditDAO serviceAuditDAO;
    
    public ServiceAuditDAO getServiceAuditDAO()
    {
        return this.getBean("ServiceAuditDAO", ServiceAuditDAO.class);
    }
    
    public void getCallsByWebService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
    {
        // call done via ajax to get the distinct calls (methods) by a web service. 
        
        final HttpSession session = request.getSession(false);
        
        final String webservice = request.getParameter("webservice");
        
        List<String> calls = this.getServiceAuditDAO().findDistinctCallsByWebService(webservice);
        
        session.setAttribute("calls", calls);
        
        this.forward(request, response, "getCallsByWebService");
    }
    
    public void doSearch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParseException 
    {
        final HttpSession session = request.getSession(false);
        
        //get parameters from the url
        final String webservice = request.getParameter("webservice");
        final String method = request.getParameter("method");
        final String authorized = request.getParameter("authorized");
        final String success = request.getParameter("success");
        final String duration = request.getParameter("duration");
        final String startDate = request.getParameter("startDate");
        final String endDate = request.getParameter("endDate");
        final String maxRows = request.getParameter("length");
        final String startRow = request.getParameter("start");
        final String useJSON = request.getParameter("useJSON");
        final String draw = request.getParameter("draw");
        final String sortBy = request.getParameter("order[0][column]");
        final String sortOrder = request.getParameter("order[0][dir]");
        
        //do the actual search
        HashMap hm = this.getServiceAuditDAO().getServiceAuditByWebServiceAndCall(webservice, method, authorized, success, duration, startDate, endDate, Integer.parseInt(maxRows), Integer.parseInt(startRow), sortBy, sortOrder);
        hm.put("draw", draw);
        
        session.setAttribute("webservice", webservice);
        session.setAttribute("method", method);
        
        //create JSON here...
        session.setAttribute("results", encodeServiceAuditIntoJSON(hm));
        this.forward(request, response, "searchResultsJSON");
    }
    
    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
    {
        //this is the search form
        
        //get information for dropdowns
        List<String> webservices = this.getServiceAuditDAO().findDistinctWebServices();
        
        final HttpSession session = request.getSession(false);
		session.setAttribute("webservices", webservices);
        
        this.forward(request, response, "searchForm");
    }   
    
    private String encodeServiceAuditIntoJSON(HashMap results) throws ParseException 
    {
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            Long count = (Long) results.get("count");
            List<ServiceAudit> serviceAudits = (List<ServiceAudit>) results.get("results");
            Integer draw = Integer.parseInt( (String) results.get("draw"));
            
            obj.put("draw", draw);
            obj.put("recordsTotal", count);
            obj.put("recordsFiltered", count);
            
            List<List> data = new ArrayList<List>(); //overarching "data"
            
            for (ServiceAudit sa : serviceAudits) {
                List<String> dataItem = new ArrayList<String>(); //each "row"
                dataItem.add(sa.getWebService());
                dataItem.add(sa.getCall());
                
                SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.S");
                Date date = dt.parse(sa.getEventDate().toString());
                SimpleDateFormat finalDate = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
                
                dataItem.add(finalDate.format(date));
                dataItem.add(sa.getIp());
                dataItem.add(sa.getCN());
                dataItem.add(sa.getAuthorized() ? "Yes" : "No");
                dataItem.add(sa.getSuccess() == null ? "Not Audited" : sa.getSuccess() == 1 ? "Yes" : "No");
                dataItem.add(sa.getDuration() == null ? "Not Audited" : sa.getDuration().toString());
                
                data.add(dataItem);
            }
            
            obj.put("data", data);
            
            obj.write(json);
            
            return json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(ServiceAuditReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return "";
    }
}