package gov.va.nvap.web.admin.organization;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import gov.va.nvap.web.dao.OrganizationDAO;
import gov.va.nvap.web.util.xls.ExcelExporter;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Johann Sonnenberg
 */
public class OrganizationHandler extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    private OrganizationDAO getOrganizationDAO() {
        return this.getBean("OrganizationDAO", OrganizationDAO.class);
    }

    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        //this is the list page
        this.forward(request, response, "list");
    }

    /* DEPRECATED PER VAP-328
    public void add(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.forward(request, response, "add");
    }*/

    public void edit(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(false);

        final String orgId = request.getParameter("id");

        Organization o = this.getOrganizationDAO().getOrganization(Long.valueOf(orgId));

        session.setAttribute("organization", o);

        this.forward(request, response, "edit");
    }

    public void getAll(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParseException {
        final HttpSession session = request.getSession(false);

        final String maxRows = request.getParameter("length");
        final String startRow = request.getParameter("start");
        final String draw = request.getParameter("draw");
        final String sortBy = request.getParameter("order[0][column]");
        String sortOrder;
        if (!NullChecker.isNullOrEmpty(request.getParameter("order[0][dir]")) && request.getParameter("order[0][dir]").equals("desc")) {
            sortOrder = "desc";
        } else {
            sortOrder = "asc";
        }

        //get all the organizations
        HashMap hm = this.getOrganizationDAO().listAllOrganizations(Integer.parseInt(maxRows), Integer.parseInt(startRow), sortBy, sortOrder);
        hm.put("draw", draw);

        //encode it all into JSON
        session.setAttribute("results", encodeIntoJSON(hm));
        this.forward(request, response, "resultsJSON");
    }

    /* DEPRECATED PER VAP-328
    public void addComplete(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organization o = new Organization();

        final String[] trustedSources = request.getParameterValues("isTrustedClinicalSource");
        final char trustedSource = null != trustedSources && trustedSources.length > 0 ? 'Y' : 'N'; //we only have one trusted source flag. basically if its checked we want Y(es) otherwise N(o)
        final String[] consumers = request.getParameterValues("orgConsumerOnly");
        final char consumerOnly = null != consumers && consumers.length > 0 ? 'Y' : 'N';

        //load up the object 
        o.setOrgName(request.getParameter("orgName"));
        o.setOrgPhoneNumber(request.getParameter("orgPhone"));
        o.setOrgCommunityIdPrefix(request.getParameter("orgPrefix"));
        o.setOrgContact(request.getParameter("orgContact"));
        o.setOrgDomain(request.getParameter("orgDomain"));
        o.setOrgNumber(request.getParameter("orgNumber"));
        o.setOrgOid(request.getParameter("orgOid"));
        o.setOrgConsumerOnly(consumerOnly);
        o.setActive('Y'); //this is add so obviously we want this new one to be active (or else why are we adding it?)
        o.setIsTrustedClinicalSource(trustedSource);

        //save it
        this.getOrganizationDAO().create(o);

        //set the message to show on the list page
        request.setAttribute("message", "Partner Organization saved successfully.");

        this.forward(request, response, "list");
    } */

    public void editComplete(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organization o = this.getOrganizationDAO().getOrganization(Long.valueOf(request.getParameter("orgId")));

        final String[] trustedSources = request.getParameterValues("isTrustedClinicalSource");
        final char trustedSource = null != trustedSources && trustedSources.length > 0 ? 'Y' : 'N'; //we only have one trusted source flag. basically if its checked we want Y(es) otherwise N(o)

        o.setOrgName(request.getParameter("orgName"));
        o.setOrgNumber(request.getParameter("orgNumber"));
        o.setOrgContact(request.getParameter("orgContact"));
        o.setOrgPhoneNumber(request.getParameter("orgPhone"));
        o.setIsTrustedClinicalSource(trustedSource);
        
        //save it
        this.getOrganizationDAO().update(o);

        //set the message to show on the list page
        request.setAttribute("message", "Partner Organization saved successfully.");

        this.forward(request, response, "list");
    }

    public void exportToExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //get all the organizations
        final String sortBy = request.getParameter("sortBy");
        String sortOrder;
        if (!NullChecker.isNullOrEmpty(request.getParameter("sortOrder")) && request.getParameter("sortOrder").equals("desc")) {
            sortOrder = "desc";
        } else {
            sortOrder = "asc";
        }
        HashMap hm = this.getOrganizationDAO().listAllOrganizations(-1, 0, sortBy, sortOrder);

        final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();

        final ArrayList<Organization> orgs = (ArrayList<Organization>) hm.get("results");

        //loop over all of the organizations and put them in a form the Excel Exporter likes
        for (Organization org : orgs) {
            final Map<String, Object> resultMap = new HashMap<String, Object>();

            resultMap.put("active", org.getActive() == 'Y' ? "Yes" : "No");
            resultMap.put("phone", org.getOorgPhoneNumber());
            resultMap.put("prefix", org.getOrgCommunityIdPrefix());
            resultMap.put("consumer", org.getOrgConsumerOnly() == 'Y' ? "Yes" : "No");
            resultMap.put("contact", org.getOrgContact());
            resultMap.put("domain", org.getOrgDomain());
            resultMap.put("name", org.getOrgName());
            resultMap.put("number", org.getOrgNumber());
            resultMap.put("organizationId", org.getOrgOid());
            resultMap.put("trustedSource", org.getIsTrustedClinicalSource() == 'Y' ? "Yes" : "No");

            results.add(resultMap);
        }

        //options for workbook
        String header = "Partner Organizations";
        final Map<String, String> reportMap = new LinkedHashMap<String, String>();

        // Set the heading parameters 
        final Map<String, List<Object>> headingParameters = new LinkedHashMap<String, List<Object>>();

        //put together the reportMap
        if (NullChecker.isNullOrEmpty(results)) {
            reportMap.put("", "No records were found.");
        } else {
            reportMap.put("active", "Active");
            reportMap.put("phone", "Phone");
            reportMap.put("prefix", "Prefix");
            reportMap.put("consumer", "Consumer Only");
            reportMap.put("contact", "Contact");
            reportMap.put("domain", "Domain");
            reportMap.put("name", "Name");
            reportMap.put("number", "Number");
            reportMap.put("organizationId", "Organization ID");
            reportMap.put("trustedSource", "Trusted Clinical Source");
        }

        //create workbook
        final Workbook wb = this.getExcelExporter().exportToExcel(header, header, reportMap, results, headingParameters, null);

        //write Excel to Stream
        this.getExcelExporter().writeExcelToStream("Partner_Organizations", wb, response);
    }

    /**
     * Get the excel exporter class from Spring.
     */
    private ExcelExporter getExcelExporter() {
        final ExcelExporter excelExporter = this.getBean("excelExporter",
            ExcelExporter.class);
        return excelExporter;
    }

    private String encodeIntoJSON(HashMap results) throws ParseException {
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            Long count = (Long) results.get("count");
            List<Organization> orgs = (List<Organization>) results.get("results");
            Integer draw = Integer.parseInt((String) results.get("draw"));

            obj.put("draw", draw);
            obj.put("recordsTotal", count);
            obj.put("recordsFiltered", count);

            List<List> data = new ArrayList<List>(); //overarching "data"

            for (Organization o : orgs) {
                List<String> dataItem = new ArrayList<String>(); //each "row"

                dataItem.add(o.getActive() == 'Y' ? "Yes" : "No");
                dataItem.add(o.getOorgPhoneNumber());
                dataItem.add(o.getOrgCommunityIdPrefix());
                dataItem.add(o.getOrgConsumerOnly() == 'Y' ? "Yes" : "No");
                dataItem.add(o.getOrgContact());
                dataItem.add(o.getOrgDomain());
                dataItem.add(o.getOrgName());
                dataItem.add(o.getOrgNumber());
                dataItem.add(o.getOrgOid());
                dataItem.add(o.getIsTrustedClinicalSource() == 'Y' ? "Yes" : "No");
                dataItem.add("<a href='OrganizationHandler.do_sec?edit=true&id=" + o.getOrgId().toString() + "'><button title='Edit Partner Organization'>Edit</button></a>");

                data.add(dataItem);
            }

            obj.put("data", data);

            obj.write(json);

            return json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(Organization.class.getName()).log(Level.SEVERE, null, ex);
        }

        return "";
    }
}
