package gov.va.nvap.notification.jmsutilities;

/**
 * This is the motivating event type for all VAP produced JMS messages.
 */
public enum VapTriggerEvent {
	
	/**
	 * This is a VAP opt in event.
	 */
	PATIENT_NEW_AUTH, 
	
	/**
	 * This is a VAP opt out event.
	 */
	PATIENT_REVOKE_AUTH,

	/**
	 * This is a VAP patient consent restriction.  (Currently unimplemented).
	 */
	PATIENT_RESTRICT_AUTH,
	
	/**
	 * This signifies that the consent directive will expire soon.
	 */
	PATIENT_AUTH_ABOUT_TO_EXPIRE,
	
	/**
	 * This is a VAP expiration (of the consent directive(s))event.
	 */
	PATIENT_AUTH_EXPIRED;
	
	public static void main (String[] args) {
		VapTriggerEvent p = VapTriggerEvent.PATIENT_AUTH_ABOUT_TO_EXPIRE;
		System.out.println(p.toString());
		Boolean b = p.equals(Enum.valueOf(VapTriggerEvent.class,p.toString()));
		System.out.println(b);
		b = p.equals(VapTriggerEvent.valueOf(p.toString()));
		System.out.println(b);
		VapTriggerEvent.valueOf("bob");
	}
}
