package gov.va.nvap.notification.jmsutilities;

import gov.va.nvap.notification.interfaces.VapPublisher;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.jms.core.JmsTemplate;


public class VapJMSPublisher implements VapPublisher {

	protected JmsTemplate jmsTemplate;
	protected Set<String> pubIdentifiers = new HashSet<String>();
	protected Set<String> subIdentifiers = new HashSet<String>();
	String identifierKey = "identifiers"; // inject with spring if
													// desired
	String objectKey = "object";// inject with spring if desired
	String xmlKey = "xml";// inject with spring if desired
	String trigger = "trigger";// inject with spring if desired
	
	//private static final Log LOG = LogFactory.getLog(VapJMSPublisher.class);


	public void setPubMessageIdentifiers(Set<String> identifier) {
		this.pubIdentifiers = identifier;
	}

	@Required
	public void setJmsTemplate(final JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

	public void setIdentifierKey(String identifierKey) {
		this.identifierKey = identifierKey;
	}

	public void setObjectKey(String objectKey) {
		this.objectKey = objectKey;
	}

	public void setXmlKey(String xmlKey) {
		this.xmlKey = xmlKey;
	}
	
	public void setTrigger(String trigger) {
		this.trigger = trigger;
	}
	
	private void publishObject(Serializable message, Map<String,Object> props) {
		jmsTemplate.send(new VapJMSMessageCreator(this, message, pubIdentifiers, props));
	}
	
	private void publishXML(String xml, Map<String,Object> props) {
		jmsTemplate.send(new VapJMSMessageCreator(this, xml, pubIdentifiers,props));
	}

	@Override
	public void publishObject(VapTriggerEvent trigger, Serializable message) {
		publishObject(message,eventToProps(trigger));
	}

	@Override
	public void publishXML(VapTriggerEvent trigger, String xml) {
		publishXML(xml,eventToProps(trigger));
	}

	@Override
	public void publishObject(VapTriggerEvent trigger, Serializable message,
			Map<String, Object> props) {
		props = new HashMap<String,Object>(props);
		props.putAll(eventToProps(trigger));
		publishObject(message,props);
	}

	@Override
	public void publishXML(VapTriggerEvent trigger, String xml,
			Map<String, Object> props) {
		props = new HashMap<String,Object>(props);
		props.putAll(eventToProps(trigger));
		publishXML(xml,props);
		
	}
	
	private Map<String,Object> eventToProps(VapTriggerEvent trigger) {
		Map<String,Object> m = new HashMap<String,Object>();
		m.put(this.trigger,trigger.toString());
		return m;
	}
}
