package gov.va.nvap.notification.jmsutilities;

import java.util.List;
import java.util.Observable;
import java.util.Observer;

import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;

public class GeneralMDB extends Observable implements MessageListener {

	@Override
	public void onMessage(Message message) {

		if (message instanceof MapMessage) {
			notifyObservers(message);
		}
	}

	@Override
	public void notifyObservers(Object jmsMessage) {
		setChanged();
		super.notifyObservers(jmsMessage);
	}

	public void setObservers(List<Observer> observerList) {
		for (Observer obs : observerList) {
			this.addObserver(obs);
		}
	}

}
