package gov.va.nvap.notification.interfaces;

import gov.va.nvap.notification.jmsutilities.VapTriggerEvent;

import java.io.Serializable;
import java.util.Map;

/**
 * A VapPublisher is used for publishing VAP events to a javax.jms.Destination.
 *
 */
public interface VapPublisher {

	
	/**
	 * Publishes a Serializable Object to a destination.
	 * This method is intended for for cases where the consumer is internal to VAP.
	 * @param trigger the trigger that motivated this message.
	 * @param message a Serializable message
	 */
	public void publishObject(VapTriggerEvent trigger, Serializable message); 

	/**
	 * Publishes a String (likely XML) to a destination. 
	 * This method is intended for for cases where the consumer is external to VAP.
	 * @param trigger the trigger that motivated this message.
	 * @param xml an XML message
	 */
	public void publishXML(VapTriggerEvent trigger, String xml);
	
	/**
	 * Publishes a Serializable Object to a destination.
	 * This method is intended for for cases where the consumer is internal to VAP.
	 * @param trigger the trigger that motivated this message.
	 * @param message a Serializable message
	 * @param props a set of properties that will be placed into the message as actual message properties.
	 * For example, suppose you wish to give consumers of this message the ability to only receive the message if the veteran
	 * is over 40, you might put in a map that has the key "age", with a Short that is the vet's age.
	 */
	public void publishObject(VapTriggerEvent trigger, Serializable message, Map<String,Object> props);

	/**
	 * Publishes a Serializable Object to a destination.
	 * This method is intended for for cases where the consumer is external to VAP.
	 * @param trigger the trigger that motivated this message.
	 * @param message an XML message
	 * @param props a set of properties that will be placed into the message as actual message properties.
	 * For example, suppose you wish to give consumers of this message the ability to only receive the message if the veteran
	 * is over 40, you might put in a map that has the key "age", with a Short that is the vet's age.
	 */
	public void publishXML(VapTriggerEvent trigger, String xml, Map<String,Object> props);
	
}
