/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.facility.test;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityService;
import gov.va.nvap.svc.facility.impl.FacilityServiceImpl;
import gov.va.nvap.svc.facility.jpa.impl.FacilityJpaController;
import gov.va.nvap.svc.facility.jpa.impl.LocationJpaController;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import junit.framework.Assert;
import org.junit.After;

import org.junit.Before;
import org.junit.Test;
/**
 *
 * @author Anand Sastry
 */
public class FacilityImplTest {

    private static EntityManagerFactory emf = Persistence.createEntityManagerFactory("nwhin_vap_fac_loc");
    private EntityManager em = null;
    private FacilityService facilityService;

    @Before
    public void setUp() throws Exception {

    	// Initialize Entity Managers
        this.em = emf.createEntityManager();
        
        // Initialize JPA DAO Controllers
        FacilityJpaController facilityJpaController = new FacilityJpaController();
        facilityJpaController.setEntityManager(em);
        
        LocationJpaController locationJpaController = new LocationJpaController();
        locationJpaController.setEntityManager(em);
        
        // Initialize FactoryServiceImpl with DAO Controllers
        FacilityServiceImpl facilityServiceImpl = new FacilityServiceImpl();
        facilityServiceImpl.setFacilityController(facilityJpaController);
        facilityServiceImpl.setLocationController(locationJpaController);
        
        Map testUsersAndFacilities = new HashMap();
        testUsersAndFacilities.put("weblogic", "998");
        facilityServiceImpl.setTestUsersAndFacilities(testUsersAndFacilities);
        

        // Associate FactoryServiceImpl with FactoryService
        this.facilityService = facilityServiceImpl;
    }

    @After
    public void tearDown()
    {
        if( this.em != null)
        {
            this.em.close();
            this.em = null;
        }
    }
    @Test
    public void testGetAllVistAFacilities() {

        Collection<Facility> facilities = facilityService.getAllVistAFacilities();
        Assert.assertNotNull(facilities);
        System.out.println("testGetAllVistAFacilities - All Facilities count - [" + facilities.size() + "]. ");
        Assert.assertFalse(facilities.isEmpty());
    }
    
    @Test
    public void testGetAllowedVistAFacilities() {

        Collection<Facility> facilities = facilityService.getAllowedVistAFacilities();
        System.out.println("testGetAllowedVistAFacilities - Supported Facilities - " + facilities);
        Assert.assertNotNull(facilities);
        Assert.assertFalse(facilities.isEmpty());
    }

    @Test
    public void testGetFacilityByStationNumber() {
    	Facility facility = null;
    	try {
            facility = facilityService.getFacilityByStationNumber("983");
    	} catch (Exception e) {
    		Assert.fail("testGetFacilityByStationNumber - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    	Assert.assertNotNull(facility);
        System.out.println("testGetFacilityByStationNumber - Facility - [" +facility.getFacilityStation() + "]. ");
        Assert.assertFalse(!"983".equals(facility.getFacilityStation()));
    }

    @Test
    public void testGetFacilityByStationNumberWithEmptyInput() {

    	try {
            Facility facility = facilityService.getFacilityByStationNumber("");
    	} catch (IllegalArgumentException e) {
    		System.out.println("testGetFacilityByStationNumberWithEmptyInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("testGetFacilityByStationNumberWithEmptyInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }
    
    @Test
    public void testGetFacilityByStationNumberWithNullInput() {

    	try {
            Facility facility = facilityService.getFacilityByStationNumber(null);
    	} catch (IllegalArgumentException e) {
    		System.out.println("testGetFacilityByStationNumberWithNullInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("testGetFacilityByStationNumberWithNullInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }
    
    @Test(expected = EntityDoesNotExistException.class)
    public void testGetFacilityByStationNumberWithInvalidInput() throws EntityDoesNotExistException {

    	try {
            Facility facility = facilityService.getFacilityByStationNumber("RandomFacility");
    	} catch (EntityDoesNotExistException e) {
    		System.out.print("testGetFacilityByStationNumberWithInvalidInput - Service Exception Message - [" + e.getMessage() + "]. ");
    		if (e.getCause() != null) {
        		System.out.println("Cause Exception Message - [" + e.getCause().getMessage() + "]. ");
    		}
    		throw e;
    	}  catch (Exception e) {
    		Assert.fail("testGetFacilityByStationNumberWithInvalidInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }
    
    @Test
    public void testGetLocationByLocationCode() {
    	Location location = null;
    	try {
            location = facilityService.getLocationByCode("ISW");
    	}  catch (Exception e) {
    		Assert.fail("testGetLocationByLocationCode - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    	Assert.assertNotNull(location);
        System.out.print("testGetLocationByLocationCode - Location - [" +location.getLocationCode() + "]. ");
        Assert.assertFalse(!"ISW".equals(location.getLocationCode()));
    	Assert.assertNotNull(location.getFacility());
        System.out.println("testGetLocationByLocationCode - Facility - [" +location.getFacility().getFacilityStation() + "]. ");
    }
    
    @Test
    public void testGetLocationByLocationCodeWithEmptyInput() {
    	Location location = null;
    	try {
            location = facilityService.getLocationByCode("");
    	} catch (IllegalArgumentException e) {
    		System.out.println("testGetLocationByLocationCodeWithEmptyInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("testGetLocationByLocationCodeWithEmptyInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }
    
    @Test
    public void testGetLocationByLocationCodeWithNullInput() {
    	Location location = null;
    	try {
            location = facilityService.getLocationByCode(null);
    	} catch (IllegalArgumentException e) {
    		System.out.println("testGetLocationByLocationCodeWithNullInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("testGetLocationByLocationCodeWithNullInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	} 
    }

    @Test(expected = EntityDoesNotExistException.class)
    public void testGetLocationByLocationCodeWithInvalidInput() throws EntityDoesNotExistException {
    	Location location = null;
    	try {
            location = facilityService.getLocationByCode("RandomLC");
    	} catch (EntityDoesNotExistException e) {
    		System.out.print("testGetLocationByLocationCodeWithInvalidInput - Service Exception Message - [" + e.getMessage() + "]. ");
    		if (e.getCause() != null) {
        		System.out.println("Cause Exception Message - [" + e.getCause().getMessage() + "]. ");
    		}
    		throw e;
    	} catch (Exception e) {
    		Assert.fail("testGetLocationByLocationCodeWithInvalidInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	} 
    }
    
    @Test
    public void getGetVHAUserFacilityWithTestUser() {
    	Facility facility = null;
    	try {
            facility = facilityService.getVHAUserFacility("weblogic");
    	} catch (Exception e) {
    		Assert.fail("getGetVHAUserFacility - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    	Assert.assertNotNull(facility);
        System.out.println("getGetVHAUserFacility - Facility - [" +facility.getFacilityStation() + "]. ");
        Assert.assertFalse(!"998".equals(facility.getFacilityStation()));
    }
    
    @Test
    public void getGetVHAUserFacility() {
    	Facility facility = null;
    	try {
            facility = facilityService.getVHAUserFacility("vhaISwabcd");
    	} catch (Exception e) {
    		Assert.fail("getGetVHAUserFacility - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    	Assert.assertNotNull(facility);
        System.out.println("getGetVHAUserFacility - Facility - [" +facility.getFacilityStation() + "]. ");
    }

    @Test
    public void getGetVHAUserFacilityWithEmptyInput() {
    	Facility facility = null;
    	try {
            facility = facilityService.getVHAUserFacility("");
    	} catch (IllegalArgumentException e) {
    		System.out.println("getGetVHAUserFacilityWithEmptyInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("getGetVHAUserFacilityWithEmptyInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }

    @Test
    public void getGetVHAUserFacilityWithNullInput() {
    	Facility facility = null;
    	try {
            facility = facilityService.getVHAUserFacility(null);
    	} catch (IllegalArgumentException e) {
    		System.out.println("getGetVHAUserFacilityWithNullInput - Service Exception Message - [" + e.getMessage() + "]. ");
    	} catch (Exception e) {
    		Assert.fail("getGetVHAUserFacilityWithNullInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	}
    }

    @Test(expected = EntityDoesNotExistException.class)
    public void getGetVHAUserFacilityWithInvalidInput() throws EntityDoesNotExistException {
    	Facility facility = null;
    	try {
            facility = facilityService.getVHAUserFacility("RandomUID");
    	} catch (EntityDoesNotExistException e) {
    		System.out.print("getGetVHAUserFacilityWithInvalidInput - Service Exception Message - [" + e.getMessage() + "]. ");
    		if (e.getCause() != null) {
        		System.out.println("Cause Exception Message - [" + e.getCause().getMessage() + "]. ");
    		}
    		throw e;
    	} catch (Exception e) {
    		Assert.fail("getGetVHAUserFacilityWithInvalidInput - Unexpected Exception - [" + e.getMessage() + "]. ");
    	} 
    }
}
