/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.facility.jpa.intf;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.PreexistingEntityException;

import java.util.Collection;
import java.util.List;

/**
 * 
 * @author Anand Sastry
 */
public interface LocationControllerInterface {

	void create(Location location) throws PreexistingEntityException, Exception;

	void edit(Location location) throws EntityDoesNotExistException, Exception;

	public Collection<Location> findActiveLocations();

	public Collection<Location> findByFacility(Facility facility) throws EntityDoesNotExistException;

	public Location findByLocationCode(String locationCode) throws EntityDoesNotExistException;

	Location findLocation(Long id);

	List<Location> findLocationEntities();

	List<Location> findLocationEntities(int maxResults, int firstResult);

}
