/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.facility.jpa.intf;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.PreexistingEntityException;

import java.util.Collection;
import java.util.List;

/**
 * 
 * @author vhaiswsastra
 */
public interface FacilityControllerInterface {

	void create(Facility facility) throws PreexistingEntityException, Exception;

	void edit(Facility facility) throws EntityDoesNotExistException, Exception;

	public Collection<Facility> findAllowedFacilities();

	Facility findFacility(Long id);

	public Facility findFacilityByStationNumber(String stationNumber) throws EntityDoesNotExistException;

	List<Facility> findFacilityEntities();

	List<Facility> findFacilityEntities(int maxResults, int firstResult);

}
