/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.facility.jpa.impl;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.PreexistingEntityException;
import gov.va.nvap.svc.facility.jpa.intf.LocationControllerInterface;

import java.util.Collection;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author Anand Sastry
 * 
 */
public class LocationJpaController implements LocationControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final Location location)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(location);
		} catch (final Exception ex) {
			if (this.findLocation(location.getLocationId()) != null) {
				throw new PreexistingEntityException("Location " + location
						+ " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws EntityDoesNotExistException {
		this.entityManager.getTransaction().begin();
		Location location;
		try {
			location = this.entityManager.getReference(Location.class, id);
			location.getLocationId();
		} catch (final EntityNotFoundException enfe) {
			throw new EntityDoesNotExistException("The location with id " + id
					+ " no longer exists.", enfe);
		}
		this.entityManager.remove(location);
		this.entityManager.getTransaction().commit();
	}

	@Override
	public void edit(Location location) throws EntityDoesNotExistException,
			Exception {
		try {
			location = this.entityManager.merge(location);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = location.getLocationId();
				if (this.findLocation(id) == null) {
					throw new EntityDoesNotExistException(
							"The location with id " + id + " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public Collection<Location> findActiveLocations() {
		final Query q = this.entityManager
				.createNamedQuery("Location.findByActive");
		q.setParameter("active", 'Y');
		return q.getResultList();
	}

	@Override
	public Collection<Location> findByFacility(final Facility facility)
			throws EntityDoesNotExistException {
		try {
			final Query q = this.entityManager
					.createNamedQuery("Location.findByFacility");
			q.setParameter("facility", facility);
			return q.getResultList();
		} catch (Exception e) {
			String facilityStation = (facility != null) ? facility
					.getFacilityStation() : "null";
			throw new EntityDoesNotExistException(
					"Cannot find Location for facility [" + facilityStation
							+ "]. ", e);
		}

	}

	@Override
	public Location findByLocationCode(final String locationCode)
			throws EntityDoesNotExistException {
		try {
			final Query q = this.entityManager
					.createNamedQuery("Location.findByLocationCode");
			q.setParameter("locationCode", locationCode);
			return (Location) q.getSingleResult();
		} catch (Exception e) {
			throw new EntityDoesNotExistException(
					"Cannot find Location for locationCode [" + locationCode
							+ "]. ", e);
		}

	}

	@Override
	public Location findLocation(final Long id) {
		return this.entityManager.find(Location.class, id);
	}

	@Override
	public List<Location> findLocationEntities() {
		return this.findLocationEntities(true, -1, -1);
	}

	private List<Location> findLocationEntities(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createQuery("select object(o) from Location as o");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	@Override
	public List<Location> findLocationEntities(final int maxResults,
			final int firstResult) {
		return this.findLocationEntities(false, maxResults, firstResult);
	}

	public int getLocationCount() {
		final Query q = this.entityManager
				.createQuery("select count(o) from Location as o");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}
}
