package gov.va.nvap.svc.facility.jee.wrapper;

import java.util.Collection;


import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityService;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * Exposes the Facility Service as a Local Stateless Session Beam.
 * 
 * @author Anand Sastry
 * 
 */
@Stateless(name = "FacilityService", mappedName = "FacilityService")
@javax.ejb.Remote(FacilityService.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class FacilityServiceFacade implements FacilityService {

	@Autowired
	@Qualifier(value = "FacilityServiceImpl")
	FacilityService facilityService;
	
	@Override
	public Collection<Facility> getAllVistAFacilities() {
		return facilityService.getAllVistAFacilities();
	}

	@Override
	public Collection<Facility> getAllowedVistAFacilities() {
		return facilityService.getAllowedVistAFacilities();
	}

	@Override
	public Facility getFacilityByStationNumber(String id)
			throws EntityDoesNotExistException, IllegalArgumentException {
		return facilityService.getFacilityByStationNumber(id);
	}

	@Override
	public Facility getVHAUserFacility(String vhaUserId)
			throws EntityDoesNotExistException, IllegalArgumentException {
		return facilityService.getVHAUserFacility(vhaUserId);
	}

	@Override
	public Location getLocationByCode(String locationCode)
			throws EntityDoesNotExistException, IllegalArgumentException {
		return facilityService.getLocationByCode(locationCode);
	}
}
