/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.facility.intf;

import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;

import java.util.Collection;

/**
 * 
 * @author vhaiswsastra
 */
public interface FacilityService {

	/**
	 * Gets the list of All VistA Facilities that are a part of the VA.
	 * 
	 * @return The list of all facilities.
	 */
	Collection<Facility> getAllVistAFacilities();

	/**
	 * Gets the list of VistA Facilities that are currently allowed to
	 * participate in the data sharing pilot.
	 * 
	 * @return The list of facilities currently participating.
	 */
	Collection<Facility> getAllowedVistAFacilities();
	
	/**
	 * Gets a VA Facility by Station Number..
	 * 
	 * @param id A station Number such as 983.
	 * @return A Facility corresponding to Station Number.
	 * @throws EntityDoesNotExistException 
	 */
	public Facility getFacilityByStationNumber(String id) throws EntityDoesNotExistException, IllegalArgumentException;

	/**
	 * Gets a facility based on a VHA User id.  A VHA userID format is in the form 
	 * <VHA><3CharLocationCode><First5LastName><First1FirstName>
	 * Ex:        - 3 Char Location code is ISW, for one, M Jordan !!
	 * In other words this method should extract characters between 3-6 from the user id. 
	 * An ideal approach would've been to retrieve a user facility from LDAP, had that been tracked.
	 * 
	 * @param id A Valid VHA User Id.
	 * @return A Facility associated with the VHA User's id.
	 */
	Facility getVHAUserFacility(String vhaUserId) throws EntityDoesNotExistException, IllegalArgumentException;

	/**
	 * Gets a VA Location by Code.
	 * 
	 * Each Facility can have multiple Locations. Here is a list of approved VA location codes 
	 * - http://URL.DNS
	 * 
	 * @param locationCode
	 *            A location code such as ISL, ISW, SLC etc.
	 * @return A location corresponding to location codes.
	 * @throws EntityDoesNotExistException 
	 */
	public Location getLocationByCode(String locationCode) throws EntityDoesNotExistException, IllegalArgumentException;

}
