/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.facility.impl;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.data.Location;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityServiceException;
import gov.va.nvap.svc.facility.intf.FacilityService;
import gov.va.nvap.svc.facility.jpa.impl.FacilityJpaController;
import gov.va.nvap.svc.facility.jpa.impl.LocationJpaController;
import gov.va.nvap.svc.facility.jpa.intf.FacilityControllerInterface;
import gov.va.nvap.svc.facility.jpa.intf.LocationControllerInterface;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.springframework.beans.factory.annotation.Required;

/**
 * 
 * @author Anand Sastry
 */
public class FacilityServiceImpl implements FacilityService {

	private static final Logger logger = Logger.getLogger(FacilityService.class
			.getName());

	private FacilityControllerInterface facilityController;
	private LocationControllerInterface locationController;
	private Map<String, String> testUsersAndFacilities;

	@Override
	public Collection<Facility> getAllowedVistAFacilities() {
		return this.facilityController.findAllowedFacilities();
	}

	@Override
	//public Facility getFacilityByStationId(final String id)
	public Facility getFacilityByStationNumber(final String stationNumber) throws EntityDoesNotExistException, IllegalArgumentException {
		if (NullChecker.isNullOrEmpty(stationNumber)) {
			throw new IllegalArgumentException("Cannot find Facility by Null Or Empty Station Number");
		}
		return this.facilityController.findFacilityByStationNumber(stationNumber);
	}

	@Override
	public Location getLocationByCode(final String locationCode) throws EntityDoesNotExistException, IllegalArgumentException {
		if (NullChecker.isNullOrEmpty(locationCode)) {
			throw new IllegalArgumentException("Cannot find Location by Null Or Empty Location Code");
		}
		return this.locationController.findByLocationCode(locationCode);
	}

	@Override
	public Collection<Facility> getAllVistAFacilities() {
		return this.facilityController.findFacilityEntities();
	}

	@Override
	// public String getUserFacility(String userId) {
	public Facility getVHAUserFacility(String vhaUserId) throws EntityDoesNotExistException {
		if (NullChecker.isNullOrEmpty(vhaUserId)) {
			throw new IllegalArgumentException("Cannot find Facility by Null Or Empty User Id");
		}
		if (this.isTestUser(vhaUserId)) {
			if (logger.isLoggable(Level.INFO)) {
			//	logger.info("UserId["
			//					+ vhaUserId
			//					+ "], is a test user. Retrieving Facility from Spring configuration file");
			}
			return getFacilityByStationNumber(testUsersAndFacilities.get(vhaUserId));
		}
		final String locationCode = extractLocationCode(vhaUserId);
		try  {
			Location loc = getLocationByCode(locationCode);
			return loc.getFacility();
		} catch (Exception e) {
			throw new EntityDoesNotExistException(
					"Cannot find facility for User Id [" + vhaUserId + "]. ",
					e);
		}

	}

	// Initializers
	// Initialize Facility Controller
	@Required
	public void setFacilityController(
			final FacilityJpaController facilityController) {
		this.facilityController = facilityController;
	}
	
	@Required
	// Initialize Location Controller
	public void setLocationController(
			final LocationJpaController locationController) {
		this.locationController = locationController;
	}
	
	@Required
	public void setTestUsersAndFacilities(
			final Map<String, String> testUsersAndFacilities) {
		this.testUsersAndFacilities = testUsersAndFacilities;
	}

	// Private methods

	private static String extractLocationCode(String userId) {
		// UserID format for VHA User :
		// <VHA><3CharLocationCode><First5LastName><First1FirstName>
		// Ex:        - 3 Char Location code is ISW, for one, M Jordan !!
		// In other words this method should extract characters between 3-6 from
		// the string. -- Ugly approach

		if (NullChecker.isNullOrEmpty(userId)) {
			return ""; // empty
		}
		// Location codes are stored in UC in the DB
		userId = userId.trim().toUpperCase(Locale.ENGLISH);
		// userids are at-least 6 chars in length // Note: "VHA"<LOC> is 6
		// chars.
		if (userId.startsWith("VHA") && (userId.length() >= 6)) {
			return userId.substring(3, 6);
		}
		return "";
	}
	
	private boolean isTestUser(final String userId) {
		return !NullChecker.isNullOrEmpty(userId)
				&& (this.testUsersAndFacilities != null)
				&& this.testUsersAndFacilities.keySet().contains(userId);
	}
}
