/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.facility.data;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author Anand Sastry
 */
@Entity
@Table(name = "LOCATION")
@NamedQueries({
		@NamedQuery(name = "Location.findAll", query = "SELECT l FROM Location l"),
		@NamedQuery(name = "Location.findByLocationId", query = "SELECT l FROM Location l WHERE l.locationId = :locationId"),
		@NamedQuery(name = "Location.findByLocationCode", query = "SELECT l FROM Location l WHERE l.locationCode = :locationCode"),
		@NamedQuery(name = "Location.findByFacility", query = "SELECT l FROM Location l WHERE l.facility = :facility"),
		@NamedQuery(name = "Location.findByActive", query = "SELECT l FROM Location l WHERE l.active = :active") })
public class Location implements Serializable {
	private static final long serialVersionUID = 1L;
	@Basic(optional = false)
	@Column(name = "ACTIVE")
	private char active;
	@ManyToOne(optional = false)
	@JoinColumn(name = "FACILITY_ID", referencedColumnName = "FACILITY_ID")
	private Facility facility;
	@Basic(optional = false)
	@Column(name = "LOCATION_CODE")
	private String locationCode;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "LOCATION_ID")
	private Long locationId;

	public Location() {
	}

	public Location(final Long locationId) {
		this.locationId = locationId;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof Location)) {
			return false;
		}
		final Location other = (Location) object;
		if (((this.locationId == null) && (other.locationId != null))
				|| ((this.locationId != null) && !this.locationId
						.equals(other.locationId))) {
			return false;
		}
		return true;
	}

	public char getActive() {
		return this.active;
	}

	public Facility getFacility() {
		return this.facility;
	}

	public String getLocationCode() {
		return this.locationCode;
	}

	public Long getLocationId() {
		return this.locationId;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.locationId != null ? this.locationId.hashCode() : 0);
		return hash;
	}

	public void setActive(final char active) {
		this.active = active;
	}

	public void setFacility(final Facility facility) {
		this.facility = facility;
	}

	public void setLocationCode(final String locationCode) {
		this.locationCode = locationCode;
	}

	public void setLocationId(final Long locationId) {
		this.locationId = locationId;
	}

	@Override
	public String toString() {
		return "gov.va.nvap.svc.facility.data.Location[locationId="
				+ this.locationId + "]";
	}

}
