DELETE  PATIENT_EXCLUDED_ORG;
DELETE  ANNOUNCEMENT;
DELETE  ALLOWED_ORG;
DELETE  FUNCTIONAL_ROLE;
DELETE  PATIENT_DOCUMENT;
DELETE  PATIENT_CONSENT_DIR;
DELETE  CONSENT_TYPE;
DELETE  OPTOUT_REASON;
DELETE  PATIENT_DOCUMENT_TYPE;
DELETE  PURPOSE_OF_USE;
DELETE  LOCATION;
DELETE  FACILITY;
DELETE  AUTHORITY;

-- Insert the Allowed Organizations fro testing purposes.
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NMV', '2.16.840.1.113883.3.190.6.100.1', 'Med Virginia', '*MVA',  'urn:oid:', 'CONTACT ONE', '555-555-5551', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NHKP', '2.16.840.1.113883.3.424', 'ONC InteropLab - Node 1', '*HKP', 'urn:oid:', 'CONTACT TWO', '555-555-5552', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NNC', '2.16.840.1.113883.3.488.1', 'NCHICA', '*NNC', 'urn:oid:', 'CONTACT THREE', '555-555-5553', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NDD', '2.16.840.1.113883.3.425', 'ONC InteropLab - Node 2', '*NDD', 'urn:oid:', 'CONTACT FOUR', '555-555-5554', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NIN', '1.3.6.1.4.1.12009.6.1', 'Indiana Health', '*INH', 'urn:oid:', 'CONTACT FIVE', '555-555-5555', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NWA', '2.16.840.1.113883.3.715', 'Inland Spokane', '*NWA',  'urn:oid:', 'CONTACT SIX', '555-555-5556', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200DOD', '2.16.840.1.113883.3.42.10001.100001.12', 'Department of Defense', '*DoD', 'urn:oid:', 'CONTACT SEVEN', '555-555-5557', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NKP', '1.3.6.1.4.1.26580', 'Kaiser Permanente', '*KP', 'urn:oid:', 'CONTACT EIGHT', '555-555-5558', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NUT', '2.16.840.1.113883.3.709.1.2.1', 'Utah', '*NUT', 'urn:oid:', 'CONTACT NINE', '555-555-5559', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NWS', '1.2.840.114350.1.13.60.3.7.3.688884.100', 'Multicare Health System', '*NWS', 'urn:oid:', 'CONTACT TEN', '555-555-5560', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NSC', '1.3.6.1.4.1.37619', 'South Carolina Health', '*NSC', 'urn:oid:', 'CONTACT ELEVEN', '555-555-5561', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NMN', '1.3.6.1.4.1.31523', 'Minnesota - CHIC', '*NMN', 'urn:oid:', 'CONTACT TWELVE', '555-555-5562', 'Y', 'C');
INSERT INTO ALLOWED_ORG
    (ORG_ID, ORG_NUMBER, ORG_OID, ORG_NAME, ORG_DOMAIN, ORG_COMMUNITY_ID_PREFIX, ORG_CONTACT, ORG_PHONE_NUMBER, ACTIVE, ORG_CONSUMER_ONLY)
 Values
   (ALLOWED_ORG_SEQ.NEXTVAL, '200NWN', '2.25.256133121442266547198931747355024016667.1.2.1', 'Buffalo - WNYCIE', '*NWN', 'urn:oid:', 'CONTACT THIRTEEN', '555-555-5563', 'Y', 'C');


-- INSERT the AUTHORTY lookup data
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.190.6.100.1', 'MVA');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.424', 'HKP');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.488.1', 'NNC');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.425', 'NDD');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '1.3.6.1.4.1.12009.6.1', 'INH');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.715', 'NWA');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.3.42.10001.100001.12', 'USDOD');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '1.3.6.1.4.1.26580', 'KP');
INSERT INTO AUTHORITY
    (AUTHORITY_ID, OID, AUTHORITY_NAME)
 Values
   (AUTHORITY_SEQ.NEXTVAL, '2.16.840.1.113883.4.349', 'USVHA');


-- INSERT the Functional Roles
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Registered Nurse');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Licensed Practical Nurse (LPN)');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Pharmacist');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Physician');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Prosthetist');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Therapist');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Non-licensed Care Practioner');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Medical Technician');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Clerk');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Administrative Support Specialist');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Transcriptionist');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'QA Personnel');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Supervisor');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Supplier');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Functional Consultant, Business Analyst');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Medical Officer');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Database Management');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Telecommunications Specialist, Network Managers');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Security Managers, Security Technician/Administrators');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Applications Developer');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Business Analyst');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Finance Professional');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Quality Assurance Personnel');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Auditor');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Patient Safety Professional');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Information Security Officer');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Legal Counsel');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Accreditor');
INSERT INTO FUNCTIONAL_ROLE
    (FUNCTIONAL_ROLE_ID, NAME)
 VALUES
    (FUNCTIONAL_ROLE_SEQ.NEXTVAL, 'Executive Manager');

-- INSERT the Purpose of Use test data.
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Healthcare Treatment', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Payment and Operations', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Emergency Treatment', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'System Administration', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Research', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Marketing', 'urn:oasis:names:tc:xpsa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Public Health', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
INSERT INTO PURPOSE_OF_USE
    (POU_ID, POU_VALUE, URN)
  VALUES
    (PURPOSE_OF_USE_SEQ.NEXTVAL, 'Programmer Access', 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');

INSERT into CONSENT_TYPE
    (CONSENT_TYPE_ID, NAME)
  VALUES
    (CONSENT_TYPE_SEQ.NEXTVAL, 'NwHIN');

INSERT into CONSENT_TYPE
    (CONSENT_TYPE_ID, NAME)
  VALUES
    (CONSENT_TYPE_SEQ.NEXTVAL, 'EAG');

INSERT into CONSENT_TYPE
    (CONSENT_TYPE_ID, NAME)
  VALUES
    (CONSENT_TYPE_SEQ.NEXTVAL, 'DAS');

INSERT into CONSENT_TYPE
    (CONSENT_TYPE_ID, NAME)
  VALUES
    (CONSENT_TYPE_SEQ.NEXTVAL, 'MHV');

INSERT into CONSENT_TYPE
    (CONSENT_TYPE_ID, NAME)
  VALUES
    (CONSENT_TYPE_SEQ.NEXTVAL, 'SSA');

-- Insert the test Consent Directives.
-- PATIENT 123456
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123456', to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2014-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);
-- PATIENT 123457
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123457', to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'),to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2014-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);
-- PATIENT 123458
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123458', to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'),to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);
-- PATIENT 123459
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123459', to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2011-05-23 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2014-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);
-- PATIENT 123460 - Record 1
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123460', to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2011-05-23 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);
-- PATIENT 123460 - Record 2
INSERT into PATIENT_CONSENT_DIR
    (CONSENT_DIR_ID, PATIENT_IEN, OPTIN_DATE, OPTOUT_DATE, OPTOUT_TS, OPTIN_TS, EXPIRATION_DATE, OPTIN_CONSENT_TYPE_ID, OPTOUT_CONSENT_TYPE_ID, OPTOUT_REASON_ID, POU_ID)
  VALUES
    (PATIENT_CONSENT_DIR_SEQ.NEXTVAL, '123460', to_date('2010-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'),to_date('2010-12-12 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), to_date('2010-01-13 12:00:00', 'YYYY-MM-DD HH24:MI:SS'), to_date('2014-01-01 12:23:45', 'YYYY-MM-DD HH24:MI:SS'), (SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'),(SELECT CONSENT_TYPE_ID FROM CONSENT_TYPE ct WHERE ct.NAME = 'NwHIN'), null, null);

INSERT into PATIENT_EXCLUDED_ORG
    (CONSENT_DIR_ID, ORG_ID)
 values
    ((select CONSENT_DIR_ID from PATIENT_CONSENT_DIR where PATIENT_IEN = '123457'), (select ORG_ID from ALLOWED_ORG where ORG_NAME = 'Med Virginia'));
INSERT into PATIENT_EXCLUDED_ORG
    (CONSENT_DIR_ID, ORG_ID)
 values
    ((select CONSENT_DIR_ID from PATIENT_CONSENT_DIR where PATIENT_IEN = '123457'), (select ORG_ID from ALLOWED_ORG where ORG_NAME = 'Inland Spokane'));

-- INSERT the test Document Types
INSERT into PATIENT_DOCUMENT_TYPE
    (DOCUMENT_TYPE_ID, DOCUMENT_NAME)
 values
    (PATIENT_DOCUMENT_TYPE_SEQ.NEXTVAL, 'OPT-IN');

INSERT into PATIENT_DOCUMENT_TYPE
    (DOCUMENT_TYPE_ID, DOCUMENT_NAME)
 values
    (PATIENT_DOCUMENT_TYPE_SEQ.NEXTVAL, 'OPT-OUT');

-- INSERT the Opt-out Reason test data.
INSERT into OPTOUT_REASON
    (OPTOUT_REASON_ID, TEXT)
 values
    (OPTOUT_REASON_SEQ.NEXTVAL, 'Entered in Error');
INSERT into OPTOUT_REASON
    (OPTOUT_REASON_ID, TEXT)
 values
    (OPTOUT_REASON_SEQ.NEXTVAL, 'Patient Deceased');
INSERT into OPTOUT_REASON
    (OPTOUT_REASON_ID, TEXT)
 values
    (OPTOUT_REASON_SEQ.NEXTVAL, 'Revoked');
INSERT into OPTOUT_REASON
    (OPTOUT_REASON_ID, TEXT)
 values
    (OPTOUT_REASON_SEQ.NEXTVAL, 'Authorization Expired');
INSERT into OPTOUT_REASON
    (OPTOUT_REASON_ID, TEXT)
 values
    (OPTOUT_REASON_SEQ.NEXTVAL, 'New Authorization');


-- insert facility information
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '983', 'NWHIN.TEST.DNS.VA.GOV', 'NwHIN Test Facility Name', 1);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '984', 'NWHIN2.TEST.DNS.VA.GOV', 'NwHIN Test 2 Facility Name', 1);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '521', 'BIRMINGHAMURL        ', 'BIRMINGHAM VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '619', 'CENTRAL-ALABAMAURL        ', 'CENTRAL ALABAMA HEALTH CARE SYSTEM - MONTGOMERY DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '679', 'TUSCALOOSAURL        ', 'TUSCALOOSA VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '463', 'ANCHORAGEURL        ', 'Alaska VA Healthcare System', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '649', 'PRESCOTTURL        ', 'NORTHERN ARIZONA HEALTH CARE SYSTEM - PRESCOTT DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '678', 'TUCSONURL        ', 'SOUTHERN ARIZONA HEALTH CARE SYSTEM - TUCSON DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '564', 'FAYETTVL-ARURL        ', 'FAYETTEVILLE AR, VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '598', 'LITTLE-ROCKURL        ', 'CENTRAL ARKANSAS HEALTH CARE SYSTEM - LITTLE ROCK ', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '570', 'FRESNOURL        ', 'CENTRAL CALIFORNIA HEALTH CARE SYSTEM - FRESNO DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '605', 'LOMA-LINDAURL        ', 'JERRY L. PETTIS MEMORIAL VA MEDICAL CENTER (605)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '600', 'LONG-BEACHURL        ', 'VA LONG BEACH HEALTHCARE SYSTEM', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '612', 'MARTINEZURL        ', 'NORTHERN CALIFORNIA HEALTH CARE SYSTEM - MARTINEZ DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '640', 'PALO-ALTOURL        ', 'PALO ALTO HEALTH CARE SYSTEM - PALO ALTO DIVSION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '664', 'SAN-DIEGOURL        ', 'VA SAN DIEGO HEALTHCARE SYSTEM (664)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '691', 'WEST-LAURL        ', 'VA GREATER LOS ANGELES HEALTHCARE SYSTEM - WEST LOS ANGELES DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '554', 'DENVERURL        ', 'EASTERN COLORADO HEALTH CARE SYSTEM - DENVER DIVSN', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '575', 'GRAND-JUNCTURL        ', 'GRAND JUNCTION (VAMC)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '689', 'WEST-HAVENURL        ', 'CONNECTICUT HEALTH CARE SYSTEM - WEST HAVEN DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '460', 'WILMINGTONURL        ', 'Wilmington Regional Office', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '516', 'BAY-PINESURL        ', 'BAY PINES VA HCS', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '546', 'MIAMIURL        ', 'Broward County VA Clinic', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '573', 'NORTH-FLORIDAURL        ', 'VA NORTH FLORIDA/SOUTH GEORGIA HEALTH SYSTEM - GAINESVILLE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '673', 'TAMPAURL        ', 'JAMES A.HALEY VETERANS HOSPITAL', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '508', 'ATLANTAURL        ', 'ATLANTA VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '557', 'DUBLINURL        ', 'DUBLIN', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '459', 'HONOLULUURL        ', 'Honolulu Regional Office', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '531', 'BOISEURL        ', 'Boise VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '537', 'CHICAGO-WESTURL        ', 'JESSE BROWN VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '550', 'DANVILLEURL        ', 'ILLIANA HCS', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '578', 'HINESURL        ', 'EDWARD J. HINES JR. HOSPITAL', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '556', 'N-CHICAGOURL        ', 'NORTH CHICAGO VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '610', 'NORTHERN-INDIANAURL        ', 'NORTHERN INDIANA HEALTH CARE SYSTEM - MARION DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '583', 'INDIANAPOLISURL        ', 'RICHARD L. ROUDEBUSH VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '596', 'LEXINGTONURL        ', 'LEXINGTON VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '603', 'LOUISVILLEURL        ', 'Louisville VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '502', 'ALEXANDRIAURL        ', 'ALEXANDRIA VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '629', 'NEW-ORLEANSURL        ', 'Veterans Affairs (VA) Medical Center, New Orleans, LA', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '667', 'SHREVEPORTURL        ', 'OVERTON BROOKS VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '512', 'BALTIMOREURL        ', 'BALTIMORE MD VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '518', 'BEDFORD.VA.GOV', 'BEDFORD VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '523', 'BOSTONURL        ', 'VA BOSTON HEALTHCARE SYSTEM - BOSTON DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '631', 'NORTHAMPTONURL        ', 'NORTHAMPTON VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '515', 'BATTLE-CREEKURL        ', 'BATTLE CREEK VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '553', 'DETROITURL        ', 'JOHN D. DINGELL VA MEDICAL CENTER (553)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '585', 'IRON-MTNURL        ', 'Iron Mountain VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '655', 'SAGINAWURL        ', 'Aleda E. Lutz VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '618', 'MINNEAPOLISURL        ', 'MINNEAPOLIS VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '656', 'ST-CLOUDURL        ', 'VAMC ST. CLOUD, MN', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '520', 'BILOXIURL        ', 'VA GULF COAST VETERANS HEALTH CARE SYSTEM', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '586', 'JACKSONURL        ', 'G.V. (SONNY) MONTGOMERY', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '589', 'KANSAS-CITYURL        ', 'VA HEARTLAND - WEST, VISN 15 (589)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '657', 'ST-LOUISURL        ', 'VA HEARTLAND-EAST, VISN 15 HCS JOHN COCHRAN MEMORIAL HOSPITAL', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '436', 'MONTANAURL        ', 'Billings Vet Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '636', 'CENTRAL-PLAINSURL        ', 'VA CENTRAL PLAINS HEALTH NETWORK - OMAHA DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '593', 'LAS-VEGASURL        ', 'SOUTHERN NEVADA HCS', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '654', 'RENOURL        ', 'VA SIERRA NEVADA HEALTH CARE SYSTEM (654)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '608', 'MANCHESTERURL        ', 'MANCHESTER VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '561', 'EAST-ORANGEURL        ', 'NEW JERSEY HEALTH CARE SYSTEM - EAST ORANGE', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '501', 'ALBUQUERQUEURL        ', 'NEW MEXICO VA HEALTH CARE SYSTEM - ALBUQUERQUE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '526', 'BRONXURL        ', 'BRONX VA HOSPITAL', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '620', 'MONTROSEURL        ', 'VA HUDSON VALLEY HEALTH CARE SYSTEM - MONTROSE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '632', 'NORTHPORTURL        ', 'Northport,NY VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '630', 'NY-HARBORURL        ', 'VA NEW YORK HARBOR HEALTHCARE SYSTEM - NEW YORK DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '528', 'V02URL        ', 'VA HEALTHCARE NETWORK UPSTATE NEW YORK SYSTEM - BUFFALO DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '637', 'ASHEVILLEURL        ', 'ASHEVILLE VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '558', 'DURHAMURL        ', 'DURHAM VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '565', 'FAYETTVL-NCURL        ', 'FAYETTEVILLE NC VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '659', 'SALISBURYURL        ', 'SALISBURY,VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '538', 'CHILLICOTHEURL        ', 'CHILLICOTHE, OH VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '539', 'CINCINNATIURL        ', 'CINCINNATI VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '541', 'CLEVELANDURL        ', 'CLEVELAND VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '757', 'COLUMBUSURL        ', 'CHALMERS P. WYLIE VA OUTPATIENT CLINIC (757)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '552', 'DAYTONURL        ', 'DAYTON, OH VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '623', 'MUSKOGEEURL        ', 'MUSKOGEE, OK VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '635', 'OKLAHOMAURL        ', 'OKLAHOMA CITY VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '648', 'PORTLANDURL        ', 'PORTLAND, OREGON VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '653', 'ROSEBURGURL        ', 'ROSEBURG HCS', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '692', 'WHITE-CITYURL        ', 'VA Southern Oregon Rehabilitation Center & Clinics', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '503', 'ALTOONAURL        ', 'JAMES E VAN ZANDT VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '529', 'BUTLERURL        ', 'Butler Veterans Affairs Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '542', 'COATESVILLEURL        ', 'COATESVILLE VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '562', 'ERIEURL        ', 'ERIE VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '595', 'LEBANONURL        ', 'LEBANON VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '642', 'PHILADELPHIAURL        ', 'PHILADELPHIA, PA VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '646', 'PITTSBURGHURL        ', 'PITTSBURGH HEALTH CARE SYSTEM - UNIVERSITY DRIVE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '693', 'WILKES-BARREURL        ', 'WILKES-BARRE VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '650', 'PROVIDENCEURL        ', 'PROVIDENCE VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '534', 'CHARLESTONURL        ', 'RALPH H. JOHNSON VA MEDICAL CENTER (534)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '544', 'COLUMBIA-SCURL        ', 'WM JENNINGS BRYAN DORN VETERANS AFFAIRS MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '568', 'BLACK-HILLSURL        ', 'BLACK HILLS HEALTH CARE SYSTEM - FT. MEADE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '438', 'SIOUX-FALLSURL        ', 'Sioux Falls Regional Office', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '614', 'MEMPHISURL        ', 'MEMPHIS, TN VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '621', 'MTN-HOMEURL        ', 'MOUNTAIN HOME VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '626', 'TENNESSEEVALLEYURL        ', 'VA TENNESSEE VALLEY HEALTHCARE SYSTEM - NASHVILLE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '504', 'AMARILLOURL        ', 'AMARILLO HCS', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '519', 'BIG-SPRINGURL        ', 'WEST TEXAS VA HEALTH CARE SYSTEM - BIG SPRING DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '674', 'CENTRAL-TEXASURL        ', 'CENTRAL TEXAS HEALTH CARE SYSTEM - TEMPLE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '549', 'DALLASURL        ', 'NORTH TEXAS HEALTH CARE SYSTEM - DALLAS DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '756', 'EL-PASOURL        ', 'El Paso VA Health Care System', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '580', 'HOUSTONURL        ', 'MICHAEL E. DEBAKEY VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '671', 'SAN-ANTONIOURL        ', 'SOUTH TEXAS HEALTH CARE SYSTEM - SAN ANTONIO DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '660', 'SALT-LAKEURL        ', 'VA SALT LAKE CITY HEALTH CARE SYSTEM (660)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '590', 'HAMPTONURL        ', 'HAMPTON (VAMC)', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '652', 'RICHMONDURL        ', 'RICHMOND, VA VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '658', 'SALEMURL        ', 'SALEM VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '663', 'PUGET-SOUNDURL        ', 'PUGET SOUND HEALTH CARE SYSTEM - SEATTLE DIVISION', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '668', 'SPOKANEURL        ', 'SPOKANE VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '517', 'BECKLEYURL        ', 'BECKLEY VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '540', 'CLARKSBURGURL        ', 'LOUIS A JOHNSON VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '581', 'HUNTINGTONURL        ', 'Huntington VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '695', 'MILWAUKEEURL        ', 'Clement J Zablocki', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '676', 'TOMAHURL        ', 'TOMAH VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '666', 'SHERIDANURL        ', 'SHERIDAN VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '688', 'WASHINGTONURL        ', 'WASHINGTON', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '358', 'MANILAURL        ', 'Manila Regional Office', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '644', 'PHOENIXURL        ', 'Buckeye VA Health Care Clinic', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '662', 'SANFRANCISCOURL        ', 'San Francisco VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '548', 'WEST-PALMURL        ', 'St Lucie County PTSD Clinical Team (PCT) Outpatient Program', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '509', 'AUGUSTAURL        ', 'Charlie Norwood VA Medical Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '402', 'TOGUSURL        ', 'Detroit Vet Center', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '506', 'ANN-ARBORURL        ', 'VA Ann Arbor Healthcare System', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '437', 'FARGOURL        ', 'Dickinson VA Community Based Outpatient Clinic', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '405', 'WHITE-RIVERURL        ', 'White River Junction Regional Office', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '442', 'DNS ENNEURL        ', 'Cheyenne VA Medical', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '687', 'WALLA-WALLAURL        ', 'JONATHAN M. WAINWRIGHT MEMORIAL VA MEDICAL CENTER', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '613', 'MARTINSBURGURL        ', 'MARTINSBURG VAMC', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '607', 'MADISONURL        ', 'WILLIAM S. MIDDLETON MEMORIAL VA HOSPITAL', 0);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '672', 'SAN-JUANURL        ', 'SAN JUAN VA MEDICAL CENTER', 0);

INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '998', 'VA-Facility1URL        ', 'VA Facility 1', 1);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '999', 'VA-Facility1URL        ', 'VA Facility 2', 1);
INSERT INTO NHIN_VAP.FACILITY (FACILITY_ID, FACILITY_STATION, FACILITY_DNS, FACILITY_NAME, ALLOWED) VALUES (FACILITY_SEQ.NEXTVAL, '988', 'NWHIN5.TEST.DNS.VA.GOV', 'NwHIN Test Facility 5', 1);

INSERT INTO NHIN_VAP.LOCATION (LOCATION_ID, FACILITY_ID, LOCATION_CODE, ACTIVE) SELECT LOCATION_SEQ.NEXTVAL, f.facility_id, 'ISW', 'Y' from NHIN_VAP.FACILITY f where f.facility_station = '463';


-- COMMIT the test data.
COMMIT